﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterDesign.Master" AutoEventWireup="true"
    CodeBehind="ManageGenres.aspx.cs" Inherits="AUDIOTEKA.ManageGenres" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainPlaceHolder" runat="server">
    <h2>
        Správa Žánrov
    </h2>
    <asp:Label AssociatedControlID="AddGenreButton" ID="AddGenreLabel" runat="server"
        Text="Label">Názov nového žánru: </asp:Label>
    <asp:TextBox ID="GenreBox" runat="server">
    </asp:TextBox>
    <asp:Button ID="AddGenreButton" runat="server" Text="Pridať Žáner" OnClick="AddGenreButton_Click" />
    <br />
    <asp:Label ID="Label_GenreExists" runat="server" ForeColor="Red" Text="Žáner s daným názvom už existuje!"></asp:Label>
    <br />
    <br />
    <asp:PlaceHolder ID="EditPlaceHolder" runat="server">
        <h3 id="EditNadpis" runat="server">
        </h3>
        <asp:Label AssociatedControlID="EditGenreBox" ID="EditGenreLabel" runat="server"
            Text="Label">Nový názov žánru: </asp:Label>
        <asp:TextBox ID="EditGenreBox" runat="server">
        </asp:TextBox>&nbsp;
        <asp:Button ID="EditGenreButton" runat="server" Text="Zmeniť názov" OnClick="EditGenreButton_Click" />
        <br />
        <asp:Label ID="EditGenreExistsLabel" runat="server" ForeColor="Red" Text="Žáner s daným názvom už existuje!"></asp:Label>
        <asp:HiddenField ID="EditHiddenField" runat="server" />
        <br />
        <br />
    </asp:PlaceHolder>
    <asp:GridView AllowPaging="true" PageSize="10" ID="GenresGridView" DataKeyNames="GenreId"
        runat="server" AutoGenerateColumns="false" OnPageIndexChanging="GenresGridView_PageChanged"
        OnRowEditing="GenresGridView_RowEdit" OnRowDeleting="GenresGridView_RowDelete">
        <RowStyle CssClass="rowA" />
        <AlternatingRowStyle CssClass="rowB" />
        <HeaderStyle CssClass="rowH" BorderColor="Black" ForeColor="White" Font-Underline="false" />
        <Columns>
            <asp:HyperLinkField ItemStyle-BorderColor="Black" SortExpression="GenreName" HeaderText="Hudobný žáner"
                DataNavigateUrlFields="GenreName" DataNavigateUrlFormatString="~/AlbumPage.aspx?genre={0}"
                DataTextField="GenreName" ItemStyle-Width="25em" />
            <asp:CommandField HeaderText="Akcia" ItemStyle-BorderColor="Black" ShowEditButton="true"
                ShowDeleteButton="true" DeleteText="Zmazať" EditText="Upraviť" />
        </Columns>
        <PagerStyle BorderStyle="Solid" BorderWidth="1px" BorderColor="white" />
    </asp:GridView>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftPlaceHolder" runat="server">
</asp:Content>
