﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;

namespace AUDIOTEKA
{
    public class MyAlbumItem : PersonalAlbum
    {
        private string _ArtistName;
        private string _GenreName;
        private string _AlbumName;
        private System.Nullable<int> _Year;

        public System.Nullable<int> Year
        {
            get
            {
                return this._Year;

            }
            set
            {
                if ((this._Year != value))
                {
                    this._Year = value;
                }
            }
        }
        public string AlbumName
        {
            get
            {
                return this._AlbumName;
            }
            set
            {
                if ((this._AlbumName != value))
                {
                    this._AlbumName = value;
                }
            }
        }
        public string ArtistName
        {
            get
            {
                return this._ArtistName;
            }
            set
            {
                if ((this._ArtistName != value))
                {
                    this._ArtistName = value;
                }
            }
        }
        public string GenreName
        {
            get
            {
                return this._GenreName;
            }
            set
            {
                if ((this._GenreName != value))
                {
                    this._GenreName = value;
                }
            }
        }

    }


    public class MyAlbumItems
    {
        public static IEnumerable<MyAlbumItem> Select()
        {

            MembershipUser myUser = Membership.GetUser();
            Guid UserID = (Guid)myUser.ProviderUserKey;

            DataClassesDataContext db = new DataClassesDataContext();

            return from myAlb in db.PersonalAlbums

                   join alb in db.Albums
                   on myAlb.AlbumId equals alb.AlbumId

                   join g in db.Genres
                   on alb.GenreId equals g.GenreId

                   join art in db.Artists
                   on alb.ArtistId equals art.ArtistId

                   where myAlb.UserId == UserID

                   select new MyAlbumItem { Year = alb.Year, ArtistName = art.FirstName + " " + art.LastName, UserId = myAlb.UserId, GenreName = g.GenreName, AlbumId = alb.AlbumId, AlbumName = alb.AlbumName, Quality = myAlb.Quality, Rating = myAlb.Rating, StorageMedium = myAlb.StorageMedium };
        }

        public static IEnumerable<MyAlbumItem> SelectPage(int startRowIndex, int maximumRows)
        {
            return Select().Skip(startRowIndex).Take(maximumRows);
        }
        public static int SelectCount()
        {
            return Select().Count();
        }

        public static void DeleteAlbum(int AlbId)
        {

        }

    }
}
