<?php

//--------------------------------INCLUDES-------------------------------

include_once "../lib/init.php";
require_once "../lib/kaspar.php";
require_once "../lib/sessions.php";
require_once "functions.php";
require_once "../lib/messages.php";


//--------------------------------CONSTANTS------------------------------

$smarty_prefix="eRiesenie";
$solutions_dir = "riesenia";

$kaspar = Kaspar::getInstance();
$session = SessionManager::getInstance();
$msg = new Messages();
//--------------------------------DEFALUTS-------------------------------


$defaults=array( //potahaj s openid:-), potom potahaj z kaspara
'id' => '',
'firstname' => '',
'lastname' => '',
'birthday_day' => '1',
'birthday_month' => '1',
'birthday_year' => '1947',
'school' => '1',
'finish' => '',
'corespondence' => '0',
'adrstreet' => '',
'corstreet' => '',
'adrtown' => '',
'cortown' => '',
'adrpsc' => '',
'corpsc' => '',
'email' => '',
'phone' => '',
'im' => '',
'poznamka' => ''
);

$dtypes=array();

$good=array();
foreach($defaults as $key=>$value){
    if($_POST['submit']=='submitted')$good[$key]=false;
    else $good[$key]=true;
    $dtypes[]=$key;
}

$needed=array(
'firstname',
'lastname',
'birthday_day',
'birthday_month',
'birthday_year',
'school',
'finish',
'corespondence',
'adrstreet',
'adrtown',
'adrpsc',
'email'
);

if(isset($_GET['needed'])){
    $arr=explode(",",$_GET['needed']);
    foreach($arr as $slovo){
	$slovo=trim($slovo);
	if($slovo!=""&&!in_array($slovo,$needed))$needed[]=$slovo;
    }
}


$redirect=NULL;

if(isset($_GET['return'])){
    $redirect=urlencode($_GET['return']);
}

$needs=array();

foreach($defaults as $key=>$value){
    if(in_array($key,$needed))
	$needs[$key]=true;
    else
	$needs[$key]=false;
}


for($i=1;$i<=31;$i++)$days[$i]=$i;

$months=array(
'1' => 'Január',
'2' => 'Február',
'3' => 'Marec',
'4' => 'Apríl',
'5' => 'Máj',
'6' => 'Jún',
'7' => 'Júl',
'8' => 'August',
'9' => 'September',
'10' => 'Október',
'11' => 'November',
'12' => 'December'
);

$monthday=array(
'1'=>'31',
'2'=>'29',
'3'=>'31',
'4'=>'30',
'5'=>'31',
'6'=>'30',
'7'=>'31',
'8'=>'30',
'9'=>'31',
'10'=>'30',
'11'=>'31',
'12'=>'30'
);

$schools=$kaspar->getSchools();
function cmp($a,$b){
    if($a['name']<$b['name'])return -1;
    if($a['name']>$b['name'])return 1;
    return 0;
}
usort($schools,"cmp");

$corespo=array(
'0' => 'Domov',
'1' => 'Do školy',
'2' => 'Na adresu pre korešpondenciu'
);

//--------------------------------OPENID - KASPAR------------------------

//Ak som prihlaseny, tak vyhonaj dalsie akcie,
//ak nie, tak sa treba prihlasit

$user_openid = $session->getCurrentUser();
$user_id=NULL;
$user_nick=NULL;
$user_name=NULL;
if( $user_openid != false ){
    $row = $kaspar->getMappingByLogin($user_openid);
    if( $row != NULL ){
	$user_id = $row['man_id'];
	$user_nick = $row['nick'];
	$defaults['id']=$user_id;
    }
    $user_name=$session->getValue('fullname');
}

//--------------------------------UPDATE DETAILS FROM OPENID-------------

// TODO: asi ani nebude

if($user_openid!=NULL){
    
    $email=$session->getValue('email');
    if($email!=NULL||$email!="")$defaults['email']=$email;
    
    $name=$session->getValue('fullname');
    $names=explode(" ",trim($name));
    $names[0]=trim($names[0]);
    $names[1]=trim($names[1]);
    if($names[0]!="")$defaults['firstname']=$names[0];
    if($names[1]!="")$defaults['lastname']=$names[1];
    
    $data=$session->getValue('dob');
    if($data!=""&&$data!=NULL){                   
	    $date=strtotime($data);
	    $day=date('j',$date);
	    $month=date('n',$date);
	    $year=date('Y',$date);
            $defaults['birthday_day']=0+$day;
            $defaults['birthday_month']=0+$month;
            $defaults['birthday_year']=0+$year;
    }
}

//--------------------------------UPDATE DETAILS FROM KASPAR-------------

if($user_id!=NULL){
    $data=$kaspar->getPeople($user_id);
    if($data['firstname']!=""&&$data['firstname']!=NULL)$defaults['firstname']=$data['firstname'];
    if($data['lastname']!=""&&$data['lastname']!=NULL)$defaults['lastname']=$data['lastname'];
    if($data['school_id']!=""&&$data['school_id']!=NULL)$defaults['school']=$data['school_id'];
    if($data['send']!=""&&$data['send']!=NULL)$defaults['corespondence']=$data['send'];
    if($data['home_street']!=""&&$data['home_street']!=NULL)$defaults['adrstreet']=$data['home_street'];
    if($data['home_city']!=""&&$data['home_city']!=NULL)$defaults['adrtown']=$data['home_city'];
    if($data['home_zip']!=""&&$data['home_zip']!=NULL)$defaults['adrpsc']=$data['home_zip'];
    if($data['coresp_street']!=""&&$data['coresp_street']!=NULL)$defaults['corstreet']=$data['coresp_street'];
    if($data['coresp_city']!=""&&$data['coresp_city']!=NULL)$defaults['cortown']=$data['coresp_city'];
    if($data['coresp_zip']!=""&&$data['coresp_zip']!=NULL)$defaults['corpsc']=$data['coresp_zip'];
    if($data['finish']!=""&&$data['finish']!=NULL)$defaults['finish']=$data['finish'];

    $data=$kaspar->getPeopleBirthdate($user_id);
    if($data!=""&&$data!=NULL){
	$date=strtotime($data);
	$day=date('j',$date);
	$month=date('n',$date);
	$year=date('Y',$date);
        $kk=findChar($data,".-",0);
        $defaults['birthday_day']=0+$day;
        $defaults['birthday_month']=0+$month;
        $defaults['birthday_year']=0+$year;
    }

    $data=$kaspar->getPeopleEmail($user_id);
    if($data!=""&&$data!=NULL)$defaults['email']=$data;

    $data=$kaspar->getPeoplePhone($user_id);
    if($data!=""&&$data!=NULL)$defaults['phone']=$data;

    $data=$kaspar->getPeopleIM($user_id);
    if($data!=""&&$data!=NULL)$defaults['im']=$data;
}

//--------------------------------PARSE INPUT----------------------------


//  Tuto cast bude chciet niekedy prepisat a napisat to cistejsie -- vsak sa
//  tam kod opakuje vkuse...

if($user_openid!=NULL&&$_POST['submit']=='submitted'){
    $post=array();

    foreach($defaults as $key => $value){
	$post[$key]=$_POST[$key];
    }
    
    //id
    if($user_id==NULL){
	if(is_number($post['id'])&&$kaspar->existsUserID($post['id'])){
	    $defaults['id']=$post['id'];
	    $good['id']=true;
	}else{
	    $good['id']=false;
	}
    }else $good['id']=true;
    //firstname
    if($post['firstname']!=""){
	$defaults['firstname']=$post['firstname'];
	$good['firstname']=true;
    }
    else{
	$good['firstname']=false;
    }
    //lastname
    if($post['lastname']!=""){
	$defaults['lastname']=$post['lastname'];
	$good['lastname']=true;
    }
    else{
	$good['lastname']=false;
    }
    //birthday
    if(is_number($post['birthday_day'])&&is_number($post['birthday_month'])&&is_number($post['birthday_year'])){
	$d=$post['birthday_day'];
	$m=$post['birthday_month'];
	$y=$post['birthday_year'];
	if($m>=1&&$m<=12&&$d>=1&&$d<=$monthday[$m]&&$y!=""){
	    $defaults['birthday_day']=$d;
	    $defaults['birthday_month']=$m;
	    $defaults['birthday_year']=$y;
	    $good['birthday_day']=$good['birthday_month']=$good['birthday_year']=true;
	}else{
	    $good['birthday_day']=$good['birthday_month']=$good['birthday_year']=false;
	}
	
    }else{ 
	    $good['birthday_day']=$good['birthday_month']=$good['birthday_year']=false;
	    }
    //school
    if(is_number($post['school'])&&$kaspar->existsSchoolID($post['school'])){
	$defaults['school']=$post['school'];	
	$good['school']=true;
    }else{
	$good['school']=false;
    }
    //finish
    if(is_number($post['finish'])&&$post['finish']>1947){
	$defaults['finish']=$post['finish'];
	$good['finish']=true;
    }else{
	$good['finish']=false;
    }
    
    //corespondence
    if(is_number($post['corespondence'])&&$post['corespondence']>=0&&$post['corespondence']<=2){
	$defaults['corespondence']=$post['corespondence'];
	$good['corespondence']=true;
    }else{
	$good['corespondence']=false;
    }
    //adr1
    if($post['adrstreet']!=""){
	$defaults['adrstreet']=$post['adrstreet'];
	$good['adrstreet']=true;
    }
    else{
	$good['adrstreet']=false;
    }
    if($post['adrtown']!=""){
	$defaults['adrtown']=$post['adrtown'];
	$good['adrtown']=true;
    }
    else{
	$good['adrtown']=false;
    }
    if($post['adrpsc']!=""){
	$defaults['adrpsc']=$post['adrpsc'];
	$good['adrpsc']=true;
    }
    else{
	$good['adrpsc']=false;
    }
    //adr2
    if($post['corstreet']!=""){
	$defaults['corstreet']=$post['corstreet'];
	$good['corstreet']=true;
    }
    else{
	$good['corstreet']=false;
    }
    if($post['cortown']!=""){
	$defaults['cortown']=$post['cortown'];
	$good['cortown']=true;
    }
    else{
	$good['cortown']=false;
    }
    if($post['corpsc']!=""){
	$defaults['corpsc']=$post['corpsc'];
	$good['corpsc']=true;
    }
    else{
	$good['corpsc']=false;
    }
    //email
    if(ereg(".*@.*\\..*",$post['email'])){
	$defaults['email']=$post['email'];
	$good['email']=true;
    }else{
	$good['email']=false;
    }
    //phone
    if($post['phone']!=""){
	$defaults['phone']=$post['phone'];
	$good['phone']=true;
    }else{
	$good['phone']=false;
    }
    //im
    if($post['im']!=""){
	$defaults['im']=$post['im'];
	$good['im']=true;
    }
    else{
	$good['im']=false;
    }
    //poznamka
    if($post['poznamka']!=""){
	$defaults['poznamka']=$post['poznamka'];
	$good['poznamka']=true;
    }
    else{
	$good['poznamka']=false;
    }


}

//--------------------------------UPDATE DATA----------------------------

$errmsgs=array();

if($user_openid!=NULL&&$_POST['submit']=='submitted'){

    $updateable=true;
    
    
    foreach($needed as $value){
	if(!in_array($value,$dtypes))continue;
        if(!$good[$value]){
    	$updateable=false;
	$errmsgs[]=$value;
        }
    }
    
    
    if($updateable){
        if($user_id==NULL){//NOVY CLOVEK
    	if($kaspar->addRegistrant($defaults,$user_openid,$user_name)){
    	    $msg->addMsg("Bol si úspešne zaregistrovaný. ");
    	}else{
    	    $msg->addErr("Pri registrácii došlo k chybe. Skús to odovzdať ešte raz.");
    	}
        }else{
	    $hoho=true;
	    $key='firstname';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleFirstname($user_id,$defaults[$key]);
	    $key='lastname';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleLastname($user_id,$defaults[$key]);
	    $key='finish';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleFinish($user_id,$defaults[$key]);
	    $key='school';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleSchoolID($user_id,$defaults[$key]);
	    $key='corespondence';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleSend($user_id,$defaults[$key]);
	    $key='adrstreet';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleHomeStreet($user_id,$defaults[$key]);
	    $key='adrtown';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleHomeCity($user_id,$defaults[$key]);
	    $key='adrpsc';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleHomeZip($user_id,$defaults[$key]);
	    $key='corstreet';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleCorespStreet($user_id,$defaults[$key]);
	    $key='cortown';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleCorespCity($user_id,$defaults[$key]);
	    $key='corpsc';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleCorespZip($user_id,$defaults[$key]);
	    $key='email';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleEmail($user_id,$defaults[$key]);
    	    $key='im';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeopleIM($user_id,$defaults[$key]);
	    $key='phone';
	    if($defaults[$key]!=""&&$good[$key])
		$hoho&=$kaspar->setPeoplePhone($user_id,$defaults[$key]);
	    //birthdate
	    if($good['birthday_day']&&$good['birthday_month']&&$good['birthday_year'])
		$hoho&=$kaspar->setPeopleBirthdate($user_id,$defaults['birthday_day'].".".$defaults['birthday_month'].".".$defaults['birthday_year']);
	    if($hoho)
	    $msg->addMsg("Tvoje údaje boli úspešne zmenené.");
	    else
	    $msg->addErr("Nie všetky údaje sa podarilo zmeniť. Skús ich vyplniť znova.");
	}
    }else{
	$msg->addErr("Niektoré údaje, ktoré si zadal sú zlé: ".implode(", ",$errmsgs));
    }

}

//--------------------------------HEADER---------------------------------

$GLOBALS['ksp_smarty']->template_dir = 'templates/';
$GLOBALS['ksp_smarty']->assign('css',array('css/style.css'));
$GLOBALS['ksp_smarty']->display('header.tpl');
$GLOBALS['ksp_smarty']->template_dir = 'ePrihlaska/templates/';

//--------------------------------SIGN IN PLEASE-------------------------

if($user_openid==NULL||$user_id==NULL){//TODO: je podmienka spravna?
    if($user_openid==NULL)
	$GLOBALS['ksp_smarty']->assign('login','false');
    else
	$GLOBALS['ksp_smarty']->assign('login','true');
    if($user_id==NULL)
	$GLOBALS['ksp_smarty']->assign('id','false');
    else
	$GLOBALS['ksp_smarty']->assign('id','true');
    $GLOBALS['ksp_smarty']->display('login.tpl');
}


//--------------------------------FORM-----------------------------------
if($user_openid!=NULL){
    if($user_id==NULL)
	$GLOBALS['ksp_smarty']->assign('id','false');
    else
	$GLOBALS['ksp_smarty']->assign('id',$user_id);
    $GLOBALS['ksp_smarty']->assign('days',$days);
    $GLOBALS['ksp_smarty']->assign('months',$months);
    $GLOBALS['ksp_smarty']->assign('schools',$schools);
    $GLOBALS['ksp_smarty']->assign('corespo',$corespo);
    $GLOBALS['ksp_smarty']->assign('good',$good);
    $GLOBALS['ksp_smarty']->assign('needs',$needs);
    $GLOBALS['ksp_smarty']->assign('defaults',$defaults);
    $GLOBALS['ksp_smarty']->assign('neededget',$_GET['needed']);
    $GLOBALS['ksp_smarty']->display('form.tpl');
}



//--------------------------------FOOTER---------------------------------

$GLOBALS['ksp_smarty']->template_dir = 'templates/';
$GLOBALS['ksp_smarty']->display('footer.tpl');
?>
