<?php

//--------------------------------INCLUDES-------------------------------

include_once "../lib/init.php";
require_once "../lib/kaspar.php";
require_once "../lib/sessions.php";
require_once "functions.php";

//--------------------------------HEADER---------------------------------

$GLOBALS['ksp_smarty']->template_dir = 'templates/';
$GLOBALS['ksp_smarty']->assign('css',array('css/style.css'));
$GLOBALS['ksp_smarty']->display('header.tpl');
$GLOBALS['ksp_smarty']->template_dir = 'eRiesenie/templates/';

//--------------------------------CONSTANTS------------------------------

$smarty_prefix="eRiesenie";
$solutions_dir = "riesenia";

$kaspar = Kaspar::getInstance();
$session = SessionManager::getInstance();
$max_file_size = 1024*512;

$extensions['text']=array('pdf','txt');
$extensions['solutions']=array('xxx');


//--------------------------------OPENID - KASPAR------------------------

//Ak som prihlaseny, tak vyhonaj dalsie akcie,
//ak nie, tak sa treba prihlasit

$user_openid = $session->getCurrentUser();
$user_id=NULL;
$user_nick=NULL;
if( $user_openid != false ){
    $row = $kaspar->getMappingByLogin($user_openid);
    if( $row != NULL ){
	$user_id = $row['man_id'];
	$user_nick = $row['nick'];
    }
}

//--------------------------------SIGN IN PLEASE-------------------------

if($user_openid==NULL){
    $GLOBALS['ksp_smarty']->display('login.tpl');
}

$url=$kaspar->checkPeopleValueAndGetUrl($user_id,array('firstname','lastname','finish','school','home_address','email','birthdate','finish'));

if($url!=NULL){
    $GLOBALS['ksp_smarty']->assign('url',$url);
    $GLOBALS['ksp_smarty']->display('register.tpl');
}

//--------------------------------SELECT ROUND ID------------------------
$round_id=NULL;
$round_runs=true;

if(isset($_GET['round'])&&$user_id!=NULL){
    $round=0+addslashes($_GET['round']);
    if(sizeof($kaspar->getRound($round)>0))
	$round_id=$round;
    if(sizeof($kaspar->getActualRound($round_id))<=0)$round_runs=false;
}

if($round_id==NULL&&$user_id!=NULL){
    $rr=array();
    $ll=array();
    $rounds=$kaspar->getActualRounds();
    $last_round=-1;
    foreach($rounds as $r){
	$id=$r['round_id'];
	$end=$r['deadline'];
	if($last_round!=$id){
	    $r=$kaspar->getRound($id);
	    $c=$kaspar->getContests($r['contest_id']);
	    if($last_round!=-1){
		$rr[]=$ll;
		$ll=array();
	    }
	    $ll['text']=$c['name'];

	}
	$mm['rid']=$r['round_id'];
	$mm['text']=$r['name'];
	$ll['tasks'][]=$mm;
	$last_round=$id;
    }
    if($last_round!=-1&&sizeof($ll)>0){
	$rr[]=$ll;
    }
    $GLOBALS['ksp_smarty']->assign('round',$rr);
    $GLOBALS['ksp_smarty']->assign('text','Aktuálne súťaže');
    $GLOBALS['ksp_smarty']->display('selectround.tpl');
    //-----PAST ROUNDS
    $rr=array();
    $ll=array();
    $rounds=$kaspar->getPastRounds();
    $last_round=-1;
    foreach($rounds as $r){
	$id=$r['round_id'];
	$end=$r['deadline'];
	if($last_round!=$id){
	    $r=$kaspar->getRound($id);
	    $c=$kaspar->getContests($r['contest_id']);
	    if($last_round!=-1){
		$rr[]=$ll;
		$ll=array();
	    }
	    $ll['text']=$c['name'];

	}
	$mm['rid']=$r['round_id'];
	$mm['text']=$r['name'];
	$ll['tasks'][]=$mm;
	$last_round=$id;
    }
    if($last_round!=-1&&sizeof($ll)>0){
	$rr[]=$ll;
    }
    $GLOBALS['ksp_smarty']->assign('round',$rr);
    $GLOBALS['ksp_smarty']->assign('text','Staré súťaže');
    $GLOBALS['ksp_smarty']->display('selectround.tpl');

}

//--------------------------------CREATE DIRECTORY STRUCTURE-------------

$tasks = NULL;

if( ($user_id != NULL) && ($round_id != NULL) ){
    $tasks = $kaspar->getRoundTasks($round_id);
    if($round_runs){
	check_and_create_directory($solutions_dir);
	check_and_create_directory("$solutions_dir/$round_id");
	check_and_create_directory("$solutions_dir/$round_id/$user_id");
	foreach ($tasks as $i){
	    check_and_create_directory("$solutions_dir/$round_id/$user_id/$i[task_id]");
	}
    }
}

//--------------------------------PARSE UPLOADED FILES-------------------

if ($round_runs && ($tasks != NULL) && ($user_id != NULL) && ($round_id != NULL) && (addslashes($_POST['submit'])=="submitted")){
    $errors = array();
    $messages = array();
    foreach ($tasks as $i){
	foreach ($extensions as $type => $extension){
	    $task_id=$i['task_id'];
	    $num=$i['num'];
	    $fid=getFileId($task_id,$type);

	    if ($_FILES[$fid]['error'] >0 && $_FILES[$fid]['error']!=UPLOAD_ERR_NO_FILE){
	        
		$errors[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Chyba pri uploadovaní. Skús znova. Chyba číslo: ".$_FILES[$fid]['error'];
	    
	    }elseif($_FILES[$fid]['error']==UPLOAD_ERR_OK){
	        $filename=$_FILES[$fid]['name'];
	        $ext=getFileExtension($filename);
		$good=false;
	        foreach($extension as $xt){
		    if($ext==$xt)$good=true;
		    if($xt=='xxx')$good=true;
		}
	        if (!$good) {
		    

		    $errors[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Súbor nemá platnú koncovku. Odovzdaj ho prosím v správnom formáte.";

	        
		}else{
		    $newfilename=getFileName($filename,$task_id,$type,$user_id);
		    $path="$solutions_dir/$round_id/$user_id/$task_id/$newfilename";
		    if(!file_exists($_FILES[$fid]['tmp_name'])){
        		
			$errors[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Súbor neexistuje";
        
		    }else{
			if($_FILES[$fid]['size']>$max_file_size){

			    $errors[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Súbor je príliš veľký.";

			}else{
			    if(!move_uploaded_file($_FILES[$fid]['tmp_name'],$path)){
                			
				$errors[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Súbor sa nepodarilo presunúť na správne miesto. Prosím skús znova.";
                
			    }else{
			        $oldfile=$kaspar->getUserSolutionFile($user_id,$task_id,$type);
			        $res;
			        if($oldfile==NULL)
				    $res=$kaspar->insertUserSolutionFile($user_id,$task_id,$type,$newfilename)&
                                         $kaspar->insertSolution($user_id,$task_id,"..",true);
        			else 
        		            $res=$kaspar->updateUserSolutionFile($user_id,$task_id,$type,$newfilename);
        			if($res){
        			    if($oldfile != NULL && $newfilename!=$oldfile)
                                        unlink("$solutions_dir/$round_id/$user_id/$task_id/$oldfile");
					$messages[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Súbor bol úspešne  odovzdaný.";
        			
				}else{
        			    delete($path);
        				
				    $errors[]="Príklad $num, súbor ".$_FILES[$fid]['name'].": Chyba v databáze. Skús znova.";
        			    
        			}
                            }
			}
		    }
        	}
            }
	}
    }
    $GLOBALS['ksp_smarty']->assign('errors',$errors);
    $GLOBALS['ksp_smarty']->assign('messages',$messages);
    $GLOBALS['ksp_smarty']->display('uploading.tpl');
}

//--------------------------------SUBMITTED STATUS-----------------------

if ( ($tasks != NULL) && ($user_id != NULL) && ($round_id != NULL)){
    //vzorake
    $r1=$kaspar->getEround($round_id);
    $past=$kaspar->isPastRound($round_id);
    if($past)$past="true";else $past="false";
    $solv=$kaspar->solvedRound($round_id,$user_id);
    if($solv)$solv="true";else $solv="false";
    $je_vzorak="true";
    if($r1['solution_file']=="")$je_vzorak="false";
    //status

    $sub=array();
    foreach ($tasks as $i){
	$arr=array();
	$arr['num']=$i['num'];
	$task_id=$i['task_id'];
	foreach ($extensions as $type => $extension){
	    $filename=$kaspar->getUserSolutionFile($user_id,$task_id,$type);
	    if($filename!=NULL){
		$arr[$type]=$filename;
		$arr[$type."_data"]="file=$filename&user=$user_id&task=$task_id&round=$round_id";
	    }else{
		$arr[$type]="";
	    }
	}
	$sub[]=$arr;
    }
    $GLOBALS['ksp_smarty']->assign('je_vzorak',$je_vzorak);
    $GLOBALS['ksp_smarty']->assign('kolo_skoncilo',$past);
    $GLOBALS['ksp_smarty']->assign('riesil',$solv);
    $GLOBALS['ksp_smarty']->assign('round',$round_id);
    $GLOBALS['ksp_smarty']->assign('files',$sub);
    $GLOBALS['ksp_smarty']->display('submitted.tpl');
}

//--------------------------------UPLOAD FORM----------------------------




if ($round_runs && ($tasks != NULL) && ($user_id != NULL) && ($round_id != NULL) ){
    $form=array();
    foreach ($tasks as $i){
	$num=$i['num'];
	$task_id=$i['task_id'];	
	$fid1=getFileId($task_id,"text");
	$fid2=getFileId($task_id,"solutions");
	$form[]=array("num"=> $num, "popis"=>$fid1, "kod"=>$fid2);
    }
    $GLOBALS['ksp_smarty']->assign('files',$form);
    $GLOBALS['ksp_smarty']->display('form.tpl');
}

//--------------------------------FOOTER---------------------------------

$GLOBALS['ksp_smarty']->template_dir = 'templates/';
$GLOBALS['ksp_smarty']->display('footer.tpl');


//Prihlasenie do databazy
//define('DB_DSN','psql:host=localhost;dbname=test');
//$db = new PDO(DB_DSN, DB_USER, DB_PASS);
//$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

//$db->setAttribute(PDO::POSTGRESQL_ATTR_USE_BUFFERED_QUERY, true);

//$db->prepare("set names 'utf8'")->excecute(); //naozaj toto?

//$select = $db->prepare('SELECT task_id, num, name 
//                          FROM tasks
//			  WHERE round_id=:r
//			  ORDER BY num');
//$select->bindValue(':r',$round_id);

//if($select->execute()){
//    throw new Exception('Databaza nefunguje');
//}

//while($data = $select->fetch(FETCH_ASSOC)){
//    $task_id=$data['task_id'];
//    $num = $data['num'];
//    $name = $data['name'];
//    $idfile1=$task_id.".pokec";
//    $idfile2=$task_id.".source";
//}


//form_header("");

//while($data = $select->fetch(FETCH_ASSOC)){
//    $task_id=$data['task_id'];
//    $num = $data['num'];
//    $name = $data['name'];


//}

//form_footer();

?>
