<?php
/**
 * MyBB 1.2
 * Copyright  2006 MyBB Group, All Rights Reserved
 *
 * Website: http://www.mybboard.net
 * License: http://www.mybboard.net/eula.html
 *
 * $Id: portal.php 3635 2008-02-06 23:19:49Z Tikitiki $
 */

define("IN_MYBB", 1);
define("IN_PORTAL", 1);

// set the path to your forums directory here (without trailing slash)
$forumdir = "./";

// end editing

$change_dir = "./";

if(!@chdir($forumdir) && !empty($forumdir))
{
	if(@is_dir($forumdir))
	{
		$change_dir = $forumdir;
	}
	else
	{
		die("\$forumdir is invalid!");
	}
}

$templatelist = "portal_welcome,portal_welcome_membertext,portal_stats,portal_search,portal_whosonline_memberbit,portal_whosonline,portal_latestthreads_thread_lastpost,portal_latestthreads_thread,portal_latestthreads,portal_announcement_numcomments_no,portal_announcement,portal_announcement_numcomments,portal";

require_once $change_dir."/global.php";
require_once MYBB_ROOT."inc/functions_post.php";
require_once MYBB_ROOT."inc/functions_user.php";
require_once MYBB_ROOT."inc/class_parser.php";
$parser = new postParser;

global $theme, $templates;

// Fetch the current URL
$portal_url = get_current_location();

// Load global language phrases
$lang->load("portal");

add_breadcrumb($lang->nav_portal, "portal.php");

// This allows users to login if the portal is stored offsite or in a different directory
if($mybb->input['action'] == "do_login" && $mybb->request_method == "post")
{
	$plugins->run_hooks("portal_do_login_start");

	//Checks to make sure the user can login; they haven't had too many tries at logging in.
	//Is a fatal call if user has had too many tries
	$logins = login_attempt_check();
	$login_text = '';

	if(!username_exists($mybb->input['username']))
	{
		my_setcookie('loginattempts', $logins + 1);
		$db->query("UPDATE ".TABLE_PREFIX."sessions SET loginattempts=loginattempts+1 WHERE sid = '{$session->sid}'");
		if($mybb->settings['failedlogintext'] == "yes")
		{
			$login_text = sprintf($lang->failed_login_again, $mybb->settings['failedlogincount'] - $logins);
		}
		error($lang->error_invalidusername.$login_text);
	}
	$user = validate_password_from_username($mybb->input['username'], $mybb->input['password']);
	if(!$user['uid'])
	{
		my_setcookie('loginattempts', $logins + 1);
		$db->query("UPDATE ".TABLE_PREFIX."sessions SET loginattempts=loginattempts+1 WHERE sid = '{$session->sid}'");
		if($mybb->settings['failedlogintext'] == "yes")
		{
			$login_text = sprintf($lang->failed_login_again, $mybb->settings['failedlogincount'] - $logins);
		}
		error($lang->error_invalidpassword.$login_text);
	}

	my_setcookie('loginattempts', 1);
	$db->delete_query(TABLE_PREFIX."sessions", "ip='".$db->escape_string($session->ipaddress)."' AND sid != '".$session->sid."'");
	$newsession = array(
		"uid" => $user['uid'],
		"loginattempts" => 1,
		);
	$db->update_query(TABLE_PREFIX."sessions", $newsession, "sid='".$session->sid."'");

	// Temporarily set the cookie remember option for the login cookies
	$mybb->user['remember'] = $user['remember'];

	my_setcookie("mybbuser", $user['uid']."_".$user['loginkey'], null, true);
	my_setcookie("sid", $session->sid, -1, true);

	if(function_exists("loggedIn"))
	{
		loggedIn($user['uid']);
	}

	$plugins->run_hooks("portal_do_login_end");

	redirect("portal.php", $lang->redirect_loggedin);
}

$plugins->run_hooks("portal_start");

// First validate announcement fids:
$mybb->settings['portal_announcementsfid'] = explode(',', $mybb->settings['portal_announcementsfid']);
if(is_array($mybb->settings['portal_announcementsfid']))
{
	foreach($mybb->settings['portal_announcementsfid'] as $fid)
	{
		$fid_array[] = intval($fid);
	}
	$mybb->settings['portal_announcementsfid'] = implode(',', $fid_array);
}

// get forums user cannot view
$unviewable = get_unviewable_forums();
if($unviewable)
{
	$unviewwhere = " AND fid NOT IN ($unviewable)";
}
// If user is known, welcome them
if($mybb->settings['portal_showwelcome'] != "no")
{
	if($mybb->user['uid'] != 0)
	{
		if($mybb->user['receivepms'] != "no" && $mybb->usergroup['canusepms'] != "no" && $mybb->settings['portal_showpms'] != "no" && $mybb->settings['enablepms'] != "no")
		{
			$query = $db->simple_select(TABLE_PREFIX."privatemessages", "COUNT(*) AS pms_total, SUM(IF(dateline>'".$mybb->user['lastvisit']."' AND folder='1','1','0')) AS pms_new, SUM(IF(status='0' AND folder='1','1','0')) AS pms_unread", "uid='".$mybb->user['uid']."'");
			$messages = $db->fetch_array($query);
			if(!$messages['pms_new'])
			{
				$messages['pms_new'] = 0;
			}
			// the SUM() thing returns "" instead of 0
			if($messages['pms_unread'] == "")
			{
				$messages['pms_unread'] = 0;
			}
			$lang->pms_received_new = sprintf($lang->pms_received_new, $mybb->user['username'], $messages['pms_new']);
			eval("\$pms = \"".$templates->get("portal_pms")."\";");
		}
		// get number of new posts, threads, announcements
		$query = $db->simple_select(TABLE_PREFIX."posts", "COUNT(pid) AS newposts", "dateline>'".$mybb->user['lastvisit']."' $unviewwhere");
		$newposts = $db->fetch_field($query, "newposts");
		if($newposts)
		{ // if there aren't any new posts, there is no point in wasting two more queries
			$query = $db->simple_select(TABLE_PREFIX."threads", "COUNT(tid) AS newthreads", "dateline>'".$mybb->user['lastvisit']."' $unviewwhere");
			$newthreads = $db->fetch_field($query, "newthreads");
			$query = $db->simple_select(TABLE_PREFIX."threads", "COUNT(tid) AS newann", "dateline>'".$mybb->user['lastvisit']."' AND fid IN (".$mybb->settings['portal_announcementsfid'].") $unviewwhere");
			$newann = $db->fetch_field($query, "newann");
			if(!$newthreads)
			{
				$newthreads = 0;
			}
			if(!$newann)
			{
				$newann = 0;
			}
		}
		else
		{
			$newposts = 0;
			$newthreads = 0;
			$newann = 0;
		}

		// Make the text
		if($newann == 1)
		{
			$lang->new_announcements = $lang->new_announcement;
		}
		else
		{
			$lang->new_announcements = sprintf($lang->new_announcements, $newann);
		}
		if($newthreads == 1)
		{
			$lang->new_threads = $lang->new_thread;
		}
		else
		{
			$lang->new_threads = sprintf($lang->new_threads, $newthreads);
		}
		if($newposts == 1)
		{
			$lang->new_posts = $lang->new_post;
		}
		else
		{
			$lang->new_posts = sprintf($lang->new_posts, $newposts);
		}
		eval("\$welcometext = \"".$templates->get("portal_welcome_membertext")."\";");

	}
	else
	{
		$lang->guest_welcome_registration = sprintf($lang->guest_welcome_registration, $mybb->settings['bburl'] . '/member.php?action=register');
		$mybb->user['username'] = $lang->guest;
		eval("\$welcometext = \"".$templates->get("portal_welcome_guesttext")."\";");
	}
	$lang->welcome = sprintf($lang->welcome, $mybb->user['username']);
	eval("\$welcome = \"".$templates->get("portal_welcome")."\";");
	if($mybb->user['uid'] == 0)
	{
		$mybb->user['username'] = "";
	}
}
// Get Forum Statistics
if($mybb->settings['portal_showstats'] != "no")
{
	$stats = $cache->read("stats");
	$stats['numthreads'] = my_number_format($stats['numthreads']);
	$stats['numposts'] = my_number_format($stats['numposts']);
	$stats['numusers'] = my_number_format($stats['numusers']);
	if(!$stats['lastusername'])
	{
		$newestmember = "<b>" . $lang->no_one . "</b>";
	}
	else
	{
		$newestmember = build_profile_link($stats['lastusername'], $stats['lastuid']);
	}
	eval("\$stats = \"".$templates->get("portal_stats")."\";");
}
// Search box
if($mybb->settings['portal_showsearch'] != "no")
{
	eval("\$search = \"".$templates->get("portal_search")."\";");
}
// Get the online users
if($mybb->settings['portal_showwol'] != "no")
{
	$timesearch = time() - $mybb->settings['wolcutoff'];
	$comma = '';
	$guestcount = 0;
	$membercount = 0;
	$onlinemembers = '';
	$query = $db->query("
		SELECT s.sid, s.ip, s.uid, s.time, s.location, u.username, u.invisible, u.usergroup, u.displaygroup
		FROM ".TABLE_PREFIX."sessions s
		LEFT JOIN ".TABLE_PREFIX."users u ON (s.uid=u.uid)
		WHERE s.time>'$timesearch'
		ORDER BY u.username ASC, s.time DESC
	");
	while($user = $db->fetch_array($query))
	{
		// Create a key to test if this user is a search bot.
		$botkey = strtolower(str_replace("bot=", '', $user['sid']));
		
		if($user['uid'] == "0")
		{
			++$guestcount;
		}
		elseif(strpos($user['sid'], "bot=") !== false && $session->bots[$botkey])
		{
			// The user is a search bot.
			$onlinemembers .= $comma.format_name($session->bots[$botkey], $session->botgroup);
			$comma = ", ";
			++$botcount;
		}
		else
		{
			if($doneusers[$user['uid']] < $user['time'] || !$doneusers[$user['uid']])
			{				
				$doneusers[$user['uid']] = $user['time'];
				
				// If the user is logged in anonymously, update the count for that.
				if($user['invisible'] == "yes")
				{
					++$anoncount;
				}
				else
				{
					++$membercount;
				}
				
				if($user['invisible'] == "yes")
				{
					$invisiblemark = "*";
				}
				else
				{
					$invisiblemark = '';
				}
				
				if(($user['invisible'] == "yes" && ($mybb->usergroup['canviewwolinvis'] == "yes" || $user['uid'] == $mybb->user['uid'])) || $user['invisible'] != "yes")
				{
					$user['username'] = format_name($user['username'], $user['usergroup'], $user['displaygroup']);
					$user['profilelink'] = get_profile_link($user['uid']);
					eval("\$onlinemembers .= \"".$templates->get("portal_whosonline_memberbit", 1, 0)."\";");
					$comma = ", ";
				}
			}
		}
	}
	
	$onlinecount = $membercount + $guestcount + $botcount;
	
	// If we can see invisible users add them to the count
	if($mybb->usergroup['canviewwolinvis'] == "yes")
	{
		$onlinecount += $anoncount;
	}
	
	// If we can't see invisible users but the user is an invisible user incriment the count by one
	if($mybb->usergroup['canviewwolinvis'] != "yes" && $mybb->user['invisible'] == "yes")
	{
		++$onlinecount;
	}

	// Most users online
	$mostonline = $cache->read("mostonline");
	if($onlinecount > $mostonline['numusers'])
	{
		$time = time();
		$mostonline['numusers'] = $onlinecount;
		$mostonline['time'] = $time;
		$cache->update("mostonline", $mostonline);
	}
	$recordcount = $mostonline['numusers'];
	$recorddate = my_date($mybb->settings['dateformat'], $mostonline['time']);
	$recordtime = my_date($mybb->settings['timeformat'], $mostonline['time']);

	if($onlinecount == 1)
	{
		$lang->online_users = $lang->online_user;
	}
	else
	{
		$lang->online_users = sprintf($lang->online_users, $onlinecount);
	}
	$lang->online_counts = sprintf($lang->online_counts, $membercount, $guestcount);
	eval("\$whosonline = \"".$templates->get("portal_whosonline")."\";");
}

// Latest forum discussions
if($mybb->settings['portal_showdiscussions'] != "no" && $mybb->settings['portal_showdiscussionsnum'])
{
	$altbg = alt_trow();
	$threadlist = '';
	$query = $db->query("
		SELECT t.*, u.username
		FROM ".TABLE_PREFIX."threads t
		LEFT JOIN ".TABLE_PREFIX."users u ON (u.uid=t.uid)
		WHERE 1=1 $unviewwhere AND t.visible='1' AND t.closed NOT LIKE 'moved|%'
		ORDER BY t.lastpost DESC 
		LIMIT 0, ".$mybb->settings['portal_showdiscussionsnum']
	);
	while($thread = $db->fetch_array($query))
	{
		$lastpostdate = my_date($mybb->settings['dateformat'], $thread['lastpost']);
		$lastposttime = my_date($mybb->settings['timeformat'], $thread['lastpost']);
		// Don't link to guest's profiles (they have no profile).
		if($thread['lastposteruid'] == 0)
		{
			$lastposterlink = $thread['lastposter'];
		}
		else
		{
			$lastposterlink = build_profile_link($thread['lastposter'], $thread['lastposteruid']);
		}
		if(my_strlen($thread['subject']) > 25)
		{
			$thread['subject'] = my_substr($thread['subject'], 0, 25) . "...";
		}
		$thread['subject'] = htmlspecialchars_uni($thread['subject']);
		eval("\$threadlist .= \"".$templates->get("portal_latestthreads_thread")."\";");
		$altbg = alt_trow();
	}
	if($threadlist)
	{ // show the table only if there are threads
		eval("\$latestthreads = \"".$templates->get("portal_latestthreads")."\";");
	}
}

// Get latest news announcements
$query = $db->simple_select(TABLE_PREFIX."forums", "*", "fid IN (".$mybb->settings['portal_announcementsfid'].")");
while($forumrow = $db->fetch_array($query))
{
    $forum[$forumrow['fid']] = $forumrow;
}

$pids = '';
$comma="";
$query = $db->query("
	SELECT p.pid, p.message, p.tid
	FROM ".TABLE_PREFIX."posts p
	LEFT JOIN ".TABLE_PREFIX."threads t ON (t.tid=p.tid)
	WHERE t.fid IN (".$mybb->settings['portal_announcementsfid'].") AND t.visible='1' AND t.closed NOT LIKE 'moved|%' AND t.firstpost=p.pid
	ORDER BY t.dateline DESC 
	LIMIT 0, ".$mybb->settings['portal_numannouncements']
);
while($getid = $db->fetch_array($query))
{
	$pids .= ",'$getid[pid]'";
	$posts[$getid['tid']] = $getid;
}
$pids = "pid IN(0$pids)";
// Now lets fetch all of the attachments for these posts
$query = $db->query("SELECT * FROM ".TABLE_PREFIX."attachments WHERE $pids");
while($attachment = $db->fetch_array($query))
{
	$attachcache[$attachment['pid']][$attachment['aid']] = $attachment;
}

if(is_array($forum))
{
	foreach($forum as $fid => $forumrow)
	{
		$forumpermissions[$fid] = forum_permissions($fid);
	}
}

$icon_cache = $cache->read("posticons");

$announcements = '';
$query = $db->query("
	SELECT t.*, t.username AS threadusername, u.username, u.avatar
	FROM ".TABLE_PREFIX."threads t
	LEFT JOIN ".TABLE_PREFIX."users u ON (u.uid = t.uid)
	WHERE fid IN (".$mybb->settings['portal_announcementsfid'].") AND t.visible='1' AND t.closed NOT LIKE 'moved|%'
	ORDER BY t.dateline DESC
	LIMIT 0, ".$mybb->settings['portal_numannouncements']
);
while($announcement = $db->fetch_array($query))
{
	$announcement['message'] = $posts[$announcement['tid']]['message'];
	$announcement['pid'] = $posts[$announcement['tid']]['pid'];
	$announcement['author'] = $announcement['uid'];
	if(!$announcement['username'])
	{
		$announcement['username'] = $announcement['threadusername'];
	}
	$announcement['subject'] = htmlspecialchars_uni($announcement['subject']);
	if($announcement['icon'] > 0 && $icon_cache[$announcement['icon']])
	{
		$icon = $icon_cache[$announcement['icon']];
		$icon = "<img src=\"{$icon['path']}\" alt=\"{$icon['name']}\" />";
	}
	else
	{
		$icon = "&nbsp;";
	}
	if($announcement['avatar'] != '')
	{
		$avatar_dimensions = explode("|", $announcement['avatardimensions']);
		if($avatar_dimensions[0] && $avatar_dimensions[1])
		{
			$avatar_width_height = "width=\"{$avatar_dimensions[0]}\" height=\"{$avatar_dimensions[1]}\"";
		}
		if (!stristr($announcement['avatar'], 'http://'))
		{
			$announcement['avatar'] = $mybb->settings['bburl'] . '/' . $announcement['avatar'];
		} 		
		$avatar = "<td class=\"trow1\" width=\"1\" align=\"center\" valign=\"top\"><img src=\"$announcement[avatar]\" alt=\"0\" {$avatar_width_height} /></td>";
	}
	else
	{
		$avatar = '';
	}
	$anndate = my_date($mybb->settings['dateformat'], $announcement['dateline']);
	$anntime = my_date($mybb->settings['timeformat'], $announcement['dateline']);

	if($announcement['replies'])
	{
		eval("\$numcomments = \"".$templates->get("portal_announcement_numcomments")."\";");
	}
	else
	{
		eval("\$numcomments = \"".$templates->get("portal_announcement_numcomments_no")."\";");
		$lastcomment = '';
	}
	
	$plugins->run_hooks("portal_announcement");

	$parser_options = array(
		"allow_html" => $forum[$announcement['fid']]['allowhtml'],
		"allow_mycode" => $forum[$announcement['fid']]['allowmycode'],
		"allow_smilies" => $forum[$announcement['fid']]['allowsmilies'],
		"allow_imgcode" => $forum[$announcement['fid']]['allowimgcode']
	);
	if($announcement['smilieoff'] == "yes")
	{
		$parser_options['allow_smilies'] = "no";
	}

	$message = $parser->parse_message($announcement['message'], $parser_options);
	
	if(is_array($attachcache[$announcement['pid']]))
	{ // This post has 1 or more attachments
		$validationcount = 0;
		$id = $announcement['pid'];
		foreach($attachcache[$id] as $aid => $attachment)
		{
			if($attachment['visible'])
			{ // There is an attachment thats visible!
				$attachment['filename'] = htmlspecialchars_uni($attachment['filename']);
				$attachment['filesize'] = get_friendly_size($attachment['filesize']);
				$ext = get_extension($attachment['filename']);
				if($ext == "jpeg" || $ext == "gif" || $ext == "bmp" || $ext == "png" || $ext == "jpg")
				{
					$isimage = true;
				}
				else
				{
					$isimage = false;
				}
				$attachment['icon'] = get_attachment_icon($ext);
				// Support for [attachment=id] code
				if(stripos($message, "[attachment=".$attachment['aid']."]") !== false)
				{
					if($attachment['thumbnail'] != "SMALL" && $attachment['thumbnail'] != '')
					{ // We have a thumbnail to show (and its not the "SMALL" enough image
						eval("\$attbit = \"".$templates->get("postbit_attachments_thumbnails_thumbnail")."\";");
					}
					elseif($attachment['thumbnail'] == "SMALL" && $forumpermissions[$announcement['fid']]['candlattachments'] == "yes")
					{
						// Image is small enough to show - no thumbnail
						eval("\$attbit = \"".$templates->get("postbit_attachments_images_image")."\";");
					}
					else
					{
						// Show standard link to attachment
						eval("\$attbit = \"".$templates->get("postbit_attachments_attachment")."\";");
					}
					$message = preg_replace("#\[attachment=".$attachment['aid']."]#si", $attbit, $message);
				}
				else
				{
					if($attachment['thumbnail'] != "SMALL" && $attachment['thumbnail'] != '')
					{ // We have a thumbnail to show
						eval("\$post['thumblist'] .= \"".$templates->get("postbit_attachments_thumbnails_thumbnail")."\";");
						if($tcount == 5)
						{
							$thumblist .= "<br />";
							$tcount = 0;
						}
						$tcount++;
					}
					elseif($attachment['thumbnail'] == "SMALL" && $forumpermissions[$announcement['fid']]['candlattachments'] == "yes")
					{
						// Image is small enough to show - no thumbnail
						eval("\$post['imagelist'] .= \"".$templates->get("postbit_attachments_images_image")."\";");
					}
					else
					{
						eval("\$post['attachmentlist'] .= \"".$templates->get("postbit_attachments_attachment")."\";");
					}
				}
			}
			else
			{
				$validationcount++;
			}
		}
		if($post['thumblist'])
		{
			eval("\$post['attachedthumbs'] = \"".$templates->get("postbit_attachments_thumbnails")."\";");
		}
		if($post['imagelist'])
		{
			eval("\$post['attachedimages'] = \"".$templates->get("postbit_attachments_images")."\";");
		}
		if($post['attachmentlist'] || $post['thumblist'] || $post['imagelist'])
		{
			eval("\$post['attachments'] = \"".$templates->get("postbit_attachments")."\";");
		}
	}

	eval("\$announcements .= \"".$templates->get("portal_announcement")."\";");
	unset($post);
}
eval("\$portal = \"".$templates->get("portal")."\";");

$plugins->run_hooks("portal_end");

output_page($portal);

?>
