<?php

//opovaz sa niekde z tejto classy vyhodit von Exception. Je to sice osetrene keby sa podarilo a zavola sa vtedy rollback, ale ubyjem ta palicou!

/*

Prihlasenie:
pred prihlasenim zavolam prepare
potom zavolam login
ak sa podari prihlasit, zavolam commit
ak sa nepodari prihlasit, zavolam rollback

Odhlasenie:
len zavolam logout

*/


// nazov classy je Session_$(nazov tvojho adresara kde je podstranka)
require_once 'lib/messages.php';

class Session_forum{
	private $db;

	public function __construct(){
		// bud v konstruktore alebo v prepare si vytvor spojenie na DB ak potrebujes. Odporucam prepare, kedze vies hned povedat false
	require 'inc/config.php';
		
		$DB_DSN='mysql:host='.$config['hostname'].';dbname='.$config['database'];
		$this->db = new PDO($DB_DSN, $config['username'], $config['password']);
		$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$this->db->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);

		$this->db->prepare("set names 'utf8'")->execute();
	}

	public function prepare(){
		try{
			$this->db->beginTransaction();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function rollback(){
		//navratova hodnota ma nezaujima, tu si mas len upratat, lebo sa nieco pokazilo
		try{
			$this->db->rollBack();
			$this->destroySession();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function commit(){
		try{
			$this->db->commit();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function keepSession($name, $properties){
		if (isset($_COOKIE['sid']))
			setcookie('sid',$_COOKIE['sid'],time()+SESSION_LIFE_TIME,'/');
		if (isset($_COOKIE['mybbuser']))
			setcookie('mybbuser',$_COOKIE['mybbuser'],time()+SESSION_LIFE_TIME,'/');
		if (isset($_COOKIE['loginattempts']))
			setcookie('loginattempts',$_COOKIE['loginattempts'],time()+SESSION_LIFE_TIME,'/');
		if (isset($_COOKIE['mybb']['lastactive']))
			setcookie('mybb[lastactive]',$_COOKIE['mybb']['lastactive'],time()+SESSION_LIFE_TIME,'/');
		if (isset($_COOKIE['mybb']['lastvisit']))
			setcookie('mybb[lastvisit]',$_COOKIE['mybb']['lastvisit'],time()+SESSION_LIFE_TIME,'/');
		
		$st = $this->db->prepare('UPDATE mybb_adminsessions SET dateline=:dateline, lastactive=:lastactive WHERE sid=:sid');
		$st->bindValue(':sid',session_id(),PDO::PARAM_STR);
		$st->bindValue(':dateline',time(),PDO::PARAM_INT);
		$st->bindValue(':lastactive',time(),PDO::PARAM_INT);
		$st->execute();

		return true;
	}	

	public function createSession($name, $properties){
		try{
			$st = $this->db->prepare('DELETE FROM mybb_sessions WHERE sid=:sid');
			$st->bindValue(':sid',session_id(),PDO::PARAM_STR);
			$st->execute();
		
			$st = $this->db->prepare('DELETE FROM mybb_adminsessions WHERE sid=:sid');
			$st->bindValue(':sid',session_id(),PDO::PARAM_STR);
			$st->execute();

			$uid = $this->updateProperties($name, $properties);

			$st = $this->db->prepare('INSERT INTO mybb_sessions SET `sid`=:sid, `uid`=:uid, `ip`=:ip, `time`=:time, `location`=:location, `useragent`=:ua');
			$st->bindValue(':sid',session_id(),PDO::PARAM_STR);
			$st->bindValue(':uid',$uid,PDO::PARAM_INT);
			$st->bindValue(':ip',$_SERVER['REMOTE_ADDR'],PDO::PARAM_STR);
			$st->bindValue(':time', time(),PDO::PARAM_INT);
			$st->bindValue(':location','/ksp/forum/index.php',PDO::PARAM_STR);
			$st->bindValue(':ua',$_SERVER['HTTP_USER_AGENT'],PDO::PARAM_STR);
			$st->execute();

			require_once 'settings.php';
			$_COOKIE['sid']=session_id(); setcookie('sid',session_id(),time()+SESSION_LIFE_TIME,'/'); 
			$_COOKIE['mybbuser']=$uid.'_'.$this->getLoginKeyByUID($uid); setcookie('mybbuser',$_COOKIE['mybbuser'],time()+SESSION_LIFE_TIME,'/');
			$_COOKIE['loginattempts']=1; setcookie('loginattempts',1,time()+SESSION_LIFE_TIME,'/');
			$_COOKIE['mybb']['lastactive']=time(); setcookie('mybb[lastactive]',time(),time()+SESSION_LIFE_TIME,'/');
			$_COOKIE['mybb']['lastvisit']=time(); setcookie('mybb[lastvisit]',time(),time()+SESSION_LIFE_TIME,'/');

			$st = $this->db->prepare('SELECT usergroup, loginkey FROM mybb_users WHERE uid=:uid');
			$st->bindValue(':uid',$uid,PDO::PARAM_INT);
			$st->execute();
			$data=$st->fetch();
			if ($data && ($data['usergroup']==3 || $data['usergroup']==4)){
				$st = $this->db->prepare('INSERT INTO mybb_adminsessions SET sid=:sid, uid=:uid, loginkey=:loginkey, ip=:ip, dateline=:dateline, lastactive=:lastactive');
				$st->bindValue(':sid',session_id(),PDO::PARAM_STR);
				$st->bindValue(':uid',$uid,PDO::PARAM_INT);
				$st->bindValue(':loginkey',$data['loginkey'],PDO::PARAM_STR);
				$st->bindValue(':ip',$_SERVER['REMOTE_ADDR'],PDO::PARAM_STR);
				$st->bindValue(':dateline',time(),PDO::PARAM_INT);
				$st->bindValue(':lastactive',time(),PDO::PARAM_INT);
				$st->execute();
			}

			return true;
		} catch (Exception $e) {
			$msg=new Messages();
			$msg->addErr('Forum login exception: ' . $e->getMessage() . ' '. $e->getTraceAsString() . ' ' .  $e->getLine());
			return false;
		}
	}

	public function destroySession(){
		//v podstate logout z podstranky
		try{
			$st=$this->db->prepare('delete from mybb_sessions where sid=:sid');
			$st->bindValue('sid',session_id(),PDO::PARAM_STR);
			$st->execute();

			$st=$this->db->prepare('delete from mybb_adminsessions where sid=:sid');
			$st->bindValue('sid',session_id(),PDO::PARAM_STR);
			$st->execute();
			
			setcookie('sid','',time()-3600,'/');
			setcookie('mybbuser','',time()-3600,'/');
			setcookie('loginattempts','',time()-3600,'/');
			setcookie('mybb[lastactive]','',time()-3600,'/');
			setcookie('mybb[lastvisit]','',time()-3600,'/');

			unset($_COOKIE['sid']);
			unset($_COOKIE['mybbuser']);
			unset($_COOKIE['loginattempts']);
			unset($_COOKIE['mybb']);
			return true;
		} catch (Exception $e) {
			//return false;	//na navratovu hodnotu tejto funkcie nie som zvedavy, iked mozno sa to casom zmeni. Zatial neviem co robit v pripade false
		}
	}

	//vrat pole s hodnotami, ktore potrebujes
	//zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
	public function getRequired(){
		return array();
	}

	//vrat pole s hodnotami, ktore chces ale prezijes ked nebudu
	//zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
	public function getOptional(){
		return array('nickname', 'dob', 'email', 'gender', 'timezone');
	}

	private function getUIDByName($name){
		//vrati uid uzivatela z DB, ked tam nie je, updateProperties vytvoria nove konto, inak len updatnu hodnoty
		$st=$this->db->prepare('SELECT uid FROM mybb_users WHERE password=:name');	//patrilo by sa spravit tabulku s mapovanim login->uid ale ked je to taky "zbytocny" field :)
		$st->bindValue(':name',$name,PDO::PARAM_STR);
		$st->execute();
		$data = $st->fetch();
		if ($data) return $data['uid'];
		else return false;
	}

	private function getLoginKeyByUID($uid){
		$st=$this->db->prepare('SELECT loginkey FROM mybb_users WHERE uid=:uid');
		$st->bindValue(':uid',$uid,PDO::PARAM_INT);
		$st->execute();
		$data = $st->fetch();
		if ($data) return $data['loginkey'];
		else return false;
	}

	private function random_str($length="8") {
		$set = array("a","A","b","B","c","C","d","D","e","E","f","F","g","G","h","H","i","I","j","J","k","K","l","L","m","M","n","N","o","O","p","P","q","Q","r","R","s","S","t","T","u","U","v","V","w","W","x","X","y","Y","z","Z","1","2","3","4","5","6","7","8","9");
		$str;
		for($i = 1; $i <= $length; $i++)
		{
			$ch = rand(0, count($set)-1);
			$str .= $set[$ch];
		}
		return $str;
	}

	private function unicode_chr($c)	{
		if($c <= 0x7F)
		{
			return chr($c);
		}
		elseif($c <= 0x7FF)
		{
			return chr(0xC0 | $c >> 6) . chr(0x80 | $c & 0x3F);
		}
		elseif($c <= 0xFFFF)
		{
			return chr(0xE0 | $c >> 12) . chr(0x80 | $c >> 6 & 0x3F)
				. chr(0x80 | $c & 0x3F);
		}
		elseif($c <= 0x10FFFF) 
		{
			return chr(0xF0 | $c >> 18) . chr(0x80 | $c >> 12 & 0x3F)
				. chr(0x80 | $c >> 6 & 0x3F)
				. chr(0x80 | $c & 0x3F);
		}
		else
		{
			return false;
		}
	}

	private function dec_to_utf8($src){
		$dest = '';
		if($src < 0)
		{
			return false;
		}
		elseif($src <= 0x007f)
		{
			$dest .= chr($src);
		}
		elseif($src <= 0x07ff)
		{
			$dest .= chr(0xc0 | ($src >> 6));
			$dest .= chr(0x80 | ($src & 0x003f));
		}
		elseif($src <= 0xffff)
		{
			$dest .= chr(0xe0 | ($src >> 12));
			$dest .= chr(0x80 | (($src >> 6) & 0x003f));
			$dest .= chr(0x80 | ($src & 0x003f));
		}
		elseif($src <= 0x10ffff)
		{
			$dest .= chr(0xf0 | ($src >> 18));
			$dest .= chr(0x80 | (($src >> 12) & 0x3f));
			$dest .= chr(0x80 | (($src >> 6) & 0x3f));
			$dest .= chr(0x80 | ($src & 0x3f));
		}
		else
		{
			// out of range
			return false;
		}
		return $dest;
	}

	private function updateProperties($name, $properties){
		//nastavime vlastnosti ktore sme dostali z prihlasenia
		$uid = $this->getUIDByName($name);

		$substitute=array();
		if ($uid){
			$sql="UPDATE mybb_users SET salt=''";
		} else {
			$sql="INSERT INTO mybb_users SET
				loginkey=:loginkey,
				postnum=0,
				avatar='',
				avatardimensions='',
				avatartype='',
				usergroup=2,
				additionalgroups='',
				displaygroup=0,
				usertitle='',
				regdate=:regdate,
				lastactive=:lastactive,
				lastvisit=:lastvisit,
				lastpost=0, website='',
				icq=0, aim='', yahoo='', msn='',
				signature='',
				allownotices='yes',
				hideemail='no',
				emailnotify='no',
				invisible='no',
				receivepms='yes',
				pmpopup='yes',
				pmnotify='yes',
				remember='no',
				threadmode='linear',
				showsigs='yes',
				showavatars='yes',
				showquickreply='yes',
				showredirect='yes',
				ppp=0,
				tpp=0,
				daysprune=0,
				dateformat='0',
				timeformat='0',
				dst='yes',
				buddylist='',
				ignorelist='',
				style=0,
				away='no',
				awaydate=0,
				returndate='0',
				awayreason='',
				pmfolders=:pmfolders,
				notepad='',
				referrer=0,
				reputation=0,
				regip=:regip,
				language='slovak',
				timeonline=0,
				showcodebuttons=1,
				totalpms=0,
				newpms=0,
				unreadpms=0,
				password=:password";
			$substitute[] = array('k'=>':loginkey', 'v'=>$this->random_str(50), PDO::PARAM_STR);
			$substitute[] = array('k'=>':regdate', 'v'=>time(), PDO::PARAM_INT);
			$substitute[] = array('k'=>':lastactive', 'v'=>time(), PDO::PARAM_INT);
			$substitute[] = array('k'=>':lastvisit', 'v'=>time(), PDO::PARAM_INT);
			$substitute[] = array('k'=>':pmfolders', 'v'=>'1**Inbox$%%$2**Sent Items$%%$3**Drafts$%%$4**Trash Can', PDO::PARAM_STR);
			$substitute[] = array('k'=>':regip', 'v'=>$_SERVER['REMOTE_ADDR'], PDO::PARAM_STR);
			$substitute[] = array('k'=>':password', 'v'=>$name, PDO::PARAM_STR);
		}


		if (isset($properties['nickname']))
			$nick = trim($properties['nickname']);
		else
			$nick = trim($name);

		$nick = str_replace(array($this->unicode_chr(160), $this->unicode_chr(173), $this->unicode_chr(0xCA), $this->dec_to_utf8(8238), $this->dec_to_utf8(8237)), array(" ", "-", "", "", ""), $nick);
		$nick = preg_replace("#\s{2,}#", " ", $nick);
		if (eregi("<", $nick) || eregi(">", $nick) || eregi("&", $nick) || strpos($nick, "\\") !== false || eregi(";", $nick)) throw new Exception('illegal characters in nickname');
		if ($nick){
			$sql.=', username=:username';
			$substitute[] = array('k'=>':username', 'v'=>$nick, PDO::PARAM_STR);
		}

		if (isset($properties['dob'])){
			//birthday: YYYY-MM-DD -> den-mesiac-rok
			$sql.=', birthday=:birthday';
			$substitute[] = array('k'=>':birthday', 'v'=>date('j-n-Y',strtotime($properties['dob'])), PDO::PARAM_STR);
		}

		if (isset($properties['email'])){
			$sql.=', email=:email';
			$substitute[] = array('k'=>':email', 'v'=>$properties['email'], PDO::PARAM_STR);
		}

		if (isset($properties['timezone'])){
			$tz=0;
			foreach (timezone_abbreviations_list() as $key=>$item)
				foreach ($item as $key2=>$item2)
					if ($item2['timezone_id']==$properties['timezone']) $tz=$item2['offset'];
			if ($tz>0) $tz='+'.$tz/3600;
			else $tz=$tz/3600;
			$sql.=', timezone=:timezone';
			$substitute[] = array('k'=>':timezone', 'v'=>$tz, PDO::PARAM_STR);
		}

		if ($uid){
			$sql.=' WHERE uid=:uid';
			$substitute[] = array('k'=>':uid', 'v'=>$uid, PDO::PARAM_STR);
		}

		$st=$this->db->prepare($sql);
		foreach ($substitute as $key=>$item){
			$st->bindValue($item['k'], $item['v'], $item['t']);
		}
		$st->execute();

		if (!$uid) $uid=$this->db->lastInsertId();

		if (isset($properties['gender'])){
			//sex v mybb_userfields fid3 F -> Female, M -> Male
			$st=$this->db->prepare('SELECT * FROM mybb_userfields WHERE ufid=:ufid');
			$st->bindValue(':ufid', $uid, PDO::PARAM_INT);
			$st->execute();
			if ($st->fetch()){
				$st=$this->db->prepare('UPDATE mybb_userfields SET fid3=:fid3 WHERE ufid=:ufid');
			} else {
				$st=$this->db->prepare("INSERT INTO mybb_userfields SET ufid=:ufid, fid1='', fid2='', fid3=:fid3");
			}

			$st->bindValue(':ufid',$uid,PDO::PARAM_INT);
			if ($properties['gender']=='M') $st->bindValue(':fid3','Male', PDO::PARAM_STR);
			else $st->bindValue(':fid3', 'Female', PDO::PARAM_STR);
			$st->execute();
		}

		return $uid;
	}
}

?>
