--
-- PostgreSQL database dump
--

SET client_encoding = 'LATIN2';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

ALTER TABLE ONLY public.vzorake DROP CONSTRAINT vzorake_round_id_fkey;
ALTER TABLE ONLY public.vyplnene_hodnoty DROP CONSTRAINT vyplnene_hodnoty_id_prihlasky_fkey;
ALTER TABLE ONLY public.vyplnene_hodnoty DROP CONSTRAINT vyplnene_hodnoty_id_atributu_fkey;
ALTER TABLE ONLY public.registred DROP CONSTRAINT registred_man_id_fkey;
ALTER TABLE ONLY public.prihlasky DROP CONSTRAINT prihlasky_id_typu_prihlasky_fkey;
ALTER TABLE ONLY public.eround DROP CONSTRAINT eround_round_id_fkey;
ALTER TABLE ONLY public.eround_document DROP CONSTRAINT eround_document_round_id_fkey;
ALTER TABLE ONLY public.electronic_solutions DROP CONSTRAINT electronic_solutions_task_id_fkey;
ALTER TABLE ONLY public.electronic_solutions DROP CONSTRAINT electronic_solutions_man_id_fkey;
ALTER TABLE ONLY public.atributy_prihlasok DROP CONSTRAINT atributy_prihlasok_id_tipu_prihlasky_fkey;
ALTER TABLE ONLY public.aktualne_prihlasky DROP CONSTRAINT aktualne_prihlasky_typ_prihlasky_fkey;
DROP TRIGGER "RI_ConstraintTrigger_17172" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17171" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17170" ON public.registration;
DROP TRIGGER "RI_ConstraintTrigger_17169" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17168" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17167" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17166" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17165" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17164" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17163" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17162" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17161" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_17160" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17159" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17158" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17157" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17156" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17155" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17154" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17153" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17152" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17151" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17150" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17149" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17148" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17147" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17146" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17145" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17144" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17143" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17142" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17141" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17140" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17139" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17138" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17137" ON public.registration;
DROP TRIGGER "RI_ConstraintTrigger_17136" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17135" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17134" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17133" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17132" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17131" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17130" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17129" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17128" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_17127" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17126" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17125" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17124" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17123" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17122" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17121" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17120" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17119" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17118" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17117" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17116" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17115" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17114" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17113" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17112" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17111" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17110" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17109" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17108" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17107" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17106" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17105" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17104" ON public.registration;
DROP TRIGGER "RI_ConstraintTrigger_17103" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17102" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17101" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17100" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17099" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17098" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17097" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17096" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17095" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_17094" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17093" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17092" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17091" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17090" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17089" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17088" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17087" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17086" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17085" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17084" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17083" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17082" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17081" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17080" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17079" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17078" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17077" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17076" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17075" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17074" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17073" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17072" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17071" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17070" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17069" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17068" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17067" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17066" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17065" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_17064" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17063" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17062" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17061" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17060" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17059" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17058" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17057" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17056" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17055" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17054" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17053" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17052" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17051" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17050" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17049" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17048" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17047" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17046" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17045" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17044" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17043" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17042" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17041" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17040" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17039" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17038" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17037" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17036" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17035" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_17034" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17033" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17032" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17031" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17030" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17029" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17028" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17027" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17026" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17025" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17024" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17023" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_17022" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17021" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17020" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_17019" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17018" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_17017" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17016" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17015" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_17014" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_17013" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17012" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_17011" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17010" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17009" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17008" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_17007" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17006" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_17005" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_17004" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17003" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_17002" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_17001" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_17000" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16999" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16998" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16997" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16996" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16995" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16994" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16993" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16992" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16991" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16990" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16989" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16988" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16987" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16986" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16985" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16984" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16983" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16982" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16981" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16980" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16979" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16978" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16977" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16976" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16975" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_16974" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16973" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16972" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16971" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16970" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16969" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16968" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16967" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16966" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16965" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16964" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16963" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16962" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16961" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16960" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16959" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16958" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16957" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16956" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16955" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16954" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16953" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16952" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16951" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16950" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16949" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16948" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16947" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16946" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16945" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_16944" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16943" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16942" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16941" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16940" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16939" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16938" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16937" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16936" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16935" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16934" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16933" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16932" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16931" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16930" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16929" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16928" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16927" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16926" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16925" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16924" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16923" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16922" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16921" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16920" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16919" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16918" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16917" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16916" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16915" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_16914" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16913" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16912" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16911" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16910" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16909" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16908" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16907" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16906" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16905" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16904" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16903" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16902" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16901" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16900" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16899" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16898" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16897" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16896" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16895" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16894" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16893" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16892" ON public.people_prop_types;
DROP TRIGGER "RI_ConstraintTrigger_16891" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16890" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16889" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16888" ON public.people_prop;
DROP TRIGGER "RI_ConstraintTrigger_16887" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16886" ON public.exports;
DROP TRIGGER "RI_ConstraintTrigger_16885" ON public.formats;
DROP TRIGGER "RI_ConstraintTrigger_16884" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16883" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16882" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16881" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16880" ON public.actions;
DROP TRIGGER "RI_ConstraintTrigger_16879" ON public.participants;
DROP TRIGGER "RI_ConstraintTrigger_16878" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16877" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16876" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16875" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16874" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16873" ON public.solutions;
DROP TRIGGER "RI_ConstraintTrigger_16872" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16871" ON public.rounds;
DROP TRIGGER "RI_ConstraintTrigger_16870" ON public.tasks;
DROP TRIGGER "RI_ConstraintTrigger_16869" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16868" ON public.schools;
DROP TRIGGER "RI_ConstraintTrigger_16867" ON public.people;
DROP TRIGGER "RI_ConstraintTrigger_16866" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16865" ON public.contests;
DROP TRIGGER "RI_ConstraintTrigger_16864" ON public.rounds;
DROP INDEX public.tasks_round_id_key;
DROP INDEX public.schools_name_key;
DROP INDEX public.rounds_contest_id_key;
DROP INDEX public.people_prop_types_name_key;
DROP INDEX public.formats_export_id_key;
DROP INDEX public.exports_name_key;
DROP INDEX public.contests_name_key;
ALTER TABLE ONLY public.typy_prihlasok DROP CONSTRAINT typy_prihlasok_pkey;
ALTER TABLE ONLY public.tasks DROP CONSTRAINT tasks_pkey;
ALTER TABLE ONLY public.solutions DROP CONSTRAINT solutions_pkey;
ALTER TABLE ONLY public.schools DROP CONSTRAINT schools_pkey;
ALTER TABLE ONLY public.rounds DROP CONSTRAINT rounds_pkey;
ALTER TABLE ONLY public.registration DROP CONSTRAINT registration_pkey;
ALTER TABLE ONLY public.prihlasky DROP CONSTRAINT prihlasky_pkey;
ALTER TABLE ONLY public.people_prop_types DROP CONSTRAINT people_prop_types_pkey;
ALTER TABLE ONLY public.people_prop DROP CONSTRAINT people_prop_pkey;
ALTER TABLE ONLY public.people DROP CONSTRAINT people_pkey;
ALTER TABLE ONLY public.participants DROP CONSTRAINT participants_pkey;
ALTER TABLE ONLY public.login_map DROP CONSTRAINT login_map_pkey;
ALTER TABLE ONLY public.login_map DROP CONSTRAINT login_map_nick_key;
ALTER TABLE ONLY public.formats DROP CONSTRAINT formats_pkey;
ALTER TABLE ONLY public.exports DROP CONSTRAINT exports_pkey;
ALTER TABLE ONLY public.electronic_solutions DROP CONSTRAINT esc;
ALTER TABLE ONLY public.contests DROP CONSTRAINT contests_pkey;
ALTER TABLE ONLY public.atributy_prihlasok DROP CONSTRAINT atributy_prihlasok_pkey;
ALTER TABLE ONLY public.aktualne_prihlasky DROP CONSTRAINT aktualne_prihlasky_pkey;
ALTER TABLE ONLY public.actions DROP CONSTRAINT actions_pkey;
ALTER TABLE public.typy_prihlasok ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.prihlasky ALTER COLUMN id_prihlasky DROP DEFAULT;
ALTER TABLE public.atributy_prihlasok ALTER COLUMN id_atributu DROP DEFAULT;
ALTER TABLE public.aktualne_prihlasky ALTER COLUMN id DROP DEFAULT;
DROP TABLE public.vzorake;
DROP TABLE public.vyplnene_hodnoty;
DROP SEQUENCE public.typy_prihlasok_id_seq;
DROP TABLE public.typy_prihlasok;
DROP SEQUENCE public.tasks_task_id_seq;
DROP VIEW public.solutions_view;
DROP SEQUENCE public.schools_school_id_seq;
DROP SEQUENCE public.rounds_round_id_seq;
DROP TABLE public.rounds;
DROP TABLE public.registred;
DROP TABLE public.registration;
DROP SEQUENCE public.prihlasky_id_prihlasky_seq;
DROP TABLE public.prihlasky;
DROP VIEW public.people_prop_view;
DROP SEQUENCE public.people_prop_types_ppt_id_seq;
DROP TABLE public.people_prop_types;
DROP TABLE public.people_prop;
DROP SEQUENCE public.people_man_id_seq;
DROP VIEW public.participants_view;
DROP TABLE public.participants;
DROP VIEW public.paper_solutions_view;
DROP VIEW public.oldsolutions;
DROP TABLE public.merged;
DROP TABLE public.login_map;
DROP SEQUENCE public.formats_format_id_seq;
DROP TABLE public.formats;
DROP SEQUENCE public.exports_export_id_seq;
DROP TABLE public.exports;
DROP TABLE public.eround_document;
DROP TABLE public.eround;
DROP TABLE public.electronic_solutions;
DROP SEQUENCE public.contests_contest_id_seq;
DROP TABLE public.contests;
DROP SEQUENCE public.atributy_prihlasok_id_atributu_seq;
DROP TABLE public.atributy_prihlasok;
DROP VIEW public.all_solutions_view;
DROP VIEW public.tasks_view;
DROP TABLE public.tasks;
DROP TABLE public.solutions;
DROP VIEW public.people_view;
DROP TABLE public.schools;
DROP TABLE public.people;
DROP SEQUENCE public.aktualne_prihlasky_id_seq;
DROP TABLE public.aktualne_prihlasky;
DROP SEQUENCE public.actions_action_id_seq;
DROP TABLE public.actions;
DROP AGGREGATE public.array_accum(anyelement);
DROP AGGREGATE public.aggregated_concat(text);
DROP FUNCTION public.updatemanfromregistration(timestamp with time zone, integer);
DROP FUNCTION public.text2float(text);
DROP FUNCTION public.pointsofmanroundtask(integer, integer, integer);
DROP FUNCTION public.plpgsql_call_handler();
DROP FUNCTION public.peoplesendtext(integer);
DROP FUNCTION public.peoplenamebyid(integer);
DROP FUNCTION public.peoplenamebyfirstnamelastname(text, text);
DROP FUNCTION public.participantstasktext(integer);
DROP FUNCTION public.insertmanfromregistration(timestamp with time zone);
DROP FUNCTION public.finish(integer, integer);
DROP FUNCTION public.concat(text, text, text);
DROP FUNCTION public.concat(text, text);
DROP FUNCTION public.addressofman2(integer);
DROP FUNCTION public.addressofman(integer);
DROP FUNCTION public."add"(integer, integer);
DROP PROCEDURAL LANGUAGE plpgsql;
DROP SCHEMA public;
--
-- Name: public; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA public;


--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA public IS 'Standard public namespace';


--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: -
--

CREATE PROCEDURAL LANGUAGE plpgsql;


--
-- Name: add(integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION "add"(integer, integer) RETURNS integer
    AS $_$select $1 + $2;$_$
    LANGUAGE sql;


--
-- Name: addressofman(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION addressofman(integer) RETURNS text
    AS $_$SELECT CASE p.send
        WHEN 0 THEN p.home_street || '
' || home_city || '
' || home_zip
        WHEN 1 THEN s.addr_name ||'
'|| s.addr_street ||'
'|| s.addr_city
                ||'
'|| s.addr_zip
        WHEN 0 THEN coresp_street || '
' || coresp_city || '
' || coresp_zip
        END
        FROM people p JOIN schools s USING (school_id)
        WHERE
        p.man_id = $1;$_$
    LANGUAGE sql;


--
-- Name: addressofman2(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION addressofman2(integer) RETURNS text
    AS $_$SELECT CASE p.send
	WHEN 0 THEN p.home_street || '
' || home_zip || ' ' || home_city
	WHEN 1 THEN s.addr_name ||'
'|| s.addr_street ||'
'||
        s.addr_zip ||' '|| s.addr_city
	WHEN 2 THEN coresp_street || '
' || coresp_zip || ' ' || coresp_city
	END
	FROM people p JOIN schools s USING (school_id)
	WHERE
	p.man_id = $1;$_$
    LANGUAGE sql;


--
-- Name: concat(text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION concat(text, text) RETURNS text
    AS $_$select $1 || $2;$_$
    LANGUAGE sql STABLE STRICT;


--
-- Name: concat(text, text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION concat(text, text, text) RETURNS text
    AS $_$select $1 || $3 || $2;$_$
    LANGUAGE sql STABLE STRICT;


--
-- Name: finish(integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION finish(integer, integer) RETURNS text
    AS $_$SELECT CASE $2
WHEN 0 THEN '?'
ELSE text($1-$2+4)
END$_$
    LANGUAGE sql;


--
-- Name: insertmanfromregistration(timestamp with time zone); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION insertmanfromregistration(timestamp with time zone) RETURNS text
    AS $_$
DECLARE
	key ALIAS FOR $1;
	row record;
	id INTEGER;
	people_ins VARCHAR;
	email_ins VARCHAR;
	email_ppt_id INTEGER;
	phone_ins VARCHAR;
	phone_ppt_id INTEGER;
	bd_ins VARCHAR;
	bd_ppt_id INTEGER;
	registration_del VARCHAR;
BEGIN
	SELECT INTO row *,to_char(birthdate,'DD.MM.YYYY') as "bd_formated" FROM registration WHERE time=key; -- v row mame riadok tabulky
	IF NOT FOUND THEN
	    RAISE EXCEPTION 'record with key % not found in table registration', key;
	END IF;

	--pridame zaznam do tabulky people
	SELECT INTO id NEXTVAL('people_man_id_seq'::text); -- v man_id mame nove people.man_id
	people_ins := '
	INSERT INTO people 
		(man_id, firstname, lastname, school_id, send, 
		home_street, home_city, home_zip, 
		coresp_street, coresp_city, coresp_zip, finish)
	VALUES ('||id||', '||
		quote_literal(row.firstname)	||', '||
		quote_literal(row.lastname)	||', '||
		quote_literal(row.school_id)	||', '||
		quote_literal(row.send)		||', '||
		quote_literal(row.home_street)	||', '||
		quote_literal(row.home_city)	||', '||
		quote_literal(row.home_zip)	||', '||
		quote_literal(row.coresp_street)||', '||
		quote_literal(row.coresp_city)	||', '||
		quote_literal(row.coresp_zip)	||', '||
		quote_literal(row.finish)	||');';
	
	--pridame zaznam pre stlpec email;
	SELECT INTO email_ppt_id ppt_id from people_prop_types where lower(name)~'e-{0,1}mail';	
	IF NOT FOUND THEN
	    RAISE EXCEPTION 'email ppt_id not found in table people_prop_types';
	END IF;
	email_ins := '
	INSERT INTO people_prop
		(man_id, ppt_id, value)
	VALUES ('||id||', '||email_ppt_id||', '||quote_literal(row.email)||');';

	--pridame zaznam pre stlpec phone;
	SELECT INTO phone_ppt_id ppt_id from people_prop_types where to_ascii(lower(name))~'telefon';
	IF NOT FOUND THEN
	    RAISE EXCEPTION 'phone ppt_id not found in table people_prop_types';
	END IF;
	phone_ins := '
	INSERT INTO people_prop
		(man_id, ppt_id, value)
	VALUES ('||id||', '||phone_ppt_id||', '||quote_literal(row.phone)||');';

	--pridame zaznam pre stlpec birthdate;/
	SELECT INTO bd_ppt_id ppt_id from people_prop_types where to_ascii(lower(name))~'datum narodenia';
	IF NOT FOUND THEN
	    RAISE EXCEPTION 'Birthdate ppt_id not found in table people_prop_types';
	END IF;
	bd_ins := '
	INSERT INTO people_prop
		(man_id, ppt_id, value)
	VALUES ('||id||', '||bd_ppt_id||', '||quote_literal(row.bd_formated)||');';
	
	--zmazanie zaznamu z tabulky registration
	registration_del := '
	DELETE FROM registration WHERE time='||quote_literal(key)||';';

	EXECUTE people_ins;
	EXECUTE email_ins;
	EXECUTE phone_ins;
	EXECUTE bd_ins;
	EXECUTE registration_del;
	
	return 'OK - man_id='||id;
end;
$_$
    LANGUAGE plpgsql;


--
-- Name: participantstasktext(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION participantstasktext(integer) RETURNS text
    AS $_$SELECT CASE $1
        WHEN 0 THEN 'astnk'
        WHEN 1 THEN 'vedci'
        WHEN 2 THEN 'in (do poznmky)'
        END
;$_$
    LANGUAGE sql;


--
-- Name: peoplenamebyfirstnamelastname(text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION peoplenamebyfirstnamelastname(text, text) RETURNS text
    AS $_$SELECT $2 || ' ' || $1;$_$
    LANGUAGE sql;


--
-- Name: peoplenamebyid(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION peoplenamebyid(integer) RETURNS text
    AS $_$SELECT peopleNameByFirstNameLastName( firstname, lastname )
        FROM people
        WHERE man_id = $1
;$_$
    LANGUAGE sql;


--
-- Name: peoplesendtext(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION peoplesendtext(integer) RETURNS text
    AS $_$SELECT CASE $1
        WHEN 0 THEN 'domov'
        WHEN 1 THEN '¹koly'
        WHEN 1 THEN 'pre kore¹pondenciu'
        END
;$_$
    LANGUAGE sql;


--
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    AS '$libdir/plpgsql', 'plpgsql_call_handler'
    LANGUAGE c;


--
-- Name: pointsofmanroundtask(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION pointsofmanroundtask(integer, integer, integer) RETURNS text
    AS $_$SELECT points
 FROM solutions_view
 WHERE man_id = $1 and round_id = $2 and task_num = $3;$_$
    LANGUAGE sql;


--
-- Name: text2float(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION text2float(text) RETURNS double precision
    AS $_$ select case
        when ($1 != '.') and ($1 != '' ) and ($1 ~ E'^[0-9]*\\.{0,1}[0-9]*$')
                then cast($1 as float)
                else 0
        end;
$_$
    LANGUAGE sql;


--
-- Name: updatemanfromregistration(timestamp with time zone, integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION updatemanfromregistration(timestamp with time zone, integer) RETURNS text
    AS $_$
DECLARE
	key ALIAS FOR $1;
	id ALIAS FOR $2;
	row record;
	people_up VARCHAR;
	email_up VARCHAR;
	email_ppt_id INTEGER;
	phone_up VARCHAR;
	phone_ppt_id INTEGER;
	bd_up VARCHAR;
	bd_ppt_id INTEGER;
	registration_del VARCHAR;
	x record;
BEGIN
	SELECT INTO row *,to_char(birthdate,'DD.MM.YYYY') as "bd_formated" FROM registration WHERE time=key; -- v row mame riadok tabulky
	IF NOT FOUND THEN
	    RAISE EXCEPTION 'record with key % not found in table registration', key;
	END IF;

	--updateneme zaznam v tabulke people
	people_up := '
	UPDATE people SET 
		firstname	='||quote_literal(row.firstname)	||', 
		lastname	='||quote_literal(row.lastname)	||', 
		school_id	='||quote_literal(row.school_id)	||', 
		send		='||quote_literal(row.send)		||', 
		home_street	='||quote_literal(row.home_street)	||', 
		home_city	='||quote_literal(row.home_city)	||', 
		home_zip	='||quote_literal(row.home_zip)	||', 
		coresp_street	='||quote_literal(row.coresp_street)	||', 
		coresp_city	='||quote_literal(row.coresp_city)	||', 
		coresp_zip	='||quote_literal(row.coresp_zip)	||', 
		finish		='||quote_literal(row.finish)		||'
	WHERE
		man_id='||id||';';
	
	--pridame zaznam pre stlpec email;
	--je email zadany?
	row.email := trim(both from row.email);
	IF row.email <> '' THEN
		SELECT INTO email_ppt_id ppt_id from people_prop_types where lower(name)~'e-{0,1}mail';
		IF NOT FOUND THEN
		    RAISE EXCEPTION 'email ppt_id not found in table people_prop_types';
		END IF;
		
		--existuje zaznam s emailom? Ak ano, tak ho updatneme
		SELECT INTO x * FROM people_prop WHERE man_id=id AND ppt_id=email_ppt_id;
		IF FOUND THEN
			email_up := '
			UPDATE people_prop SET value='||quote_literal(row.email)||'
			WHERE man_id='||id||' AND ppt_id='||email_ppt_id||';';
		ELSE
			email_up := '
			INSERT INTO people_prop	(man_id, ppt_id, value)
			VALUES ('||id||', '||email_ppt_id||', '||quote_literal(row.email)||');';
		END IF;
	ELSE
		email_up='';
	END IF;

	--pridame zaznam pre stlpec phone;
	--je email zadany?
	row.phone := trim(both from row.phone);
	IF row.phone <> '' THEN
		SELECT INTO phone_ppt_id ppt_id from people_prop_types where to_ascii(lower(name))~'telefon';
		IF NOT FOUND THEN
		    RAISE EXCEPTION 'phone ppt_id not found in table people_prop_types';
		END IF;
		
		--existuje zaznam s telefonom? Ak ano, tak ho updatneme
		SELECT INTO x * FROM people_prop WHERE man_id=id AND ppt_id=phone_ppt_id;
		IF FOUND THEN
			phone_up := '
			UPDATE people_prop SET value='||quote_literal(row.phone)||'
			WHERE man_id='||id||' AND ppt_id='||phone_ppt_id||';';
		ELSE
			phone_up := '
			INSERT INTO people_prop	(man_id, ppt_id, value)
			VALUES ('||id||', '||phone_ppt_id||', '||quote_literal(row.phone)||');';
		END IF;
	ELSE
		phone_up='';
	END IF;

	--pridame zaznam pre stlpec birthdate;
	--je datum narodenia?
	row.birthdate := trim(both from row.birthdate);
	IF row.birthdate <> '1947-01-01' THEN
		SELECT INTO bd_ppt_id ppt_id from people_prop_types where to_ascii(lower(name))~'datum narodenia';
		IF NOT FOUND THEN
		    RAISE EXCEPTION 'birthdate ppt_id not found in table people_prop_types';
		END IF;
		
		--existuje zaznam s datumom narodenia? Ak ano, tak ho updatneme
		SELECT INTO x * FROM people_prop WHERE man_id=id AND ppt_id=bd_ppt_id;
		IF FOUND THEN
			bd_up := '
			UPDATE people_prop SET value='||quote_literal(row.bd_formated)||'
			WHERE man_id='||id||' AND ppt_id='||bd_ppt_id||';';
		ELSE
			bd_up := '
			INSERT INTO people_prop	(man_id, ppt_id, value)
			VALUES ('||id||', '||bd_ppt_id||', '||quote_literal(row.bd_formated)||');';
		END IF;
	ELSE
		bd_up='';
	END IF;


	--zmazanie zaznamu z tabulky registration
	registration_del := '
	DELETE FROM registration WHERE time='||quote_literal(key)||';';
	
	EXECUTE people_up;
	EXECUTE email_up;
	EXECUTE phone_up;
	EXECUTE bd_up;
	EXECUTE registration_del;
	
/*	return 	people_up	||'
'||
		email_up	||'
'||
		phone_up	||'
'||
		bd_up		||'
'||
'';*/
	return 'OK - man_id='||id;
end;
$_$
    LANGUAGE plpgsql;


--
-- Name: aggregated_concat(text); Type: AGGREGATE; Schema: public; Owner: -
--

CREATE AGGREGATE aggregated_concat(text) (
    SFUNC = public.concat,
    STYPE = text
);


--
-- Name: array_accum(anyelement); Type: AGGREGATE; Schema: public; Owner: -
--

CREATE AGGREGATE array_accum(anyelement) (
    SFUNC = array_append,
    STYPE = anyarray,
    INITCOND = '{}'
);


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: actions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE actions (
    action_id integer DEFAULT nextval(('"actions_action_id_seq"'::text)::regclass) NOT NULL,
    name text DEFAULT 'Nezname sustredenie'::text NOT NULL,
    date_start date DEFAULT '1947-01-01'::date NOT NULL,
    date_end date DEFAULT '1947-01-07'::date NOT NULL,
    CONSTRAINT "$1" CHECK ((date_start <= date_end))
);


--
-- Name: actions_action_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE actions_action_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: aktualne_prihlasky; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE aktualne_prihlasky (
    id integer NOT NULL,
    popis character varying(50),
    typ_prihlasky integer,
    id_akcie character varying(40),
    odkedy timestamp without time zone,
    dokedy timestamp without time zone
);


--
-- Name: aktualne_prihlasky_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE aktualne_prihlasky_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: aktualne_prihlasky_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE aktualne_prihlasky_id_seq OWNED BY aktualne_prihlasky.id;


--
-- Name: people; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE people (
    man_id integer DEFAULT nextval(('"people_man_id_seq"'::text)::regclass) NOT NULL,
    firstname text DEFAULT ''::text NOT NULL,
    lastname text DEFAULT ''::text NOT NULL,
    school_id integer DEFAULT 1 NOT NULL,
    send integer DEFAULT 1 NOT NULL,
    home_street text DEFAULT ''::text NOT NULL,
    home_city text DEFAULT ''::text NOT NULL,
    home_zip text DEFAULT ''::text NOT NULL,
    coresp_street text DEFAULT ''::text NOT NULL,
    coresp_city text DEFAULT ''::text NOT NULL,
    coresp_zip text DEFAULT ''::text NOT NULL,
    finish integer DEFAULT 0 NOT NULL,
    note text DEFAULT ''::text NOT NULL,
    CONSTRAINT people_finish CHECK ((finish >= 0)),
    CONSTRAINT people_send CHECK ((((send = 0) OR (send = 1)) OR (send = 2)))
);


--
-- Name: schools; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE schools (
    school_id integer DEFAULT nextval(('"schools_school_id_seq"'::text)::regclass) NOT NULL,
    short text DEFAULT ''::text NOT NULL,
    name text DEFAULT ''::text NOT NULL,
    addr_name text DEFAULT ''::text NOT NULL,
    addr_street text DEFAULT ''::text NOT NULL,
    addr_city text DEFAULT ''::text NOT NULL,
    addr_zip text DEFAULT ''::text NOT NULL,
    phone text DEFAULT ''::text NOT NULL,
    email text DEFAULT ''::text NOT NULL,
    note text DEFAULT ''::text NOT NULL
);


--
-- Name: people_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW people_view AS
    SELECT p.man_id, peoplenamebyfirstnamelastname(p.firstname, p.lastname) AS name, p.school_id, s.name AS school_name, p.finish, p.note FROM (people p JOIN schools s USING (school_id));


--
-- Name: solutions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE solutions (
    task_id integer NOT NULL,
    man_id integer NOT NULL,
    points text DEFAULT '..'::text NOT NULL,
    electronic boolean DEFAULT false
);


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE tasks (
    task_id integer DEFAULT nextval(('"tasks_task_id_seq"'::text)::regclass) NOT NULL,
    round_id integer NOT NULL,
    num integer DEFAULT 1 NOT NULL,
    name text DEFAULT ''::text NOT NULL,
    max_points text DEFAULT ''::text NOT NULL,
    checked_by text DEFAULT ''::text NOT NULL,
    CONSTRAINT tasks_num CHECK ((num > 0))
);


--
-- Name: tasks_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW tasks_view AS
    SELECT tasks.task_id, tasks.round_id, ((text(tasks.num) || ' - '::text) || tasks.name) AS numname, tasks.num FROM tasks;


--
-- Name: all_solutions_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW all_solutions_view AS
    SELECT t.round_id, p.man_id, p.name AS man_name, p.school_id, p.school_name, p.finish, s.task_id, t.num AS task_num, t.numname AS task_numname, s.points FROM (solutions s JOIN people_view p USING (man_id)), tasks_view t WHERE (s.task_id = t.task_id);


--
-- Name: atributy_prihlasok; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE atributy_prihlasok (
    id_tipu_prihlasky integer,
    id_atributu integer NOT NULL,
    nazov_atributu character varying(20),
    popis_atributu text,
    poradie integer
);


--
-- Name: atributy_prihlasok_id_atributu_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE atributy_prihlasok_id_atributu_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: atributy_prihlasok_id_atributu_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE atributy_prihlasok_id_atributu_seq OWNED BY atributy_prihlasok.id_atributu;


--
-- Name: contests; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE contests (
    contest_id integer DEFAULT nextval(('"contests_contest_id_seq"'::text)::regclass) NOT NULL,
    name text DEFAULT 'Neznama sutaz'::text NOT NULL,
    "year" integer DEFAULT 0 NOT NULL,
    note text DEFAULT ''::text NOT NULL,
    CONSTRAINT contests_year CHECK (("year" >= 0))
);


--
-- Name: contests_contest_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE contests_contest_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: electronic_solutions; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE electronic_solutions (
    task_id integer NOT NULL,
    man_id integer NOT NULL,
    date date NOT NULL,
    "time" time without time zone NOT NULL,
    filename text NOT NULL,
    "type" text NOT NULL
);


--
-- Name: eround; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eround (
    round_id integer,
    "start" timestamp without time zone NOT NULL,
    deadline timestamp without time zone NOT NULL,
    visible integer NOT NULL,
    solution_file text
);


--
-- Name: eround_document; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE eround_document (
    round_id integer,
    file text,
    release_date timestamp without time zone,
    visible integer
);


--
-- Name: exports; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE exports (
    export_id integer DEFAULT nextval(('"exports_export_id_seq"'::text)::regclass) NOT NULL,
    name text DEFAULT ''::text NOT NULL,
    sel text DEFAULT ''::text NOT NULL
);


--
-- Name: exports_export_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE exports_export_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: formats; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE formats (
    format_id integer DEFAULT nextval(('"formats_format_id_seq"'::text)::regclass) NOT NULL,
    export_id integer NOT NULL,
    name text DEFAULT ''::text NOT NULL,
    head text DEFAULT ''::text NOT NULL,
    body text DEFAULT ''::text NOT NULL,
    foot text DEFAULT ''::text NOT NULL,
    extension text DEFAULT ''::text NOT NULL,
    "encoding" text DEFAULT ''::text NOT NULL
);


--
-- Name: formats_format_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE formats_format_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: login_map; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE login_map (
    man_id integer,
    "login" text NOT NULL,
    nick text NOT NULL
);


--
-- Name: merged; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE merged (
    id integer NOT NULL,
    prev_id integer NOT NULL,
    date timestamp without time zone
);


--
-- Name: oldsolutions; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW oldsolutions AS
    SELECT solutions.task_id, solutions.man_id, max(solutions.points) AS points FROM solutions GROUP BY solutions.task_id, solutions.man_id;


--
-- Name: paper_solutions_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW paper_solutions_view AS
    SELECT t.round_id, p.man_id, p.name AS man_name, p.school_id, p.school_name, p.finish, s.task_id, t.num AS task_num, t.numname AS task_numname, s.points FROM (solutions s JOIN people_view p USING (man_id)), tasks_view t WHERE ((s.task_id = t.task_id) AND (s.electronic = false));


--
-- Name: participants; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE participants (
    action_id integer NOT NULL,
    man_id integer NOT NULL,
    task integer DEFAULT 0 NOT NULL,
    note text DEFAULT ''::text NOT NULL,
    CONSTRAINT participants_task CHECK ((((task = 0) OR (task = 1)) OR (task = 2)))
);


--
-- Name: participants_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW participants_view AS
    SELECT par.action_id, par.man_id, peoplenamebyid(par.man_id) AS name, par.task, participantstasktext(par.task) AS task_text, par.note FROM participants par;


--
-- Name: people_man_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE people_man_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: people_prop; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE people_prop (
    man_id integer NOT NULL,
    ppt_id integer NOT NULL,
    value text DEFAULT ''::text NOT NULL
);


--
-- Name: people_prop_types; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE people_prop_types (
    ppt_id integer DEFAULT nextval(('"people_prop_types_ppt_id_seq"'::text)::regclass) NOT NULL,
    name text DEFAULT ''::text NOT NULL,
    "validator" text DEFAULT ''::text NOT NULL
);


--
-- Name: people_prop_types_ppt_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE people_prop_types_ppt_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: people_prop_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW people_prop_view AS
    SELECT pp.man_id, pp.ppt_id, pp.value, ppt.name AS ppt_name FROM (people_prop pp JOIN people_prop_types ppt USING (ppt_id));


--
-- Name: prihlasky; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE prihlasky (
    id_typu_prihlasky integer,
    id_akcie character varying(40),
    id_cloveka integer,
    id_prihlasky integer NOT NULL
);


--
-- Name: prihlasky_id_prihlasky_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE prihlasky_id_prihlasky_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: prihlasky_id_prihlasky_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE prihlasky_id_prihlasky_seq OWNED BY prihlasky.id_prihlasky;


--
-- Name: registration; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE registration (
    "time" timestamp with time zone NOT NULL,
    firstname text DEFAULT ''::text NOT NULL,
    lastname text DEFAULT ''::text NOT NULL,
    school_id integer DEFAULT 1 NOT NULL,
    send integer DEFAULT 1 NOT NULL,
    home_street text DEFAULT ''::text NOT NULL,
    home_city text DEFAULT ''::text NOT NULL,
    home_zip text DEFAULT ''::text NOT NULL,
    coresp_street text DEFAULT ''::text NOT NULL,
    coresp_city text DEFAULT ''::text NOT NULL,
    coresp_zip text DEFAULT ''::text NOT NULL,
    finish integer DEFAULT 0 NOT NULL,
    email text DEFAULT ''::text NOT NULL,
    phone text DEFAULT ''::text NOT NULL,
    birthdate date DEFAULT '1947-01-01'::date NOT NULL,
    CONSTRAINT registration_send CHECK ((((send = 0) OR (send = 1)) OR (send = 2)))
);


--
-- Name: registred; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE registred (
    man_id integer,
    merge_to integer,
    date timestamp without time zone,
    openid text NOT NULL
);


--
-- Name: rounds; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE rounds (
    round_id integer DEFAULT nextval(('"rounds_round_id_seq"'::text)::regclass) NOT NULL,
    contest_id integer NOT NULL,
    num integer DEFAULT 1 NOT NULL,
    name text DEFAULT 'Nezname kolo'::text NOT NULL,
    CONSTRAINT rounds_num CHECK ((num > 0))
);


--
-- Name: rounds_round_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE rounds_round_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: schools_school_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE schools_school_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: solutions_view; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW solutions_view AS
    SELECT t.round_id, p.man_id, p.name AS man_name, p.school_id, p.school_name, p.finish, s.task_id, t.num AS task_num, t.numname AS task_numname, s.points FROM (solutions s JOIN people_view p USING (man_id)), tasks_view t WHERE (s.task_id = t.task_id);


--
-- Name: tasks_task_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE tasks_task_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: typy_prihlasok; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE typy_prihlasok (
    id integer NOT NULL,
    popis character varying(50)
);


--
-- Name: typy_prihlasok_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE typy_prihlasok_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- Name: typy_prihlasok_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE typy_prihlasok_id_seq OWNED BY typy_prihlasok.id;


--
-- Name: vyplnene_hodnoty; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE vyplnene_hodnoty (
    id_prihlasky integer,
    id_atributu character varying(30),
    hodnota character varying(50)
);


--
-- Name: vzorake; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE vzorake (
    round_id integer,
    file text
);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE aktualne_prihlasky ALTER COLUMN id SET DEFAULT nextval('aktualne_prihlasky_id_seq'::regclass);


--
-- Name: id_atributu; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE atributy_prihlasok ALTER COLUMN id_atributu SET DEFAULT nextval('atributy_prihlasok_id_atributu_seq'::regclass);


--
-- Name: id_prihlasky; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE prihlasky ALTER COLUMN id_prihlasky SET DEFAULT nextval('prihlasky_id_prihlasky_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE typy_prihlasok ALTER COLUMN id SET DEFAULT nextval('typy_prihlasok_id_seq'::regclass);


--
-- Name: actions_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY actions
    ADD CONSTRAINT actions_pkey PRIMARY KEY (action_id);


--
-- Name: aktualne_prihlasky_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY aktualne_prihlasky
    ADD CONSTRAINT aktualne_prihlasky_pkey PRIMARY KEY (id);


--
-- Name: atributy_prihlasok_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY atributy_prihlasok
    ADD CONSTRAINT atributy_prihlasok_pkey PRIMARY KEY (id_atributu);


--
-- Name: contests_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY contests
    ADD CONSTRAINT contests_pkey PRIMARY KEY (contest_id);


--
-- Name: esc; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY electronic_solutions
    ADD CONSTRAINT esc PRIMARY KEY (task_id, man_id, "type");


--
-- Name: exports_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY exports
    ADD CONSTRAINT exports_pkey PRIMARY KEY (export_id);


--
-- Name: formats_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY formats
    ADD CONSTRAINT formats_pkey PRIMARY KEY (format_id);


--
-- Name: login_map_nick_key; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY login_map
    ADD CONSTRAINT login_map_nick_key UNIQUE (nick);


--
-- Name: login_map_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY login_map
    ADD CONSTRAINT login_map_pkey PRIMARY KEY ("login");


--
-- Name: participants_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY participants
    ADD CONSTRAINT participants_pkey PRIMARY KEY (action_id, man_id);


--
-- Name: people_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY people
    ADD CONSTRAINT people_pkey PRIMARY KEY (man_id);


--
-- Name: people_prop_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY people_prop
    ADD CONSTRAINT people_prop_pkey PRIMARY KEY (man_id, ppt_id);


--
-- Name: people_prop_types_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY people_prop_types
    ADD CONSTRAINT people_prop_types_pkey PRIMARY KEY (ppt_id);


--
-- Name: prihlasky_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY prihlasky
    ADD CONSTRAINT prihlasky_pkey PRIMARY KEY (id_prihlasky);


--
-- Name: registration_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY registration
    ADD CONSTRAINT registration_pkey PRIMARY KEY ("time");


--
-- Name: rounds_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY rounds
    ADD CONSTRAINT rounds_pkey PRIMARY KEY (round_id);


--
-- Name: schools_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY schools
    ADD CONSTRAINT schools_pkey PRIMARY KEY (school_id);


--
-- Name: solutions_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY solutions
    ADD CONSTRAINT solutions_pkey PRIMARY KEY (task_id, man_id);


--
-- Name: tasks_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tasks
    ADD CONSTRAINT tasks_pkey PRIMARY KEY (task_id);


--
-- Name: typy_prihlasok_pkey; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY typy_prihlasok
    ADD CONSTRAINT typy_prihlasok_pkey PRIMARY KEY (id);


--
-- Name: contests_name_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX contests_name_key ON contests USING btree (name, "year");


--
-- Name: exports_name_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX exports_name_key ON exports USING btree (name);


--
-- Name: formats_export_id_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX formats_export_id_key ON formats USING btree (export_id, name);


--
-- Name: people_prop_types_name_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX people_prop_types_name_key ON people_prop_types USING btree (name);


--
-- Name: rounds_contest_id_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX rounds_contest_id_key ON rounds USING btree (contest_id, num);


--
-- Name: schools_name_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX schools_name_key ON schools USING btree (name);


--
-- Name: tasks_round_id_key; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX tasks_round_id_key ON tasks USING btree (round_id, num);


--
-- Name: RI_ConstraintTrigger_16864; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16865; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16866; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16867; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16868; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16869; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16870; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16871; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16872; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16873; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16874; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16875; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16876; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16877; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16878; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16879; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16880; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16881; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16882; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16883; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16884; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16885; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16886; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16887; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16888; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16889; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16890; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16891; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16892; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16893; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16894; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16895; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16896; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16897; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16898; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16899; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16900; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16901; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16902; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16903; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16904; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16905; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16906; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16907; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16908; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16909; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16910; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16911; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16912; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16913; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16914; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16915; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16916; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16917; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16918; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16919; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16920; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16921; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16922; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16923; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16924; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16925; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16926; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16927; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16928; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16929; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16930; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16931; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16932; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16933; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16934; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16935; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16936; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16937; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16938; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16939; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16940; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16941; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16942; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16943; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16944; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16945; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16946; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16947; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16948; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16949; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16950; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16951; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16952; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16953; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16954; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16955; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16956; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16957; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16958; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16959; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16960; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16961; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16962; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16963; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16964; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16965; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16966; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16967; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16968; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16969; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16970; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16971; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_16972; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16973; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16974; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16975; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16976; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16977; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_16978; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16979; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16980; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16981; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16982; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16983; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_16984; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16985; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16986; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_16987; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16988; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16989; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_16990; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16991; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16992; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_16993; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16994; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16995; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_16996; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16997; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16998; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_16999; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17000; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17001; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17002; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17003; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17004; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17005; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17006; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17007; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17008; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17009; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17010; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17011; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17012; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17013; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17014; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17015; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17016; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17017; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17018; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17019; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17020; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17021; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17022; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17023; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17024; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17025; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17026; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17027; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17028; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17029; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17030; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17031; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17032; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17033; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17034; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17035; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17036; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17037; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17038; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17039; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17040; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17041; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17042; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17043; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17044; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17045; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17046; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17047; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17048; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17049; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17050; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17051; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17052; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17053; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17054; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17055; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17056; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17057; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17058; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17059; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17060; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17061; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17062; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17063; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17064; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17065; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17066; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17067; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17068; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17069; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17070; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17071; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17072; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17073; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17074; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17075; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17076; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17077; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17078; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17079; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17080; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17081; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17082; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17083; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17084; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17085; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17086; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17087; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17088; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17089; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17090; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17091; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17092; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17093; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17094; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17095; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17096; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17097; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17098; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17099; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17100; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17101; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17102; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17103; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17104; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON registration
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17105; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM registration
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17106; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM registration
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17107; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17108; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17109; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17110; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17111; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17112; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17113; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17114; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17115; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17116; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17117; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17118; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17119; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17120; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17121; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17122; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17123; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17124; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17125; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17126; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17127; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17128; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17129; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17130; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17131; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17132; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17133; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17134; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17135; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17136; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17137; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON registration
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17138; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM registration
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17139; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM registration
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17140; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON rounds
    FROM contests
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17141; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17142; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON contests
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'rounds', 'contests', 'UNSPECIFIED', 'contest_id', 'contest_id');


--
-- Name: RI_ConstraintTrigger_17143; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17144; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17145; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17146; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON tasks
    FROM rounds
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17147; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17148; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON rounds
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'tasks', 'rounds', 'UNSPECIFIED', 'round_id', 'round_id');


--
-- Name: RI_ConstraintTrigger_17149; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM tasks
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17150; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17151; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON tasks
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'tasks', 'UNSPECIFIED', 'task_id', 'task_id');


--
-- Name: RI_ConstraintTrigger_17152; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON solutions
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17153; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17154; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM solutions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'solutions', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17155; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM actions
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17156; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17157; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON actions
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'actions', 'UNSPECIFIED', 'action_id', 'action_id');


--
-- Name: RI_ConstraintTrigger_17158; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON participants
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17159; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17160; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM participants
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'participants', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17161; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON formats
    FROM exports
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17162; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17163; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON exports
    FROM formats
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'formats', 'exports', 'UNSPECIFIED', 'export_id', 'export_id');


--
-- Name: RI_ConstraintTrigger_17164; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17165; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_cascade_del"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17166; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people', 'UNSPECIFIED', 'man_id', 'man_id');


--
-- Name: RI_ConstraintTrigger_17167; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON people_prop
    FROM people_prop_types
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17168; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17169; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON people_prop_types
    FROM people_prop
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'people_prop', 'people_prop_types', 'UNSPECIFIED', 'ppt_id', 'ppt_id');


--
-- Name: RI_ConstraintTrigger_17170; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER INSERT OR UPDATE ON registration
    FROM schools
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17171; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER DELETE ON schools
    FROM registration
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: RI_ConstraintTrigger_17172; Type: TRIGGER; Schema: public; Owner: -
--

CREATE CONSTRAINT TRIGGER "<unnamed>"
    AFTER UPDATE ON schools
    FROM registration
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'registration', 'schools', 'UNSPECIFIED', 'school_id', 'school_id');


--
-- Name: aktualne_prihlasky_typ_prihlasky_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY aktualne_prihlasky
    ADD CONSTRAINT aktualne_prihlasky_typ_prihlasky_fkey FOREIGN KEY (typ_prihlasky) REFERENCES typy_prihlasok(id);


--
-- Name: atributy_prihlasok_id_tipu_prihlasky_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY atributy_prihlasok
    ADD CONSTRAINT atributy_prihlasok_id_tipu_prihlasky_fkey FOREIGN KEY (id_tipu_prihlasky) REFERENCES typy_prihlasok(id);


--
-- Name: electronic_solutions_man_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY electronic_solutions
    ADD CONSTRAINT electronic_solutions_man_id_fkey FOREIGN KEY (man_id) REFERENCES people(man_id);


--
-- Name: electronic_solutions_task_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY electronic_solutions
    ADD CONSTRAINT electronic_solutions_task_id_fkey FOREIGN KEY (task_id) REFERENCES tasks(task_id);


--
-- Name: eround_document_round_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY eround_document
    ADD CONSTRAINT eround_document_round_id_fkey FOREIGN KEY (round_id) REFERENCES rounds(round_id);


--
-- Name: eround_round_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY eround
    ADD CONSTRAINT eround_round_id_fkey FOREIGN KEY (round_id) REFERENCES rounds(round_id);


--
-- Name: prihlasky_id_typu_prihlasky_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY prihlasky
    ADD CONSTRAINT prihlasky_id_typu_prihlasky_fkey FOREIGN KEY (id_typu_prihlasky) REFERENCES typy_prihlasok(id);


--
-- Name: registred_man_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY registred
    ADD CONSTRAINT registred_man_id_fkey FOREIGN KEY (man_id) REFERENCES people(man_id);


--
-- Name: vyplnene_hodnoty_id_atributu_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY vyplnene_hodnoty
    ADD CONSTRAINT vyplnene_hodnoty_id_atributu_fkey FOREIGN KEY (id_atributu) REFERENCES atributy_prihlasok(id_atributu);


--
-- Name: vyplnene_hodnoty_id_prihlasky_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY vyplnene_hodnoty
    ADD CONSTRAINT vyplnene_hodnoty_id_prihlasky_fkey FOREIGN KEY (id_prihlasky) REFERENCES prihlasky(id_prihlasky);


--
-- Name: vzorake_round_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY vzorake
    ADD CONSTRAINT vzorake_round_id_fkey FOREIGN KEY (round_id) REFERENCES rounds(round_id);


--
-- PostgreSQL database dump complete
--

