<?php

require_once 'lib/messages.php';
require_once 'lib/kaspar.php';

//toto je v skutocnosti iba modul na sychronizaciu login-u a nick-u s DB
class Session_kaspar{
	private $kaspar;

	public function __construct(){
		require_once 'lib/kaspar.php';
		$this->kaspar=Kaspar::getInstance();
	}

	public function prepare(){
		try {
			$this->kaspar->beginTransaction();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function rollback(){
		//navratova hodnota ma nezaujima, tu si mas len upratat, lebo sa nieco pokazilo
		try {
			$this->kaspar->rollBack();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function commit(){
		try {
			$this->kaspar->commit();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}
    
	//je zavolana, aby sa predlzil cas vyprsania session. Ak pouzivas cookies, tak ich nastav nanovo s novym casom
	public function keepSession($name, $properties){
		try {
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function createSession($name, $properties){
		$msg=new Messages();
		try {
			//skontrolovat nickname na platne znaky
			if (isset($properties['nickname']))
				$nick = $properties['nickname'];
			else
				$nick = $name;

			if (!eregi('^[\./a-z0-9\-_ áéíóúýďťňľřěôäžčšÁÉÍÓÚÝĎŤŇĽŘĚÔÄŽČŠ]*$',$nick)){
				$msg->addWarn('Nepodarilo sa prihlásiť pre neplatné znaky v prezývke. Povolené sú len písmená, čísla, medzery, podtrhovníky a pomlčky');
				return false;
			}
			if (trim($nick)===''){
				$msg->addWarn('Nepodarilo sa prihlásiť. Prezývka musí obsahovať aspoň jeden viditeľný znak');
				return false;
			}

			if (!$this->kaspar->setNick($name,trim($nick))) {
				$msg->addWarn('Nepodarilo sa prihlásiť z dôvodu existujúcej prezývky. Prosím zmeňte si prezývku a prihláste sa znovu.');
				return false;
			}

			$clovek=$this->kaspar->getMappingByLogin($name);
			if ($clovek && $clovek['man_id'] && $this->personalDataDiffers($clovek['man_id'],$properties)){
				$msg->addMsg('Niektoré údaje získané pri prihlásení sa odlišujú s tým, čo si u nás vyplnil. Ak chceš, aby sme si naše údaje aktualizovali, klikni <a href="'.SITE_ROOT.'kaspar/?returnto='.urlencode($_SERVER['REQUEST_URI']).'">sem</a>');
			}

			return true;
		} catch (Exception $e) {
			$msg->addErr('Kaspar login exception: ' . $e->getMessage() . ' '. $e->getTraceAsString() . ' ' .  $e->getLine());
			return false;
		}
	}

	private function personalDataDiffers($id,$data){
		$kaspar=$this->kaspar;
		$clovek=$kaspar->getPeople($id);

		if (isset($data['fullname'])){
			$name = explode(" ",trim($data['fullname']));
			if ($name[0]!=$clovek['firstname'] || $name[1]!=$clovek['lastname']) return true;
		}

		if (isset($data['dob'])){
			$date = strtotime($data['dob']);
			if ($date != strtotime($kaspar->getPeopleBirthdate($id))) return true;
		}

		if (isset($data['email'])){
			$email = $data['email'];
			if ($email != $kaspar->getPeopleEmail($id)) return true;
		}
		return false;
	}

	public function destroySession(){
		//v podstate logout z podstranky
		try{
			return true;
		} catch (Exception $e) {
			//return false;	//na navratovu hodnotu tejto funkcie nie som zvedavy, iked mozno sa to casom zmeni. Zatial neviem co robit v pripade false
		}
	}

	//vrat pole s hodnotami, ktore potrebujes
	//zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
	public function getRequired(){
		return array();
	}

	//vrat pole s hodnotami, ktore chces ale prezijes ked nebudu
	//zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
	public function getOptional(){
		return array('nickname', 'fullname','dob','email','postcode'); //sem doplnit veci a spravit synchronizaciu dat z prihlasenia -> kaspara ak je spravene mapovanie na usera
	}
}

?>
