<?php
/*

Singleton

 */

class Kaspar{

	private $db;

	private function __construct(){
		require_once 'kaspar/settings.php';
		$DB_DSN='pgsql:host='.KASPAR_HOST.';dbname='.KASPAR_DB;
		$this->db=new PDO($DB_DSN,KASPAR_NAME, KASPAR_PASS);
		$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$this->db->prepare("set names 'utf8'")->execute();
	}

	public static function & getInstance(){
		static $instance;
		try {
			if (!isset($instance)){
				$instance = & new Kaspar();
			}
			return $instance;
		} catch (Exception $e) {
			throw new Exception ("Spojenie na DB bolo neuspesne");
		}
	}

	public function beginTransaction(){
		$this->db->beginTransaction();
	}

	public function commit(){
		$this->db->commit();
	}

	public function rollback(){
		$this->db->rollBack();
	}

	//dostane id usera a mapu s datami, kde kluc je meno stlpca a hodnota je hodnota co bude v DB
	public function updateUserData($manID, $data){

	}

	//vrati id-cko usera ktoremu prislucha takyto login alebo null ak nie je priradeny
	//login je case-insensitive
	public function getMappingByLogin($login){
		$db=$this->db;
		$st=$db->prepare('SELECT * FROM login_map WHERE lower(login)=lower(:login)');
		$st->bindValue(':login',$login,PDO::PARAM_STR);
		$st->execute();
		return $st->fetch();
	}

	//vrati login podla nick-u, aby sme zistili ci uz niekto taky nick nepouziva
	//nick je case-insensitive
	public function getMappingByNick($nick){
		$db=$this->db;
		$st=$db->prepare('SELECT * FROM login_map WHERE lower(nick)=lower(:nick)');
		$st->bindValue(':nick',$nick,PDO::PARAM_STR);
		$st->execute();
		return $st->fetch();
	}

	//skontroluje ci neexistuje iny uzivatel co uz taku prezyvku ma. Ak existuje, vrati false.
	//inak spravi update resp. insert zaznamu.
	public function setNick($login, $nick){
		$db=$this->db;
		$data=$data2=array();

		$data=$this->getMappingByLogin($login);	//vyberieme cloveka s tymto loginom
		$data2=$this->getMappingByNick($nick);	//vyberieme cloveka co uz taku prezyvku ma

		if ($data2 && strtolower($data2['login'])!=strtolower($login)) return false;	//ak existuje niekto iny co uz taku prezyvku ma, tak smola

		if ($data){
			$st=$db->prepare('UPDATE login_map SET nick=:nick WHERE login=:login');
		} else {
			$st=$db->prepare('INSERT INTO login_map VALUES (null, :login, :nick)');
		}
		$st->bindValue(':nick', $nick, PDO::PARAM_STR);
		$st->bindValue(':login', $login, PDO::PARAM_STR);
		$st->execute();

		return true;
	}
	
	public function setManID($login,$man_id){
	    $data=$this->getMappingByLogin($login);
	    if(!$data)return false;
	    $up=$this->db->prepare("UPDATE login_map SET man_id=:man WHERE login=:login;");
	    $up->bindValue(':man',$man_id,PDO::PARAM_INT);
	    $up->bindValue(':login',$login,PDO::PARAM_INT);
	    return $up->execute();
	}

	//vrati ulohy, ktore su v danom kole
	public function getRoundTasks($round_id){
	    $db=$this->db;
	    $sel=$db->prepare('SELECT * FROM tasks WHERE round_id=:round ORDER BY num ASC;');
	    $sel->bindValue(':round', $round_id,PDO::PARAM_INT);
	    $sel->execute();
	    return $sel->fetchAll();
	}

	//vrati meno suboru, v ktorom je ulozene uzivatelove riesenie.
	public function getUserSolutionFile($user_id,$task_id,$type){
	    $db=$this->db;
	    $sel=$db->prepare('SELECT * FROM electronic_solutions WHERE task_id=:task AND man_id=:man AND type=:type;');
	    $sel->bindValue(':task',$task_id,PDO::PARAM_INT);
	    $sel->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $sel->bindValue(':type',$type,PDO::PARAM_STR);
	    $sel->execute();
	    $field=$sel->fetchAll();
	    if(sizeof($field)<=0)return NULL;
	    return $field[0]['filename'];
	}

	//zmeni meno uploadnuteho zo suboru na novsi
	public function updateUserSolutionFile($user_id,$task_id,$type,$filename){
	    $db=$this->db;
	    $up=$db->prepare('UPDATE electronic_solutions SET date=NOW(), time=NOW(), filename=:filename WHERE task_id=:task AND man_id=:man AND type=:type');
	    $up->bindValue(':filename',$filename,PDO::PARAM_STR);
	    $up->bindValue(':task',$task_id,PDO::PARAM_INT);
	    $up->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $up->bindValue(':type',$type,PDO::PARAM_STR);
	    return $up->execute();
	}

	//vlozi novy subor, ktory uzivatel uploadol
	public function insertUserSolutionFile($user_id,$task_id,$type,$filename){
	    $db=$this->db;
	    $ins=$db->prepare('INSERT INTO electronic_solutions VALUES (:task,:man,NOW(),NOW(),:filename,:type );');
	    $ins->bindValue(':filename',$filename,PDO::PARAM_STR);
	    $ins->bindValue(':task',$task_id,PDO::PARAM_INT);
	    $ins->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $ins->bindValue(':type',$type,PDO::PARAM_STR);
	    return $ins->execute();

	}
	
	//vlozi do databazy, ze bolo odovzdane nove riesenie.
	public function insertSolution($user_id,$task_id,$points,$electronic){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM solutions WHERE man_id=:man and task_id=:task');
	    $se->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $se->bindValue(':task',$task_id,PDO::PARAM_INT);
	    $se->execute();
	    if(sizeof($se->fetchAll())==0){
		$ins=$db->prepare('INSERT INTO solutions VALUES(:task,:user,:points,:ele);');
		$ins->bindValue(':user',$user_id,PDO::PARAM_INT);
		$ins->bindValue(':task',$task_id,PDO::PARAM_INT);
		$ins->bindValue(':points',$points,PDO::PARAM_STR);
		$ins->bindValue(':ele',$electronic,PDO::PARAM_BOOL);
		return $ins->execute();//TODO insertni iba ak tam nie je
	    }
	    return true;
	}
	//vrati, ktore kola aktualne prebiehaju
	public function getActualRounds(){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM eround WHERE start<=NOW() AND deadline >= NOW() AND visible=1 ORDER BY deadline DESC;');
	    $se->execute();
	    return $se->fetchAll();
	}

	public function getPastRounds(){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM eround WHERE deadline < NOW() AND visible=1 ORDER BY deadline ASC;');
	    $se->execute();
	    return $se->fetchAll();
	}

	public function isPastRound($round_id){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM eround WHERE deadline < NOW() AND visible=1 AND round_id=:round ORDER BY deadline ASC;');
	    $se->bindValue(":round",$round_id,PDO::PARAM_INT);
	    $se->execute();
	    return (sizeof($se->fetchAll())>0);

	}

	//Vrati informacie o kole, ktore si vypytas	a zaroven musi prebiehat
    	public function getActualRound($round_id){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM eround WHERE start<=NOW() AND deadline >= NOW() AND visible=1 AND round_id=:round');
	    $se->bindValue(':round',$round_id,PDO::PARAM_INT);
	    $se->execute();
	    return $se->fetchAll();
	}

	//Vrati informacie o kole, ktore si vypytas.
	public function getRound($round_id){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM rounds WHERE round_id=:round;');
	    $se->bindValue(':round',$round_id,PDO::PARAM_INT);
	    $se->execute();
	    return $se->fetch();
	}
	
	public function getEround($round_id){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM eround WHERE round_id=:round;');
	    $se->bindValue(':round',$round_id,PDO::PARAM_INT);
	    $se->execute();
	    return $se->fetch();
	}


	//vrati informacie o conteste
	public function getContests($contest_id){
	    $db=$this->db;
	    $se=$db->prepare('SELECT * FROM contests WHERE contest_id=:contest');
	    $se->bindValue(':contest',$contest_id,PDO::PARAM_INT);
	    $se->execute();
	    return $se->fetch();
	}

	//Vyhodi tabulku s vysledkami
	public function getResults($contest_id,$round_id,$startnum,$endnum,$minnum){
	    $year=$this->getContestYear($contest_id);
	    $db=$this->db;
	    $cr=$db->prepare("
		CREATE OR REPLACE VIEW oldsolutions (task_id,man_id,points) AS
		SELECT solutions.task_id, solutions.man_id, max(solutions.points) AS points
	       FROM solutions
		GROUP BY solutions.task_id, solutions.man_id;
	    ");
	    $cr->execute();
	    if(sizeof($round_id)<=0)return NULL;
	    $arr=array();
	    $l="haluz";
	    foreach( $round_id as $val){
		if($l!="haluz")$arr[]=$l;
		$l=$val;
	    }
	    $selectadd="(";
	    $cnt=0;
	    foreach($arr as $val){
		if(strlen($selectadd)>1)$selectadd.=" OR ";
		$selectadd.="rounds.num = :rnd".$cnt++;
	    }
	    $selectadd.=")";
	    $sel1=NULL;
	    if(sizeof($arr)>0){
		$sel1=$db->prepare("
SELECT 
    people.man_id AS man_id,
    people.firstname||' '||people.lastname AS name,
    schools.name AS school,
    SUM(TEXT2FLOAT(oldsolutions.points))  AS points,
    people.finish AS finish,
    MIN(tasks.num) as num
FROM 
    people JOIN 
    schools ON
	people.school_id=schools.school_id JOIN 
    oldsolutions ON
	people.man_id=oldsolutions.man_id JOIN
    tasks ON 
	tasks.task_id=oldsolutions.task_id JOIN
    rounds ON
	rounds.round_id = tasks.round_id
    WHERE
	rounds.contest_id = :contest AND
	$selectadd AND
	tasks.num>=:start AND tasks.num<=:end 
    GROUP BY 
	people.man_id ,
	people.firstname,
	people.lastname,
	schools.name,
	people.finish
    ORDER BY 
	points DESC, name ASC;");
		$sel1->bindValue(":start",$startnum,PDO::PARAM_INT);
		$sel1->bindValue(":end",$endnum,PDO::PARAM_INT);
		$sel1->bindValue(":contest",$contest_id,PDO::PARAM_INT);
		$cnt=0;
		foreach($arr as $val){
		    $sel1->bindValue(":rnd".$cnt++,$val,PDO::PARAM_INT);
		}
		$sel1->execute();
	    }else $sel1=NULL;
	    $sel2=$db->prepare("
SELECT 
    people.man_id AS man_id,
    people.firstname||' '||people.lastname AS name, 
    people.finish AS finish,
    schools.name AS school, 
    oldsolutions.points AS points,
    tasks.num AS num 
FROM 
    people JOIN 
    schools ON 
	people.school_id=schools.school_id JOIN 
    oldsolutions ON 
	people.man_id=oldsolutions.man_id JOIN 
    tasks ON 
	tasks.task_id=oldsolutions.task_id JOIN
    rounds ON
	rounds.round_id=tasks.round_id
WHERE
    rounds.contest_id=:contest AND
    rounds.num=:rnd AND
    tasks.num>=:start AND
    tasks.num<=:end;");
	    $sel2->bindValue(":rnd",$l,PDO::PARAM_INT);
	    $sel2->bindValue(":start",$startnum,PDO::PARAM_INT);
	    $sel2->bindValue(":end",$endnum,PDO::PARAM_INT);
	    $sel2->bindValue(":contest",$contest_id,PDO::PARAM_INT);
	    $sel2->execute();
	    //man_id -- umiestnenie stare
	    $f1=array();
	    if($sel1!=NULL){
		$f1=$sel1->fetchAll();
	    }
	    $f2=$sel2->fetchAll();
	    $oldvysl=array();
	    $cnt=1;
	    $results=array();
	    foreach($f1 as $val){
		$oldvysl[$val['man_id']]=$cnt++;
		$results[$val['man_id']]['name']=$val['name'];
		$results[$val['man_id']]['man_id']=$val['man_id'];
		$results[$val['man_id']]['school']=$val['school'];
		$results[$val['man_id']]['prevpoints']=$val['points'];
		$results[$val['man_id']]['points']=$val['points'];
		$results[$val['man_id']]['finish']=$year-$val['finish']+4;
		$results[$val['man_id']]['status']="exit";
		$results[$val['man_id']]['minnum']=$val['num'];
	    }

	    foreach($f2 as $val){
		if(isset($results[$val['man_id']])){
		    $results[$val['man_id']]['points']+=$val['points'];
		}else{
		    $results[$val['man_id']]['name']=$val['name'];
		    $results[$val['man_id']]['school']=$val['school'];
		    $results[$val['man_id']]['points']=$val['points'];
		    $results[$val['man_id']]['prevpoints']=0;
		    $results[$val['man_id']]['finish']=$year-$val['finish']+4;
		    $results[$val['man_id']]['man_id']=$val['man_id'];
		    $results[$val['man_id']]['status']="new";
		    $results[$val['man_id']]['minnum']=$endnum;
		}
		$results[$val['man_id']]['minnum']=min($val['num'],$results[$val['man_id']]['minnum']);
		$results[$val['man_id']]['num'.$val['num']]=$val['points'];
	    }

	    function cmp($a,$b){ 
		if($a['points']==$b['points']){
		    if($a['name']==$b['name'])return 0;
		    if($a['name']<$b['name'])return -1;
		    return 1;
		}else{
		    if($a['points']>$b['points'])return -1;
		    return 1;
		}
	    }

	    usort($results,"cmp");
	    $cnt=1;
	    $prevp=-47;
	    foreach($results as $key => $val){
		if($val['minnum']>$minnum){
		    unset($results[$key]);
		    continue;
		}
		if($prevp!=$results[$key]['points'])$results[$key]['order']=$cnt.".";
		else $results[$key]['order']="";
		$prevp=$results[$key]['points'];
		if(isset($oldvysl[$val['man_id']])){
		   $old=$oldvysl[$val['man_id']];
		   if($cnt<$old){
			$results[$key]['status']="up";
			$results[$key]['statusnum']=$old-$cnt;
		   }
		   if($cnt>$old){
			$results[$key]['status']='down';
			$results[$key]['statusnum']=$old-$cnt;
		    }
		   if($cnt==$old){
			$results[$key]['status']='still';
			$results[$key]['statusnum']=0;
		   }
		}else{
		    $results[$key]['status']="new";
		    $results[$key]['statusnum']=0;
		}
		$cnt++;
	    }
	    return $results;
	}

	//vrati meno contestu
	public function getContestName($contest_id){
	    $sel=$this->db->prepare("
		SELECT name FROM contests WHERE contest_id=:contest;
	    ");
	    $sel->bindValue(":contest",$contest_id,PDO::PARAM_INT);
	    $sel->execute();
	    $a=$sel->fetch();
	    return $a['name'];
	}

	//vrati rok contestu
	public function getContestYear($contest_id){
	    $sel=$this->db->prepare("
		SELECT year FROM contests WHERE contest_id=:contest;
	    ");
	    $sel->bindValue(":contest",$contest_id,PDO::PARAM_INT);
	    $sel->execute();
	    $a=$sel->fetch();
	    return $a['year'];
	}

	//Vrati meno urciteho kola
	public function getContestRoundName($contest_id,$num){
	    $sel=$this->db->prepare("
		SELECT name FROM rounds WHERE num=:round AND contest_id=:contest;
	    ");
	    $sel->bindValue(":round",$num,PDO::PARAM_INT);
	    $sel->bindValue(":contest",$contest_id,PDO::PARAM_INT);
	    $sel->execute();
	    $q=$sel->fetch();
	    return $q['name'];
	}

	//vrati pre dane kolo najvacsie cislo prikladu
	public function getMaxTask($contest_id,$round_id){
	    $sel=$this->db->prepare("
		SELECT tasks.num FROM tasks JOIN rounds ON tasks.round_id=rounds.round_id WHERE rounds.contest_id=:contest AND rounds.num=:round ORDER BY tasks.num DESC LIMIT 1; ");
	    $sel->bindValue(":round",$round_id,PDO::PARAM_INT);
	    $sel->bindValue(":contest",$contest_id,PDO::PARAM_INT);
	    $sel->execute();
	    if($a=$sel->fetch()){
		return $a['num'];
	    }else return 0;
	}

	public function getSchools(){
	    $sel=$this->db->prepare("SELECT * FROM schools;");
	    $sel->execute();
	    return $sel->fetchAll();
	}

	public function getSchoolName($school_id){
	    $sel=$this->db->prepare("SELECT name FROM schools WHERE school_id=:school;");
	    $sel->bindValue(':school',$school_id,PDO::PARAM_INT);
	    if(!$sel->execute())return "SKOLA NEEXISTUJE";
	    $r=$sel->fetch();
	    return $r['name'];
	}

	public function existsUserID($user_id){
	    $sel=$this->db->prepare("SELECT * FROM people WHERE man_id=:user;");
	    $sel->bindValue(':user',$user_id,PDO::PARAM_INT);
	    $sel->execute();
	    return sizeof($sel->fetchAll())>0;
	}

	public function existsSchoolID($school_id){
	    $sel=$this->db->prepare("SELECT * FROM schools WHERE school_id=:school;");
	    $sel->bindValue(':school',$school_id,PDO::PARAM_INT);
	    $sel->execute();
	    return sizeof($sel->fetchAll())>0;
	}

	public function addRegistrant($values,$openid,$openidname){
	    $sel=$this->db->prepare("
		SELECT nextval('people_man_id_seq') as nextval;
	    ");
	    if(!$sel->execute())return false;
	    $r=$sel->fetch();
	    $id=$r['nextval'];
	    $ins=$this->db->prepare("
		INSERT INTO people (
		    man_id,
		    firstname,
		    lastname,
		    school_id,
		    send,
		    home_street,
		    home_city,
		    home_zip,
		    coresp_street,
		    coresp_city,
		    coresp_zip,
		    finish,
		    note
		    )
		VALUES (
		    :id,
		    :firstname,
		    :lastname,
		    :school,
		    :send,
		    :home_street,
		    :home_city,
		    :home_zip,
		    :coresp_street,
		    :coresp_city,
		    :coresp_zip,
		    :finish,
		    :poznamka
		    );
	    ");
	    $ins->bindValue(':id',$id,PDO::PARAM_INT);
	    $ins->bindValue(':firstname',$values['firstname'],PDO::PARAM_STR);
	    $ins->bindValue(':lastname',$values['lastname'],PDO::PARAM_STR);
	    $ins->bindValue(':school',$values['school'],PDO::PARAM_INT);
	    $ins->bindValue(':finish',$values['finish'],PDO::PARAM_INT);
	    $ins->bindValue(':send',$values['corespondence'],PDO::PARAM_INT);
	    $ins->bindValue(':home_street',$values['adrstreet'],PDO::PARAM_STR);
	    $ins->bindValue(':home_city',$values['adrtown'],PDO::PARAM_STR);
	    $ins->bindValue(':home_zip',$values['adrpsc'],PDO::PARAM_STR);
	    $ins->bindValue(':coresp_street',$values['corstreet'],PDO::PARAM_STR);
	    $ins->bindValue(':coresp_city',$values['cortown'],PDO::PARAM_STR);
	    $ins->bindValue(':coresp_zip',$values['corpsc'],PDO::PARAM_STR);
   	    $ins->bindValue(':poznamka',$values['poznamka'],PDO::PARAM_STR);
	    if(!$ins->execute())return false;
	    if(is_number($values['id'])){
	        $ins=$this->db->prepare("
		    INSERT INTO
			registred(
			    man_id,
			    merge_to,
			    date,
			    openid)
		    VALUES (
			:manid,
			:mergeto,
			NOW(),
			:openid);"); 
	    }else{
		 $ins=$this->db->prepare("
		    INSERT INTO
			registred(
			    man_id,
			    merge_to,
			    date,
			    openid)
		    VALUES (
			:manid,
			NULL,
			NOW(),
			:openid);"); 

	    }
	    $ins->bindValue(':manid',$id,PDO::PARAM_INT);
	    if(is_number($values['id']))$ins->bindValue(':mergeto',$values['id'],PDO::PARAM_INT);
	    $ins->bindValue(':openid',$openid);
	    if(!$ins->execute())return false;
	    $birth=$values['birthday_day'].".".$values['birthday_month'].".".$values['birthday_year'];
	    if(!$this->setPeopleBirthdate($id,$birth))return false;;
	    if(!$this->setPeopleEmail($id,$values['email']))return false;
	    if(!$this->setPeopleIM($id,$values['im']))return false;
	    if(!$this->setPeoplePhone($id,$values['phone']))return false;
	    if(!$this->setManID($openid,$id))return false;
	    return true;
	}

	public function getPeople($user_id){
	    $sel=$this->db->prepare("
		    SELECT * FROM people WHERE man_id=:id;
	    ");
	    $sel->bindValue('id',$user_id,PDO::PARAM_INT);
	    $sel->execute();
	    return $sel->fetch();
	}

	public function getPeopleProp($user_id,$prop){
	    $sel=$this->db->prepare("
		SELECT value 
		FROM 
		    people JOIN people_prop ON 
			people.man_id=people_prop.man_id
		WHERE 
		    people.man_id=:man AND
		    people_prop.ppt_id=:prop;
	    ");
	    $sel->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $sel->bindValue(':prop',$prop,PDO::PARAM_INT);
	    $sel->execute(); 
	    $res=$sel->fetchAll();
	    foreach($res as $value){
		return $value['value'];
	    }
	    return NULL;
	}

	public function getPeopleBirthdate($user_id){
	    return $this->getPeopleProp($user_id,2); 
	}
	
	public function getPeopleEmail($user_id){
	    return $this->getPeopleProp($user_id,1); 
	}

	public function getPeopleIM($user_id){
	    return $this->getPeopleProp($user_id,17); 
	}

	public function getPeoplePhone($user_id){
	    return $this->getPeopleProp($user_id,4); 
	}

	public function insertPeopleProp($user_id,$prop,$value){
	    $ins=$this->db->prepare("
		    INSERT INTO people_prop (man_id, ppt_id, value)
		    VALUES(
			:user,
			:prop,
			:value
		    );");
	    $ins->bindValue('user',$user_id,PDO::PARAM_INT);
	    $ins->bindValue('prop',$prop,PDO::PARAM_INT);
	    $ins->bindValue('value',$value,PDO::PARAM_STR);
	    return $ins->execute();
	}

	public function existsPeopleProp($user_id,$prop){
	    $sel=$this->db->prepare("
		    SELECT man_id 
		    FROM people_prop
		    WHERE man_id=:man 
		    AND ppt_id=:prop;");
	    $sel->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $sel->bindValue(':prop',$prop,PDO::PARAM_INT);
	    $sel->execute();
	    return sizeof($sel->fetchAll())>0;
	}

	public function updatePeopleProp($user_id,$prop,$value){
	    $up=$this->db->prepare("
		    UPDATE people_prop
		    SET value=:value
		    WHERE 
			man_id=:man AND
			ppt_id=:prop;");
	    $up->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $up->bindValue(':prop',$prop,PDO::PARAM_INT);
	    $up->bindValue(':value',$value,PDO::PARAM_STR);
	    return $up->execute();
	}

	public function setPeopleProp($user_id,$prop,$value){
	    if($this->existsPeopleProp($user_id,$prop)){
		return $this->updatePeopleProp($user_id,$prop,$value);
	    }else{
		return $this->insertPeopleProp($user_id,$prop,$value);
	    }
	}

	public function setPeopleBirthdate($user_id,$value){
	    return $this->setPeopleProp($user_id,2,$value);
	}
	
	public function setPeopleEmail($user_id,$value){
	    return $this->setPeopleProp($user_id,1,$value);
	}

	public function setPeopleIM($user_id,$value){
	    return $this->setPeopleProp($user_id,17,$value);
	}

	public function setPeoplePhone($user_id,$value){
	    return $this->setPeopleProp($user_id,4,$value);
	}
	
	//POZOR NA $column. Moze viest k SQL injection
	private function setPeopleCol($user_id,$column,$value,$type=PDO::PARAM_STR){
	    $up=$this->db->prepare("
		    UPDATE people
		    SET $column=:value
		    WHERE man_id=:man;");
	    $up->bindValue(':value',$value,$type);
	    $up->bindValue(':man',$user_id,PDO::PARAM_INT);
	    return $up->execute();
	}

	public function setPeopleFirstname($user_id,$value){
	    return $this->setPeopleCol($user_id,'firstname',$value);
	}

	public function setPeopleLastname($user_id,$value){
	    return $this->setPeopleCol($user_id,'lastname',$value);
	}

	public function setPeopleSchoolID($user_id,$value){
	    return $this->setPeopleCol($user_id,'school_id',$value,PDO::PARAM_INT);
	}

	public function setPeopleSend($user_id,$value){
	    return $this->setPeopleCol($user_id,'send',$value,PDO::PARAM_INT);
	}

	public function setPeopleHomeStreet($user_id,$value){
	    return $this->setPeopleCol($user_id,'home_street',$value);
	}

	public function setPeopleHomeCity($user_id,$value){
	    return $this->setPeopleCol($user_id,'home_city',$value);
	}

	public function setPeopleHomeZip($user_id,$value){
	    return $this->setPeopleCol($user_id,'home_zip',$value);
	}

	public function setPeopleCorespStreet($user_id,$value){
	    return $this->setPeopleCol($user_id,'coresp_street',$value);
	}

	public function setPeopleCorespCity($user_id,$value){
	    return $this->setPeopleCol($user_id,'coresp_city',$value);
	}

	public function setPeopleCorespZip($user_id,$value){
	    return $this->setPeopleCol($user_id,'coresp_zip',$value);
	}

	public function setPeopleFinish($user_id,$value){
	    return $this->setPeopleCol($user_id,'finish',$value);
	}

	//mozu sa pozadovat nasledovne veci: 'firstname' ,'lastname'
	//,'birthdate', 'school', 'finish', 'corespondence', 'home_address',
	//'cor_address', 'email', 'phone', 'im'
	//
	//ak je man_id null, tak iba vygeneruje url

	private function emptyArrString($arr,$string){
	    if($arr[$string]!=""&&$arr[$string]!=NULL)return false;
	    return true;
	}

	public function checkPeopleValueAndGetUrl($man_id,$values){
	    $url="";
	    $good=true;
	    $people=$this->getPeople($man_id);
	    foreach($values as $val){
		if($man_id!=NULL){
		 switch($val){
		    case 'firstname' :
			if($this->emptyArrString($people,'firstname'))$good=false;
			break;
                    case 'lastname' :
			if($this->emptyArrString($people,'lastname'))$good=false;
			break;
                    case 'birthdate':
			if(!$this->existsPeopleProp($man_id,2))$good=false;
			break;
                    case 'school':
			if($this->emptyArrString($people,'school_id'))$good=false;
			break;
                    case 'finish':
			if($this->emptyArrString($people,'finish'))$good=false;
			break;
                    case 'corespondence':
			if($this->emptyArrString($people,'send'))$good=false;
			break;
                    case 'home_address':
			if($this->emptyArrString($people,'home_street'))$good=false;
			if($this->emptyArrString($people,'home_city'))$good=false;
			if($this->emptyArrString($people,'home_zip'))$good=false;
			break;
                    case 'cor_address':
			if($this->emptyArrString($people,'coresp_street'))$good=false;
			if($this->emptyArrString($people,'coresp_city'))$good=false;
			if($this->emptyArrString($people,'coresp_zip'))$good=false;
			break;
                    case 'email':
			if(!$this->existsPeopleProp($man_id,1))$good=false;
			break;
                    case 'phone':
			if(!$this->existsPeopleProp($man_id,2))$good=false;
			break;
                    case 'im':
			if(!$this->existsPeopleProp($man_id,2))$good=false;
			break;
		 }
		}else $good=false;
		 if($val=='birthdate'){
		    $url.=",birthday_year,birthday_month,birthday_day";
		 }elseif($val=='home_address'){
		    $url.=",adrtown,adrstreet,adrpsc";
		 }elseif($val=='cor_address'){
		    $url.=",cortown,cortown,corstreet";
		 }else{
		    $url.=",$val";
		 }
	    }
	    if($good)return NULL;
	    return "ePrihlaska/?needed=$url";
	}
	
	public function getNearPeople($user_id){
	    $sel=$this->db->prepare("
		SELECT
			p.man_id, p.firstname, p.lastname,
			p.finish, schools.name
		FROM
			people p JOIN schools USING(school_id),
			people pp
		WHERE
			(NOT pp.man_id=p.man_id) AND
			pp.man_id=:man AND
			( lower(to_ascii(pp.lastname)) = lower(to_ascii(p.lastname)) )");
	    $sel->bindValue(':man',$user_id,PDO::PARAM_INT);
	    $sel->execute();
	    return $sel->fetchAll();
	}

	//MERGOVANIE LUDI!!!!!!!!!

	private function mergePeopleTableLoginMap($destination,$source){
	    $db=$this->db;
	    $up=$db->prepare("
		UPDATE login_map
		SET man_id=:dest
		WHERE man_id=:src;
	    ");
	    $up->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $up->bindValue(':src',$source,PDO::PARAM_INT);
	    $ret=$up->execute();
	    if(!$ret)$db->rollBack();
	    return $ret;
	}

	private function mergePeopleTableParticipants($destination,$source){
	    $db=$this->db;
	    $ins=$db->prepare("
		INSERT INTO 
		    participants (action_id,man_id,task,note)
		    
		    (
			SELECT action_id,:dest,task,note 
			FROM participants as p
			WHERE 
			    man_id=:src AND
			    NOT EXISTS (
				SELECT action_id,man_id 
				FROM participants as pp
				WHERE 
				    p.action_id=pp.action_id AND
				    pp.man_id=:dest
			    )
		    ) 
	    ");
	    $ins->bindValue(':src',$source,PDO::PARAM_INT);
	    $ins->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $res=$ins->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    $del=$db->prepare("
		DELETE FROM participants
		WHERE man_id=:src;
	    ");
	    $del->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    return true;
	}

	private function mergePeopleTableElectronicSolutions($destination,$source){//TODO -- upratat fajly
	    $db=$this->db;
	    //delete 1 < z $dest ktore su < ako src
	    $del=$db->prepare("
		DELETE FROM electronic_solutions AS ed
		WHERE 
		    ed.man_id=:dest AND
		    EXISTS (
			SELECT * 
			FROM electronic_solutions AS es
			WHERE
			    es.man_id=:src AND
			    es.task_id=ed.task_id AND
			    es.type=ed.type AND
			    (
				ed.date < es.date OR
				( 
				    ed.date=es.date AND
				    ed.time<es.time
				)
			    )
			    
		    );
	    ");
	    $del->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $del->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //delete 2 >=
	    $del=$db->prepare("
		DELETE FROM electronic_solutions AS es
		WHERE
		    es.man_id=:src AND
		    EXISTS (
			SELECT * 
			FROM electronic_solutions AS ed
			WHERE
			    ed.man_id=:dest AND
			    ed.task_id=es.task_id AND
			    ed.type=ed.type AND
			    (
				ed.date > es.date OR
				(
				    ed.date=es.date AND
				    ed.time >=es.time
				)
			    )
		    );
	    ");
	    $del->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $del->bindValue(':src',$source,PDO::PARAM_INT);
	    $del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //insert
	    $ins=$db->prepare("
		INSERT INTO electronic_solutions (task_id,man_id,date,time,filename,type) (
		    SELECT task_id,:dest,date,time,filename,type
		    FROM electronic_solutions
		    WHERE man_id=:src
		);
	    ");
	    $ins->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $ins->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$ins->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //delete 3
	    $del=$db->prepare("
		DELETE FROM electronic_solutions 
		WHERE man_id=:src;
	    ");
	    $del->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    return true;
	}

	private function mergePeopleTableSolutions($destination,$source){
	   $db=$this->db;
	   $tmp=$db->prepare("
		CREATE TEMP TABLE 
		    lalala
		AS
		    SELECT 
			task_id,
			$destination AS man_id,
			points,
			electronic 
		    FROM 
			solutions 
		    WHERE
			man_id=:dest
		    UNION
		    SELECT 
			task_id,
			$destination AS man_id,
			points,
			electronic
		    FROM
			solutions
		    WHERE
			man_id=:src");
	    $tmp->bindValue(':src',$source,PDO::PARAM_INT);
	    $tmp->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $res=$tmp->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //delete
	    $del=$db->prepare("
		DELETE FROM solutions
		WHERE
		    man_id=:dest OR
		    man_id=:src;
	    ");
	    $del->bindValue(':src',$source,PDO::PARAM_INT);
	    $del->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $res=$del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //insert
	    $ins=$db->prepare("
		INSERT INTO 
		    solutions (
			task_id,
			man_id,
			points,
			electronic
		    )
		    SELECT 
			task_id,
			man_id,
			MAX(points) AS points,
			electronic 
		    FROM 
			lalala 
		    GROUP BY
			task_id,
			man_id,
			electronic;");
	    $res=$ins->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //drop
	    $dr=$db->prepare("DROP TABLE lalala;");
	    $res=$dr->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    return true;

	}

	private function mergePeopleTablePeopleProp($destination,$source,$preference){
	    $db=$this->db;
	    if($preference=="keep_destination"){
		$del=$db->prepare("
		    DELETE FROM 
			people_prop AS pd
		    WHERE
			pd.man_id=:src AND
			EXISTS (
			    SELECT *
			    FROM 
				people_prop AS ps
			    WHERE
				ps.ppt_id=pd.ppt_id AND
				ps.man_id=:dest
			);
		");
		$del->bindValue(':src',$source,PDO::PARAM_INT);
		$del->bindValue(':dest',$destination,PDO::PARAM_INT);
		$res=$del->execute();
		if(!$res){
		    $db->rollBack();
		    return false;
		}
	    }elseif($preference=="keep_source"){
		$del=$db->prepare("
		    DELETE FROM
			people_prop AS ps
		    WHERE 
			ps.man_id=:dest AND
			EXISTS (
			    SELECT * 
			    FROM
				people_prop AS pd
			    WHERE
				ps.ppt_id=pd.ppt_id AND
				pd.man_id=:src
			);
		");
		$del->bindValue(':src',$source,PDO::PARAM_INT);
		$del->bindValue(':dest',$destination,PDO::PARAM_INT);
		$res=$del->execute();
		if(!$res){
		    $db->rollBack();
		    return false;
		}
	    }else{
		$db->rollBack();
		return false;
	    }
	    //insert
	    $ins=$db->prepare("
		INSERT INTO 
		    people_prop 
		    (
			man_id,
			ppt_id,
			value
		    )
		    SELECT
			:dest,
			ppt_id,
			value
		    FROM
			people_prop
		    WHERE
			man_id=:src;");
	    $ins->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $ins->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$ins->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    //delete
	    $del=$db->prepare("
		DELETE FROM 
		    people_prop
		WHERE 
		    man_id=:src;
	    ");
	    $del->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    return true;
	}

	private function mergePeopleTablePeople($destination,$source,$preference){
	    $db=$this->db;
	    $del=$db->prepare("
		DELETE FROM 
		    people
		WHERE 
		    man_id=:del;");
	    if($preference=="keep_destination"){
	    }elseif($preference=="keep_source"){
		$people=$this->getPeople($source);
		$up=$db->prepare("
		    UPDATE 
			people
		    SET
			firstname=:first,
			lastname=:last,
			school_id=:school,
			send=:send,
			home_street=:hs,
			home_city=:hc,
			home_zip=:hz,
			coresp_street=:cs,
			coresp_city=:cc,
			coresp_zip=:cz,
			finish=:finish,
			note=:note
		    WHERE
			man_id=:dest;");
		$up->bindValue(':first',$people['firstname'],PDO::PARAM_STR);
		$up->bindValue(':last',$people['lastname'],PDO::PARAM_STR);
		$up->bindValue(':school',$people['school_id'],PDO::PARAM_INT);
		$up->bindValue(':send',$people['send'],PDO::PARAM_INT);
		$up->bindValue(':hs',$people['home_street'],PDO::PARAM_STR);
		$up->bindValue(':hc',$people['home_city'],PDO::PARAM_STR);
		$up->bindValue(':hz',$people['home_zip'],PDO::PARAM_STR);
		$up->bindValue(':cs',$people['coresp_street'],PDO::PARAM_STR);
		$up->bindValue(':cc',$people['coresp_city'],PDO::PARAM_STR);
		$up->bindValue(':cz',$people['coresp_zip'],PDO::PARAM_STR);
		$up->bindValue(':finish',$people['finish'],PDO::PARAM_INT);
		$up->bindValue(':note',$people['note'],PDO::PARAM_STR);
		$up->bindValue(':dest',$destination,PDO::PARAM_INT);
		$res=$up->execute();
		if(!$res){
		    $db->rollBack();
		    return false;
		}
	    }else{
		$db->rollBack();
		return false;
	    }
	    $del->bindValue(":del",$source,PDO::PARAM_INT);
	    $res=$del->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    $ins=$this->db->prepare("INSERT INTO merged values (:dest,:src,NOW());");
	    $ins->bindValue(':dest',$destination,PDO::PARAM_INT);
	    $ins->bindValue(':src',$source,PDO::PARAM_INT);
	    $res=$ins->execute();
	    if(!$res){
		$db->rollBack();
		return false;
	    }
	    return true;
	}

	public function mergePeople($destination,$source,$people_preference,$prop_preference){//TODO: otestovat!!!
	    if(!$this->existsUserID($destination))return false;
	    if(!$this->existsUserID($source))return false;
	    if($people_preference!='keep_destination'&&$people_preference!='keep_source')return false;
	    if($prop_preference!='keep_destination'&&$prop_preference!='keep_source')return false;
	    $db=$this->db;
	    $db->beginTransaction();
	    $res=true; 
	    if($res){
		$res&=$this->mergePeopleTableLoginMap($destination,$source);	
	    }
	    if($res){
		$res&=$this->mergePeopleTableParticipants($destination,$source);
	    }
	    if($res){
		$res&=$this->mergePeopleTableElectronicSolutions($destination,$source);
	    }
	    if($res){
		$res&=$this->mergePeopleTableSolutions($destination,$source);
	    }
	    if($res){
		$res&=$this->mergePeopleTablePeopleProp($destination,$source,$prop_preference);
	    }
	    if($res){
		$r=$this->deleteRegistred($source);
		$res&=$r;
		if(!$r){
		    $db->rollBack();
		}
	    }
	    if($res){
		$res&=$this->mergePeopleTablePeople($destination,$source,$people_preference);
	    }
	    if($res){
		$db->commit();
		return true;
	    }
	    return false;
	}

	public function getRegistred(){
	    $sel=$this->db->prepare("SELECT * FROM registred ORDER BY date ASC;");
	    $sel->execute();
	    return $sel->fetchAll();
	}

	public function deleteRegistred($man_id){
	    $del=$this->db->prepare("DELETE FROM registred WHERE man_id=:man;");
	    $del->bindValue(':man',$man_id,PDO::PARAM_INT);
	    return $del->execute();
	}
	
	public function getManPeopleProps($man_id){
	    $sel=$this->db->prepare("
		SELECT 
		    people_prop.ppt_id,
		    people_prop_types.name,
		    people_prop.value 
		FROM 
		    people_prop JOIN
		    people_prop_types ON
			people_prop.ppt_id=people_prop_types.ppt_id 
		WHERE
		    people_prop.man_id=:man
		ORDER BY people_prop.ppt_id ASC;
	    ");
	    $sel->bindValue(':man',$man_id,PDO::PARAM_INT);
	    $sel->execute();
	    return $sel->fetchAll();
	}

	public function solvedRound($round_id,$man_id){
	    $sel=$this->db->prepare("
		SELECT * 
		FROM 
		    solutions JOIN
		    tasks ON 
			 solutions.task_id=tasks.task_id 
	 	WHERE 
		    round_id=:round AND
		    man_id=:man;
	    ");
	    $sel->bindValue(':man',$man_id,PDO::PARAM_INT);
	    $sel->bindValue(':round',$round_id,PDO::PARAM_INT);
	    $sel->execute();
	    return (sizeof($sel->fetchAll())>0); 
	}

	
    };
?>
