<?php
/*
define('OPENID_INCLUDE', dirname(__FILE__).'/openid');

if (ereg(';', $_SERVER['PATH']))
	ini_set('include_path', ini_get('include_path').';'.OPENID_INCLUDE);
else
	ini_set('include_path', ini_get('include_path').':'.OPENID_INCLUDE);
*/

require_once 'lib/messages.php';
require_once 'lib/sessions.php';
//require_once 'lib/openid/common.php';
require_once 'lib/openid/SimpleOpenID.php';

if (!session_id()) @session_start();

//autentifikacna kniznica OpenID
class OpenID extends Messages implements Auth {
	private $session_manager;
	
	private function __construct($sm){
	    $this->session_manager=$sm;
	}

	public static function & getInstance($sm){
		static $instance;
		if (!isset($instance)){
			$instance = & new OpenID($sm);
		}
		return $instance;
	}

	public function checkLogin(){
		//pozriet ci sa niekto neskusal prihlasit cez openID
		//ak ano, tak zavolat session managera, nech sa postara o podstranky

/*		if (isset($_POST['openid_login'],$_POST['openid_submit'])) return $this->tryAuth($_POST['openid_login']);
		if ($res = $this->finishAuth()) return $this->session_manager->createSessions($res[0],$res[1]);*/
		
		$openID_mode = array_key_exists("openid_mode",$_GET) ? $_GET['openid_mode'] : "";
		if (isset($_POST['openid_login'],$_POST['openid_submit'])) {
			$openid = new SimpleOpenID(); //SimpleOpenID::getInstance();
			$openid->SetIdentity($_POST['openid_login']);
			$openid->SetTrustRoot('http://' . $_SERVER["HTTP_HOST"]);
			$openid->SetRequiredFields($this->session_manager->getRequired());
			$openid->SetOptionalFields($this->session_manager->getOptional());
			if ($openid->GetOpenIDServer()){
				$openid->SetApprovedURL('http://' . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
				$openid->Redirect();
				exit(0);
			} else {
				$error = $openid->GetError();
				$str = "ERROR CODE: " . $error['code'] . "<br>";
				$str .= "ERROR DESCRIPTION: " . $error['description'] . "<br>";
				$this->addErr($str);
				return false;
			}
		} else if ($openID_mode == "id_res") {
			$openid = new SimpleOpenID(); //SimpleOpenID::getInstance();
			$openid->SetIdentity($_GET['openid_identity']);
			$openid_validation_result = $openid->ValidateWithServer();
			if ($openid_validation_result == true) {
				//$identity = substr($_GET['openid_identity'],strpos($_GET['openid_identity'],"//")+2);
				$identity = $this->standardize($_GET['openid_identity']);
				return $this->session_manager->createSessions($identity,$this->parseArgs());
			} else if ($openid->IsError() == true) {
				$error = $openid->GetError();
				$str = "ERROR CODE: " . $error['code'] . "<br>";
				$str .= "ERROR DESCRIPTION: " . $error['description'] . "<br>";
				$this->addErr($str);
				return false;
			} else {
				$this->addWarn("INVALID AUTHORIZATION");
				return false;
			}
		} else if ($openID_mode == 'cancel') {
			$this->addErr("USER CANCELED REQUEST");
			return false;
		}
		
		return false;
	}

	private function parseArgs(){
		$Auth_OpenID_sreg_data_fields = array(
			'fullname' => 'Full Name',
			'nickname' => 'Nickname',
			'dob' => 'Date of Birth',
			'email' => 'E-mail Address',
			'gender' => 'Gender',
			'postcode' => 'Postal Code',
			'country' => 'Country',
			'language' => 'Language',
			'timezone' => 'Time Zone');
		$res=array();
		foreach ($Auth_OpenID_sreg_data_fields as $key=>$item){
			if (isset($_GET['openid_sreg_'.$key])) $res[$key]=$_GET['openid_sreg_'.$key];
		}
		return $res;
	}

	private function tryAuth($login){
		//tu sa spravi nejaka kontrola, skonstruuje poziadavok a presmeruje na OpenID server
		$consumer = getConsumer();
		$auth_request = $consumer->begin($login);

		if (!$auth_request) {
			$this->addErr("Chyba pri autentifikácii: neplatné OpenID.");
			return false;
		}

		$sreg_request = Auth_OpenID_SRegRequest::build(
			$this->session_manager->getRequired(),
			$this->session_manager->getOptional());

		if ($sreg_request) {
			$auth_request->addExtension($sreg_request);
		}

		//TODO: WTF?, zatial to nebudeme pouzivat
		$policy_uris = array(
			'http://schemas.openid.net/pape/policies/2007/06/multi-factor-physical',
			'http://schemas.openid.net/pape/policies/2007/06/multi-factor',
			'http://schemas.openid.net/pape/policies/2007/06/phishing-resistant'
		);
		//$pape_request = new Auth_OpenID_PAPE_Request($policy_uris);	//zatial to vynechame
		$pape_request = null;

		if ($pape_request) {
			$auth_request->addExtension($pape_request);
		}

		if ($auth_request->shouldSendRedirect() || true) {
			//sem pojdeme stale, kedze druha moznost je zatial nepriatelna
			$redirect_url = $auth_request->redirectURL(getTrustRoot(), getReturnTo());
			// If the redirect URL can't be built, display an error
			if (Auth_OpenID::isFailure($redirect_url)) {
				$this->addErr("Chyba pri presmerovaní: " . $redirect_url->message);
				return false;
			} else {
				// Send redirect.
				header("Location: ".$redirect_url);
			}
		} else {
			// Generate form markup and render it.
			$form_id = 'openid_message';
			$form_html = $auth_request->htmlMarkup(getTrustRoot(), getReturnTo(), false, array('id' => $form_id));

			// Display an error if the form markup couldn't be generated;
			// otherwise, render the HTML.
			if (Auth_OpenID::isFailure($form_html)) {
				//TODO error: Could not redirect to server: $form_html->message
			} else {
				//TODO: print $form_html;
			}
		}
		return false;
	}

	private function finishAuth(){
		//dokonci autentifikaciu
		//kontrola na povinne parametre
		//return true;
		$consumer = getConsumer();
		$return_to = getReturnTo();
		$response = $consumer->complete($return_to);

		if ($response->status == Auth_OpenID_CANCEL) {
			$this->addErr("Overenie zrušené");
			return false;
		} else if ($response->status == Auth_OpenID_FAILURE) {
			$this->addErr("Overenie zlyhalo: " . $response->message);
			return false;
		} else if ($response->status == Auth_OpenID_SUCCESS) {
			
			$openid = $response->getDisplayIdentifier();
			$esc_identity = escape($openid);
			
			$success = "Úspešne ste sa prihlásili ako " . $esc_identity;
			
			if ($response->endpoint->canonicalID) {
				$escaped_canonicalID = escape($response->endpoint->canonicalID);
				$success .= ' (XRI CanonicalID: '.$escaped_canonicalID.')';
			}
			
			$sreg_resp = Auth_OpenID_SRegResponse::fromSuccessResponse($response);
			
			$sreg = $sreg_resp->contents();
			
			//kontrola na vsetky povinne parametre
			foreach ($this->session_manager->getRequired() as $key=>$item){
				if (!isset($sreg[$item])){
					$this->addErr("Neboli poskytnuté všetky informácie: " . $item);
					return false;
				}
			}
			$this->addMsg($success);
			
			/*
			$pape_resp = Auth_OpenID_PAPE_Response::fromSuccessResponse($response);
			if ($pape_resp) {
				if ($pape_resp->auth_policies) {
					$success .= "<p>The following PAPE policies affected the authentication:</p><ul>";

					foreach ($pape_resp->auth_policies as $uri) {
						$escaped_uri = escape($uri);
						$success .= "<li><tt>$escaped_uri</tt></li>";
					}

					$success .= "</ul>";
				} else {
					$success .= "<p>No PAPE policies affected the authentication.</p>";
				}

				if ($pape_resp->auth_age) {
					$age = escape($pape_resp->auth_age);
					$success .= "<p>The authentication age returned by the " .
						"server is: <tt>".$age."</tt></p>";
				}

				if ($pape_resp->nist_auth_level) {
					$auth_level = escape($pape_resp->nist_auth_level);
					$success .= "<p>The NIST auth level returned by the " .
						"server is: <tt>".$auth_level."</tt></p>";
				}

			} else {
				$success .= "<p>No PAPE response was sent by the provider.</p>";
			}
			*/
			
			return array($openid,$sreg);
		}
		return false;
	}
	
	private function standardize($openid_identity){
		$u = parse_url(strtolower(trim($openid_identity)));
		return substr(strtolower(trim($openid_identity)),strlen($u['scheme'])+3,strlen($openid_identity));
	}

}

?>
