<?php

require_once 'lib/messages.php';

interface Auth{
	public function checkLogin();
}

class PrepareException extends Exception{
}

class LoginException extends Exception{
}

class CommitException extends Exception{
}

class SessionManager extends Messages{
	private $req=array();   //mapa required vlastnosti / premennych ktore ziskavam z auth kniznice
	private $opt=array();   //mapa optional vlastnosti / premennych ktore ziskavam z auth kniznice
	private $subpages=array();     //zoznam podstranok
	private $subpages_classes=array();

	private function __construct($subpages){
		$this->subpages=$subpages;

		//vyrobit triedy vsetkych podstranok a zistit ci nieco potrebuju

		foreach ($this->subpages as $key=>$item){
			try {
				require_once $item.'/session_manager.php';
				$tmp='Session_'.$item;
				$this->subpages_classes[$item] = new $tmp();

				$tmp = array();
				$tmp = $this->subpages_classes[$item]->getRequired();
				foreach ($tmp as $key2=>$item2)
					$this->req[$item2]=true;

				$tmp = array();
				$tmp = $this->subpages_classes[$item]->getOptional();
				foreach ($tmp as $key2=>$item2)
					$this->opt[$item2]=true;
			} catch (Exception $e) {
				$this->addErr('Nepodarilo sa inicializovať časť '.$tmp);
			}
		}
	}

	public static function & getInstance($subpages=array()){
		static $instance;
		if (!isset($instance)){
			$instance = & new SessionManager($subpages);
		}
		return $instance;
	}

	public function createSessions($name, $values){
		if ($this->getCurrentUser()) return false;	//ak je uz niekto prihlaseny, tak nebudeme vytvarat novu session
		$err='';
		foreach ($this->getRequired() as $item){
			if (!isset($values[$item]) || $values[$item]==='') $err.=' '.$item;
		}
		if ($err!='') {
			$this->addErr('Niektoré informácie vyžadované pri prihlásení chýbajú alebo sú neúplné:'.$err.'. Pre viac informácií pozri <a href="'.SITE_ROOT.'wiki/Seminar/FAQ#AkoSaPrihlasim">FAQ</a>.');
			return false;
		}
		
		try {
			//volat prepare
			foreach ($this->subpages_classes as $key=>$item)
				if (!$item->prepare()) throw new PrepareException($key); //tu nam netreba hadzat Exception ked sa nieco pokazi

			//volat login
			foreach ($this->subpages_classes as $key=>$item)
				if (!$item->createSession($name,$values)) throw new LoginException($key);   //tu zavolame Exception a spravime rollback pre vsetkych (radsej ako iba pre doteraz zalogovanych)

			//volat commit
			foreach ($this->subpages_classes as $key=>$item)
				if (!$item->commit()) throw new CommitException($key);      //tu ked sa nieco pokazi, tak amen. Doteraz prihlasenych odhlasime a zvysnym dame rollBack, vratane tohoto nestastnika

			//nastavit session
			$_SESSION['SessionManager']['login']=$name;
			$_SESSION['SessionManager']['properties']=$values;    //hodnoty z auth kniznice
			return $name;
		} catch (PrepareException $e) {
			//volat rollback pre doteraz zavolanych - $e
			$this->addErr('Prepare failed at '.$e->getFile().':'.$e->getLine().' with message '.$e->getMessage());
			unset($_SESSION['SessionManager']);
			foreach ($this->subpages_classes as $key=>$item)
				if ($key == $e) return false;
				else $item->rollBack();
			return false;

		} catch (LoginException $e) {
			//volat rollback pre vsetky podstranky
			$this->addErr('Login failed at '.$e->getFile().':'.$e->getLine().' with message '.$e->getMessage());
			unset($_SESSION['SessionManager']);
			foreach ($this->subpages_classes as $key=>$item)
				$item->rollBack();
			return false;

		} catch (CommitException $e) {
			//zalogovane stranky odlogovat, ostatne rollback
			$this->addErr('Commit failed at '.$e->getFile().':'.$e->getLine().' with message '.$e->getMessage());
			$tmp=false;
			unset($_SESSION['SessionManager']);
			foreach ($this->subpages_classes as $key=>$item){
				if ($e==$key) $tmp=true;    //ak sme prisli na podstranku kde to spadlo, tak vieme, ze predosle boli prihlasene a dalsim treba rollBack 
				if (!$tmp) $item->logout();
				else $item->rollBack();
			}
			return false;

		} catch (Exception $e) {
			//vseobecna vynimka ked netusim co sa stalo
			$this->addErr('Unknown exception in SessionManager. ' . $e);
			unset($_SESSION['SessionManager']);
			foreach ($this->subpages_classes as $key=>$item)
				$item->rollBack();
			return false;
		}

		return false;       //sem by sme sa nemali nikdy dostat
	}

	public function destroySessions(){
		//zavolat logout na vsetky podtriedy
		foreach ($this->subpages_classes as $key=>$item)
			$item->destroySession();

		unset($_SESSION['SessionManager']);
	}

	public function getValue($property){
		if (isset($_SESSION['SessionManager']['properties'][$property])) return $_SESSION['SessionManager']['properties'][$property];
		return null;
	}

	public function getValues(){
		if (isset($_SESSION['SessionManager']['properties'])) return $_SESSION['SessionManager']['properties'];
		return null;
	}

	public function getCurrentUser(){
		if (isset($_SESSION['SessionManager']['login'])) return $_SESSION['SessionManager']['login'];
		return false;
	}

	public function getRequired(){
		return array_keys($this->req);
	}

	public function getOptional(){
		return array_keys($this->opt);
	}

	public function keepSession(){
		try {
			foreach ($this->subpages_classes as $key=>$item)
				$item->keepSession($this->getCurrentUser(), $this->getValues());
		} catch (Exception $e) {

		}
	}
}

?>
