<?php

//opovaz sa niekde z tejto classy vyhodit von Exception. Je to sice osetrene keby sa podarilo a zavola sa vtedy rollback, ale ubyjem ta palicou!

/*

Prihlasenie:
pred prihlasenim zavolam prepare
potom zavolam login
ak sa podari prihlasit, zavolam commit
ak sa nepodari prihlasit, zavolam rollback

Odhlasenie:
len zavolam logout

*/


// nazov classy je Session_$(nazov tvojho adresara kde je podstranka)
require_once 'lib/messages.php';

class Session_news{
	private $db;

	public function __construct(){
		// bud v konstruktore alebo v prepare si vytvor spojenie na DB ak potrebujes. Odporucam prepare, kedze vies hned povedat false
		
		//je to fuj takto natvrdo a neberie to z configu ale to preto, lebo config este includuje settings a tam sa vola funkcia ktora nie je v nasom kontexte
		$DB_DSN='mysql:host=#####;dbname=wordpress';
		$this->db = new PDO($DB_DSN, '@@@@@', '$$$$$');
		$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		$this->db->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);

		$this->db->prepare("set names 'utf8'")->execute();
	}

	public function prepare(){
		try{
			$this->db->beginTransaction();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function rollback(){
		//navratova hodnota ma nezaujima, tu si mas len upratat, lebo sa nieco pokazilo
		try{
			$this->db->rollBack();
			$this->destroySession();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	public function commit(){
		try{
			$this->db->commit();
			return true;
		} catch (Exception $e) {
			return false;
		}
	}

	private function hash($data, $scheme='auth'){
		//opat nadratovane hodnoty, lebo wp-config ... viz. comment hore
		$auth_key='c<UlMAaDLl-Pxm<_/is5a=Du#*T%?;jj3BhMH[ylQqg3Skbtsg3tS\\nz|3sBN|]L';
		$logged_in_key='RzQu+AI8NG1Kpm=S|\" L}{.%ihx%Ljo0d5^TSCMo$m%j]!lcR\"T{ZIv;OEyORN\\G';

		if ($scheme=='auth'){
			$st = $this->db->prepare("SELECT option_value FROM wp_options WHERE option_name='auth_salt'");
			$st->execute();
			$salt = $st->fetch();
			return hash_hmac('md5', $data, $auth_key . $salt['option_value']);
		} else {
			$st = $this->db->prepare("SELECT option_value FROM wp_options WHERE option_name='logged_in_salt'");
			$st->execute();
			$salt = $st->fetch();
			return hash_hmac('md5', $data, $logged_in_key . $salt['option_value']);
		}
	}

	private function getSiteUrl(){
		$st = $this->db->prepare("SELECT option_value FROM wp_options WHERE option_name='siteurl'");
		$st->execute();
		$salt = $st->fetch();
		return $salt['option_value'];
	}

	public function keepSession($name, $properties){
		$cookie_name = 'wordpress_'.md5($this->getSiteUrl());
		$cookie_name2 = 'wordpress_logged_in_'.md5($this->getSiteUrl());
		$expiration = time() + SESSION_LIFE_TIME;

		if (isset($_COOKIE[$cookie_name]) && $name){
			$key = $this->hash($name . '|' . $expiration);
			$hash = hash_hmac('md5', $name . '|' . $expiration, $key);
			$cookie = $name . '|' . $expiration . '|' . $hash;
			$cookie_name = 'wordpress_'.md5($this->getSiteUrl());

			$_COOKIE[$cookie_name]=$cookie; setcookie($cookie_name,$cookie,$expiration,'/');
		}
		if (isset($_COOKIE[$cookie_name2]) && $name){
			$key2 = $this->hash($name . '|' . $expiration, 'login');
			$hash2 = hash_hmac('md5', $name . '|' . $expiration, $key2);
			$cookie2 = $name . '|' . $expiration . '|' . $hash2;
			$cookie_name2 = 'wordpress_logged_in_'.md5($this->getSiteUrl());

			$_COOKIE[$cookie_name2]=$cookie2; setcookie($cookie_name2,$cookie2,$expiration,'/');
		}
	}
	
	public function createSession($name, $properties){
		try{
			$uid = $this->updateProperties($name, $properties);

			$expiration = time() + SESSION_LIFE_TIME;	//nemozem pouzit nas lifetime lebo hento je unho zadratovane a voci tomu to kontroluje, iked w8

			$key = $this->hash($name . '|' . $expiration);
			$hash = hash_hmac('md5', $name . '|' . $expiration, $key);
			$cookie = $name . '|' . $expiration . '|' . $hash;
			$cookie_name = 'wordpress_'.md5($this->getSiteUrl());

			$key2 = $this->hash($name . '|' . $expiration, 'login');
			$hash2 = hash_hmac('md5', $name . '|' . $expiration, $key2);
			$cookie2 = $name . '|' . $expiration . '|' . $hash2;
			$cookie_name2 = 'wordpress_logged_in_'.md5($this->getSiteUrl());

			$_COOKIE[$cookie_name]=$cookie; setcookie($cookie_name,$cookie,$expiration,'/');
			$_COOKIE[$cookie_name2]=$cookie2; setcookie($cookie_name2,$cookie2,$expiration,'/');

			return true;
		} catch (Exception $e) {
			$msg=new Messages();
			$msg->addErr('News login exception: ' . $e->getMessage() . ' '. $e->getTraceAsString() . ' ' .  $e->getLine());
			return false;
		}
	}

	public function destroySession(){
		//v podstate logout z podstranky
		try{
			foreach ($_COOKIE as $key => $item){
				if (strpos($key,'wordpress')!==false){
					setcookie($key,'',time()-3600,'/');
					unset($_COOKIE[$key]);
				}
			}
			return true;
		} catch (Exception $e) {
			//return false;	//na navratovu hodnotu tejto funkcie nie som zvedavy, iked mozno sa to casom zmeni. Zatial neviem co robit v pripade false
		}
	}

	//vrat pole s hodnotami, ktore potrebujes
	//zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
	public function getRequired(){
		return array();
	}

	//vrat pole s hodnotami, ktore chces ale prezijes ked nebudu
	//zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
	public function getOptional(){
		return array('nickname', 'email');
	}

	private function getUIDByName($name){
		//vrati uid uzivatela z DB, ked tam nie je, updateProperties vytvoria nove konto, inak len updatnu hodnoty
		$st=$this->db->prepare('SELECT ID FROM wp_users WHERE user_login=:name');	//patrilo by sa spravit tabulku s mapovanim login->uid ale ked je to taky "zbytocny" field :)
		$st->bindValue(':name',$name,PDO::PARAM_STR);
		$st->execute();
		$data = $st->fetch();
		if ($data) return $data['ID'];
		else return false;
	}

	private function updateProperties($name, $properties){
		//nastavime vlastnosti ktore sme dostali z prihlasenia
		$id = $this->getUIDByName($name);

		$substitute=array();
		if ($id){
			$sql="UPDATE wp_users SET display_name=:display_name, user_nicename=:user_nicename";
		} else {
			$sql="INSERT INTO wp_users SET
				user_login=:user_login,
				display_name=:display_name,
				user_nicename=:user_nicename,
				user_pass='',
				user_url='http://',
				user_registered=:time,
				user_activation_key=''";
			$substitute[] = array('k'=>':user_login', 'v'=>$name, PDO::PARAM_STR);
			$substitute[] = array('k'=>':time', 'v'=>date('Y-m-d H:i:s'), PDO::PARAM_STR);
		}

		if (isset($properties['nickname']))
			$nick = $properties['nickname'];
		else
			$nick = $name;
		$substitute[] = array('k'=>':display_name', 'v'=>$nick, PDO::PARAM_STR);
		$substitute[] = array('k'=>':user_nicename', 'v'=>$nick, PDO::PARAM_STR);

		if (isset($properties['email'])){
			$sql.=', user_email=:user_email';
			$substitute[] = array('k'=>':user_email', 'v'=>$properties['email'], PDO::PARAM_STR);
		}

		if ($id){
			$sql.=' WHERE id=:id';
			$substitute[] = array('k'=>':id', 'v'=>$id, PDO::PARAM_STR);
		}

		$st=$this->db->prepare($sql);
		foreach ($substitute as $key=>$item){
			$st->bindValue($item['k'], $item['v'], $item['t']);
		}
		$st->execute();

		if (!$id) {
			$id=$this->db->lastInsertId();
			$st = $this->db->prepare("INSERT INTO wp_usermeta SET user_id=:id, meta_key='wp_capabilities', meta_value=:meta_value");
			$st->bindValue(':id', $id, PDO::PARAM_INT);
			$st->bindValue(':meta_value', serialize(array('subscriber'=>true)), PDO::PARAM_INT);
			$st->execute();
		}

		return $id;
	}
}

?>
