<?php
/*
Plugin Name: MyCaptcha
Plugin URI: http://wordpress.org/extend/plugins/mycaptcha
Description: This is just a plugin, to manage Captchas for comments
Author: Andre Renaut
Version: 2.5.0.2
Author URI: http://www.nogent94.fr/MyCaptcha
*/

class MyCaptcha
{
	function MyCaptcha()
	{
		$this->ver = 2.502;

		define ("MyCaptcha_PLUGIN_FOLDER", 	basename(dirname(__FILE__)));

		define ("MyCaptcha_PATH", 	'wp-content/plugins/' . MyCaptcha_PLUGIN_FOLDER);
		load_plugin_textdomain('MyCaptcha',MyCaptcha_PATH . '/lang');
			
		switch (true)
		{
			case (!get_option('MyCaptcha_ver')):
				$this->set_up(true);
			break;
			case ($this->ver > get_option('MyCaptcha_ver')):
				$this->set_up(false);
			break;
		}
		add_filter('preprocess_comment', array( &$this, 'comment_post') );    // add post comment post security code check
		add_action('admin_menu', array(&$this, 'admin_menu'));
	}

	function initialize()
	{
		$styles = get_option('MyCaptcha_styles');
		$style  = get_option('MyCaptcha_style');
		if ($style == 'random') $style = $styles[array_rand($styles)];

		if (session_id() == "") session_start();
		$_SESSION['style']	= $style;
		$_SESSION['cryptdir']	= "/wp-content/plugins/" . MyCaptcha_PLUGIN_FOLDER . "/php/crypt";
		$_SESSION['configfile']	= "cfg/" . $_SESSION['style'] . "/cryptographp.cfg.php";
	}
//	
// Cryptogtaphp 
//
	function dsp_crypt($cfg=0,$reload=1) 
	{
		if(session_id() == "") session_start();
		$url = $_SESSION['cryptdir'] . "/cryptographp.php?cfg=" . $cfg . "&" . SID;
		return  get_settings('siteurl') . $url;
	}

	function chk_crypt($code) 
	{
		if (session_id() == "") session_start();

		include ('php/crypt/' . $_SESSION['configfile']);

		$code = addslashes ($code);
		$code = str_replace(' ','',$code);  			// supprime les espaces saisis par erreur.
		$code = ($difuplow) ? $code : strtoupper($code);

		switch (strtoupper($cryptsecure)) 
		{    
			case "MD5"  : 
				$code = md5($code); 
			break;
		        case "SHA1" : 
				$code = sha1($code); 
			break;
		}

		if ($_SESSION['cryptcode'] and ($_SESSION['cryptcode'] == $code))
		{
			unset($_SESSION['cryptreload']);
			if ($cryptoneuse) unset($_SESSION['cryptcode']); 	   
			return true;
		}
		else 
		{
			$_SESSION['cryptreload']= true;
			return false;
		}
	}	
//	
// Plugin 
//
	function comment_form()
	{
		$a = $this->dsp_crypt(0,0);
		$text = "<img src='" . $a . "'/>";
		echo $text;
	}
//	
// Plugin 
//
	function comment_post($incoming_comment)
	{
		if (is_user_logged_in()) return $incoming_comment;

		if (session_id() == "") session_start();

		global $_POST;
		
		if ($this->chk_crypt($_POST['securitycode'])) 
		{
			return $incoming_comment;
		} 
		else 
		{
			wp_die( __('Error: Wrong anti-spam word.','MyCaptcha') );
		}
	}
//
// Plugin Option Page
//
	function admin_menu()
	{
		if (function_exists('add_options_page')) 
		{
			add_options_page(__('MyCaptcha Settings','MyCaptcha'), 'MyCaptcha', 8, MyCaptcha_PLUGIN_FOLDER . "/php/settings.php");
		}
	}
//
// Plugin set_up or higher versioning
//
	function set_up($bool)
	{
		$dir = "../wp-content/plugins/" . MyCaptcha_PLUGIN_FOLDER . "/php/crypt/cfg/";

		$styles 		= array();
		$style_ko 		= true;
		$style_default_ko = true;

		if ($bool)
		{
			add_option ('MyCaptcha_style','default','MyCaptcha - your captcha style');
		}

		$style = get_settings('MyCaptcha_style');
		if ($style == 'random') $style_ko 		= false;

		//recherche de tous les styles dans le repertoire crypt/cfg
		if (is_dir($dir)) 
		{
    			if ($dh = opendir($dir)) 
			{
				$i = 0;
       			while (($file = readdir($dh)) !== false) 
				{
            			switch (true)
					{
						case ($file  == '.') :
						break;
						case ($file  == '..') :
						break;
						case (filetype($dir . $file) == 'dir') :
							$styles [$i] = $file;
							$i++;
							if ($file == $style) 	$style_ko 		= false;
							if ($file == 'default') $style_default_ko = false;
						break;
					}
        			}
       		 	closedir($dh);
    			}
		}

		if ($style_ko)
		{
			if ($style_default_ko)
			{
				update_option ('MyCaptcha_style',$styles[0]);
			}
			else
			{
				if (!$bool)
				{
					update_option ('MyCaptcha_style','default');
				}
			}
		}

		if ($bool)
		{
			add_option ('MyCaptcha_styles',$styles,'MyCaptcha - styles available','yes');
			add_option ('MyCaptcha_ver',$this->ver,'MyCaptcha - version','yes');
		}
		else
		{
			update_option ('MyCaptcha_styles',$styles);
			update_option ('MyCaptcha_ver',$this->ver);
		}
	}

}

$MyCaptcha = new MyCaptcha();

?>