<?php

// -----------------------------------------------
// Cryptographp v1.4
// (c) 2006-2007 Sylvain BRISON 
//
// www.cryptographp.com 
// cryptographp@alphpa.com 
//
// Licence CeCILL modifie
// => Voir fichier Licence_CeCILL_V2-fr.txt)
// -----------------------------------------------


// -------------------------------------
// Configuration du fond du cryptogramme
// -------------------------------------

$cryptwidth  = 170;  // Largeur du cryptogramme (en pixels)
$cryptheight = 50;   // Hauteur du cryptogramme (en pixels)

$bgR  = 255;         // Couleur du fond au format RGB: Red (0->255)
$bgG  = 255;         // Couleur du fond au format RGB: Green (0->255)
$bgB  = 255;         // Couleur du fond au format RGB: Blue (0->255)

$bgclear = true;     // Fond transparent (true/false)
                     // Uniquement valable pour le format PNG

$bgimg = 'fonds';                 // Le fond du cryptogramme peut-tre une image  
                             // PNG, GIF ou JPG. Indiquer le fichier image
                             // Exemple: $fondimage = 'photo.gif';
				                     // L'image sera redimensionne si ncessaire
                             // pour tenir dans le cryptogramme.
                             // Si vous indiquez un rpertoire plutt qu'un 
                             // fichier l'image sera prise au hasard parmi 
                             // celles disponibles dans le rpertoire

$bgframe = false;    // Ajoute un cadre de l'image (true/false)


// ----------------------------
// Configuration des caractres
// ----------------------------

// Couleur de base des caractres

$charR = 0;     // Couleur des caractres au format RGB: Red (0->255)
$charG = 0;     // Couleur des caractres au format RGB: Green (0->255)
$charB = 0;     // Couleur des caractres au format RGB: Blue (0->255)

$charcolorrnd = false;      // Choix alatoire de la couleur.
$charcolorrndlevel = 1;    // Niveau de clart des caractres si choix alatoire (0->4)
                           // 0: Aucune slection
                           // 1: Couleurs trs sombres (surtout pour les fonds clairs)
                           // 2: Couleurs sombres
                           // 3: Couleurs claires
                           // 4: Couleurs trs claires (surtout pour fonds sombres)

$charclear = 80;   // Intensit de la transparence des caractres (0->127)
                  // 0=opaques; 127=invisibles
	                // interessant si vous utilisez une image $bgimg
	                // Uniquement si PHP >=3.2.1

// Polices de caractres


$tfont[] = 'SCRAWL.TTF';  
 



// Caracteres autoriss
// Attention, certaines polices ne distinguent pas (ou difficilement) les majuscules 
// et les minuscules. Certains caractres sont faciles  confondre, il est donc
// conseill de bien choisir les caractres utiliss.

$charel = 'ABCDEFGHKLMNPRTWXYZ3569';       // Caractres autoriss

$crypteasy = false;       // Cration de cryptogrammes "faciles  lire" (true/false)
                         // composs alternativement de consonnes et de voyelles.

$charelc = 'BCDFGHKLMNPRTWXZ';   // Consonnes utilises si $crypteasy = true
$charelv = 'AY';                 // Voyelles utilises si $crypteasy = true

$difuplow = false;          // Diffrencie les Maj/Min lors de la saisie du code (true, false)

$charnbmin = 4;         // Nb minimum de caracteres dans le cryptogramme
$charnbmax = 5;         // Nb maximum de caracteres dans le cryptogramme

$charspace = 25;        // Espace entre les caracteres (en pixels)
$charsizemin = 25;      // Taille minimum des caractres
$charsizemax = 25;      // Taille maximum des caractres

$charanglemax  = 25;     // Angle maximum de rotation des caracteres (0-360)
$charup   = false;        // Dplacement vertical alatoire des caractres (true/false)

// Effets supplmentaires

$cryptgaussianblur = false; // Transforme l'image finale en brouillant: mthode Gauss (true/false)
                            // uniquement si PHP >= 5.0.0
$cryptgrayscal = false;     // Transforme l'image finale en dgrad de gris (true/false)
                            // uniquement si PHP >= 5.0.0

// ----------------------
// Configuration du bruit
// ----------------------

$noisepxmin = 0;      // Bruit: Nb minimum de pixels alatoires
$noisepxmax = 0;      // Bruit: Nb maximum de pixels alatoires

$noiselinemin = 0;     // Bruit: Nb minimum de lignes alatoires
$noiselinemax = 0;     // Bruit: Nb maximum de lignes alatoires

$nbcirclemin = 0;      // Bruit: Nb minimum de cercles alatoires 
$nbcirclemax = 0;      // Bruit: Nb maximim de cercles alatoires

$noisecolorchar  = 2;  // Bruit: Couleur d'ecriture des pixels, lignes, cercles: 
                       // 1: Couleur d'criture des caractres
                       // 2: Couleur du fond
                       // 3: Couleur alatoire
                       
$brushsize = 1;        // Taille d'ecriture du princeaiu (en pixels) 
                       // de 1  25 (les valeurs plus importantes peuvent provoquer un 
                       // Internal Server Error sur certaines versions de PHP/GD)
                       // Ne fonctionne pas sur les anciennes configurations PHP/GD

$noiseup = false;      // Le bruit est-il par dessus l'ecriture (true) ou en dessous (false) 

// --------------------------------
// Configuration systme & scurit
// --------------------------------

$cryptformat = "png";   // Format du fichier image gnr "GIF", "PNG" ou "JPG"
				                // Si vous souhaitez un fond transparent, utilisez "PNG" (et non "GIF")
				                // Attention certaines versions de la bibliotheque GD ne gerent pas GIF !!!

$cryptsecure = "md5";    // Mthode de crytpage utilise: "md5", "sha1" ou "" (aucune)
                         // "sha1" seulement si PHP>=4.2.0
                         // Si aucune mthode n'est indique, le code du cyptogramme est stock 
                         // en clair dans la session.
                       
$cryptusetimer = 0;        // Temps (en seconde) avant d'avoir le droit de regnrer un cryptogramme

$cryptusertimererror = 3;  // Action  raliser si le temps minimum n'est pas respect:
                           // 1: Ne rien faire, ne pas renvoyer d'image.
                           // 2: L'image renvoye est "images/erreur2.png" (vous pouvez la modifier)
                           // 3: Le script se met en pause le temps correspondant (attention au timeout
                           //    par dfaut qui coupe les scripts PHP au bout de 30 secondes)
                           //    voir la variable "max_execution_time" de votre configuration PHP

$cryptusemax = 1000;  // Nb maximum de fois que l'utilisateur peut gnrer le cryptogramme
                      // Si dpassement, l'image renvoye est "images/erreur1.png"
                      // PS: Par dfaut, la dure d'une session PHP est de 180 mn, sauf si 
                      // l'hebergeur ou le dveloppeur du site en ont dcid autrement... 
                      // Cette limite est effective pour toute la dure de la session. 
                      
$cryptoneuse = false;  // Si vous souhaitez que la page de verification ne valide qu'une seule 
                       // fois la saisie en cas de rechargement de la page indiquer "true".
                       // Sinon, le rechargement de la page confirmera toujours la saisie.                          
                      
?>
