<?php if ( !empty($post->post_password) && $_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) : ?>
<p><?php _e('Enter your password to view comments.'); ?></p>
<?php return; endif; ?>
<hr/>

<p class="alignright"><?php post_comments_feed_link(__('<img src="'.get_bloginfo("template_directory").'/rss.png" alt="RSS feed for comments on this post." />')); ?>
<?php if ( pings_open() ) : ?>
	<a href="<?php trackback_url() ?>" rel="trackback"><?php _e('TrackBack <abbr title="Universal Resource Locator">URL</abbr>'); ?></a>
<?php endif; ?>
</p>

<h5 id="comments">
<a href="#postcomment" title="<?php _e("Leave a comment"); ?>">
<?php comments_number(__('No Comments'), __('1 Comment'), __('% Comments')); ?>
<?php if ( comments_open() ) : ?>
	</a>
<?php endif; ?>
</h5>

<?php if ( $comments ) : ?>
<ol id="commentlist">

<?php foreach ($comments as $comment) : ?>
	<li id="comment-<?php comment_ID() ?>">
	<?php echo get_avatar( $comment, 32 ); ?>
	<h5>
		<?php comment_type(__('Comment'), __('Trackback'), __('Pingback')); ?>
		<?php _e('by'); ?> <?php comment_author_link() ?> (<?php comment_author_IP() ?>) &#8212;
		<?php comment_date() ?> @ <a href="#comment-<?php comment_ID() ?>">
		<?php comment_time() ?></a></cite>
		<?php edit_comment_link(__("Edit This"), ' |'); ?>
	</h5>
	<?php comment_text() ?>
	</li>

<?php endforeach; ?>

</ol>

<?php else : // If there are no comments yet ?>
	<p><?php _e('No comments yet.'); ?></p>
<?php endif; ?>

<?php if ( comments_open() ) : ?>
<hr/>

<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
<p><?php
//printf(__('You must be <a href="%s">logged in</a> to post a comment.'), get_option('siteurl')."/wp-login.php?redirect_to=".urlencode(get_permalink()));
printf(__('Ak chceš poslať komentár, prihlás sa.'));
?></p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( $user_ID ) : ?>

<p><?php printf(__('Logged in as %s.'), $user_identity); ?></p>

<?php else : ?>

<?php
	if (class_exists('MyCaptcha')) 
	{
		global $MyCaptcha;
		$MyCaptcha->initialize();
?>
<p>
		Vlož kód z obrázku:<br/>
		<?php $MyCaptcha->comment_form(); ?><br/>
		<input type="text" name="securitycode" id="securitycode" size="30" />
</p>
<?php
	}
?>

<?php endif; ?>
<p>
<small><strong>XHTML:</strong> <?php printf(__('You can use these tags: %s'), allowed_tags()); ?></small>

<textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"></textarea></p>

<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php echo attribute_escape(__('Submit Comment')); ?>" />
<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>

<?php endif; // If registration required and not logged in ?>

<?php else : // Comments are closed ?>
<p><?php _e('Sorry, the comment form is closed at this time.'); ?></p>
<?php endif; ?>
