<?php

//http://sk.php.net/pdo

//pociatocne vytvorenie a inicializacia
define('DB_DSN','mysql:host=localhost;dbname=test');	//tu sa da povedat, ze chceme pouzit iny ovladac, napr. sqlite, viz. http://sk.php.net/manual/en/pdo.getavailabledrivers.php
$db = new PDO(DB_DSN, DB_USER, DB_PASS);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$db->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);

//v akom kodovani chceme pracovat s DB. U kaspara si nie som vobec isty, treba pozriet
$db->prepare("set names 'utf8'")->execute();

//priklad selectu :)
$st = $db->prepare('SELECT p.podujatieID, p.datum, p.nazov, p.kratkypopis, o.filename
	FROM podujatie p
	LEFT JOIN obrazok o
	ON o.fotoalbumID=p.fotoalbumID
	WHERE datum>:d
	GROUP BY p.podujatieID
	ORDER BY datum ASC
	LIMIT :l');
//toto je zaujimave - priradenie hodnot premennym co su v selecte a udanie typu
//uz sa netreba starat o SQL injection

$st->bindValue(':d', date($sql_date_format), PDO::PARAM_STR);
$st->bindValue(':l', $pocet_buducich_podujati, PDO::PARAM_INT);

//ak chceme vlozit NULL, tak je na to specialny typ (zial)
$st->bindValue(':text', NULL, PDO::PARAM_NULL);

//vykonanie dotazu a kontrola na vysledok. Ak bude nieco v neporiadku, tak
//nam PDO vyhodi exception a povie v nej co je zle - viz. hodne nastavenia, ze ma hadzat exception
if ($st->execute()) throw new Exception('Dotaz nepresiel');

//vysledok budeme dostavat ako mapu array('nazov_stlpca'=>hodnota, ...)
$st->setFetchMode(PDO::FETCH_ASSOC);

//dolovanie dat, moznost c.1
while ($data = $st->fetch()) echo $data;

//dolovanie dat, moznost c.2
var_dump($st->fetchAll());

//ziskanie ID posledne vlozeneho zaznamu
$lastid = $db->lastInsertId();




//Priklad pouzitia transakcii, toto sa patri pouzivat ak je potrebnych viac modifikacii (insert, update, delete) databazy pre nejaku akciu

try{
	$db->beginTransaction();
	
	$st = $db->prepare('SELECT nadpis FROM rubrika WHERE rubrikaID = :id LIMIT 1');
	$st->bindValue(':id', $edit, PDO::PARAM_INT);
	$st->execute();
	$st->setFetchMode(PDO::FETCH_ASSOC);
	if (!($rubrika = $st->fetch()))
		throw new Exception('Záznam, ktorý sa pokúšate zmeniť, neexistuje.');

	$st = $db->prepare('DELETE FROM clanok WHERE rubrikaID = :id');
	$st->bindValue(':id', $deletedelete, PDO::PARAM_INT);
	$st->execute();


	if ($save == 'new') {
		$st = $db->prepare('INSERT INTO clanok SET datum = NOW(), text = :text, nadpis = :nadpis, rubrikaID = :rubrika');
		$st->bindValue(':rubrika', $rubrika, PDO::PARAM_INT);
	} else {
		$save = (int)$save;
		$st = $db->prepare('UPDATE clanok SET text = :text, nadpis = :nadpis WHERE clanokID = :save LIMIT 1');
		$st->bindValue(':save', $save, PDO::PARAM_INT);
	}
	$st->bindValue(':text', $_POST['e_text'], PDO::PARAM_STR);
	$st->bindValue(':nadpis', $_POST['e_nadpis'], PDO::PARAM_STR);
	$st->execute();

	//ak niektory select hodil exception, tak sa spravi rollback, inak sa dojde az sem a spravime commit()

	$db->commit();
} catch (Exception $e) {

	//rollback
	$db->rollBack();
	$smarty->assign('errormessage', $e->getMessage());
}

//PDO ma aj dalsie funkcie hlavne okolo priradenia parametrov, ale to uz najdes v dokumentacii, nie je to super dolezite, len mozno trochu sikovne v niektorych pripadoch. Funkcie bindValue, bindParam, bindColumn

?>
