<?php

//--------------------------------INCLUDES-------------------------------

include_once "../lib/init.php";
require_once "../lib/kaspar.php";
require_once "../lib/sessions.php";
//--------------------------------HEADER---------------------------------

$kaspar = Kaspar::getInstance();

$GLOBALS['ksp_smarty']->template_dir = 'templates/';
$GLOBALS['ksp_smarty']->assign('css',array('css/style.css'));
$GLOBALS['ksp_smarty']->display('header.tpl');
$GLOBALS['ksp_smarty']->template_dir = 'vysledky/templates/';

//--------------------------------GET PARAMETERS-------------------------

if (isset($_GET['contest_id'])) $contest_id=$_GET['contest_id'];
if (isset($_GET['rounds'])) $rounds=$_GET['rounds'];
if (isset($_GET['category'])) $category=$_GET['category'];

if(! isset($contest_id))//TODO
	die("Nezadal si id sutaze (contest_id).");

if (!isset($category)) $category='';

// prejdeme a skontrolujeme cisla kol
if(! isset($rounds))
	die("Nezadal si ziadne kola.");

$round  = strtok($rounds,",");
$rounds_array = array();
$lastround=-1;
while($round)
{
	$rounds_array[] = $round;
	$lastround=$round;
	$round =  strtok(",");
}
$rounds=$rounds_array;

if($category=='z'){
    $startnum=1;
    $endnum=5;
    $minnum=3;
}elseif($category=='o'){
    $startnum=4;
    $endnum=8;
    $minnum=7;
}elseif($category=='t'){
    $startnum=8;
    $endnum=10;
    $minnum=10;
}else{
    $startnum=1;
    $endnum=$kaspar->getMaxTask($contest_id,$lastround);
    $minnum=$endnum;
}

//--------------------------------RESULTS--------------------------------

$num=sizeof($rounds);
$cnt=0;
$titlerounds=" ";
foreach($rounds as $round){
    $titlerounds.=$kaspar->getContestRoundname($contest_id,$round);
    $cnt++;
    if($cnt+1<$num){
	$titlerounds.=", ";
    }elseif($cnt<$num){
	$titlerounds.=" a ";
    }
}

$results=$kaspar->getResults($contest_id,$rounds,$startnum,$endnum,$minnum);
$GLOBALS['ksp_smarty']->assign('result',$results);
$GLOBALS['ksp_smarty']->assign('title',$kaspar->getContestName($contest_id));
$GLOBALS['ksp_smarty']->assign('titlerounds',$titlerounds);
$GLOBALS['ksp_smarty']->assign('startnum',$startnum);
$GLOBALS['ksp_smarty']->assign('endnum',$endnum);
$GLOBALS['ksp_smarty']->display('result.tpl');




//--------------------------------FOOTER---------------------------------

$GLOBALS['ksp_smarty']->template_dir = 'templates/';
$GLOBALS['ksp_smarty']->display('footer.tpl');




?>
