<?php

//opovaz sa niekde z tejto classy vyhodit von Exception. Je to sice osetrene keby sa podarilo a zavola sa vtedy rollback, ale ubyjem ta palicou!

/*

Prihlasenie:
pred prihlasenim zavolam prepare
potom zavolam login
ak sa podari prihlasit, zavolam commit
ak sa nepodari prihlasit, zavolam rollback

Odhlasenie:
len zavolam logout

*/


// nazov classy je Session_$(nazov tvojho adresara kde je podstranka)
class Session_wiki{

    public function __construct(){
    // bud v konstruktore alebo v prepare si vytvor spojenie na DB ak potrebujes. Odporucam prepare, kedze vies hned povedat false
    }

    public function prepare(){
	try{
	    //$db->prepare();
		return true;
	} catch (Exception $e) {
		return false;
	}
    }
    
    public function rollback(){
	//navratova hodnota ma nezaujima, tu si mas len upratat, lebo sa nieco pokazilo
	try{
		//$db->rollBack();
		$this->destroySession();
		return true;
	} catch (Exception $e) {
		return false;
	}
    }
    
    public function commit(){
	try{
		//$db->commit();
		return true;
	} catch (Exception $e) {
		return false;
	}
    }

    public function keepSession($name, $properties){
	    return true;
    }
    
    public function createSession($name, $properties){
	//ked prebehne autentifikacia (login) -> vytvor session na podstranke. Ak user nema konto, tak vytvor. Keby existoval user s takym nick-om, tak pokojne vrat false. Toto nejak vyriesime este
	//$name - login (napr. OpenID)
	//$properties - mapa hodnot ktore som z autentifikacneho modulu (napr. OpenID) dostal
	try{
		$_SESSION['pmWikiLogin']=$name;
		return true;
	} catch (Exception $e) {
		return false;
	}
    }
    
    public function destroySession(){
	//v podstate logout z podstranky
	try{
		unset($_SESSION['authid']);
		unset($_SESSION['authlist']);
		unset($_SESSION['authpw']);
		unset($_SESSION['pmWikiLogin']);
		return true;
	} catch (Exception $e) {
		//return false;	//na navratovu hodnotu tejto funkcie nie som zvedavy, iked mozno sa to casom zmeni. Zatial neviem co robit v pripade false
	}
    }
    
    //vrat pole s hodnotami, ktore potrebujes
    //zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
    public function getRequired(){
	return array();
    }

    //vrat pole s hodnotami, ktore chces ale prezijes ked nebudu
    //zoznam 'znamych' hodnot treba pozriet v OpenID dokumentacii
    public function getOptional(){
	return array();
    }
    
}

?>
