<?php
	class GeneralComponent extends Object {
	    static private $allowed = 'abcdefghijklmnopqrstuvwxyz1234567890-';
		static private $from	= array('ľ','ĺ','š','č','ť','ď','ž','ý','á','ä','í','é','ě','ř','ú','ň','ô','ó','ö', 'ü' ,'Á','Ä','Č','Ď','É','Ě','Í','Ľ','Ĺ','Ň','Ó','Ö' ,'Ő','Ô','Ř','Ŕ','Š','Ť','Ú','Ů','Ü','Ű','Ý','Ž');
	    static private $to		= array('l','l','s','c','t','d','z','y','a','a','i','e','e','r','u','n','o','o','oe','ue','a','a','c','d','e','e','i','l','l','n','o','oe','o','o','r','r','s','t','u','u','u','u','y','z');
		
		public function niceUrl($str, $with_spaces = false) {
			$str = strtolower(str_replace(self::$from, self::$to, $str));
			if ($with_spaces === false) {
				$str = strtr($str, ' ', '-');
			}
			$str = self::onlyAllowedCharacters($str);
			return self::oneDelimiter($str);
		}
		
		static private function oneDelimiter($r) {
			$n = str_replace('--','-',$r);
			return ($n == $r) ? trim($n, '-') : self::oneDelimiter($n);
		}
		
		static private function onlyAllowedCharacters($str) {
			$new_str = '';
			$len = strlen($str);
			for ($i = 0; $i < $len; $i++) {
				if (strpos(self::$allowed, $str{$i}) !== false) {
					$new_str .= $str{$i};
				}
			}
			return $new_str;
		}
	}
?>