<?php
	class CategoriesController extends EshopAppController {
		var $helpers = array('Javascript', 'Core.Tree', 'Core.Toolbar');
		var $components = array('Auth', 'Auth', 'Core.General');
		var $uses = array('Eshop.Category', 'Eshop.Product', 'Eshop.ProductCategory');
		
		function beforeFilter() {
			parent::beforeFilter();
			$this->Auth->loginAction = array('plugin' => 'auth', 'controller' => 'users', 'action' => 'login');
		}
		public function index() {
			$this->show();
			$this->render('show');
		}

		public function show($alias = '') {
			$this->pageTitle = __('categories', true);
			$category = $this->Category->findByUrl($alias);
			if (!empty($this->data)) {
				$toSave = array();
				foreach ($this->data['ProductCategory'] as $categoryProduct) {
					if (!empty($categoryProduct['product_id'])) {
						$toSave[] = array('product_id' => $categoryProduct['product_id'], 'category_id' => $category['Category']['category_id']);
					}
				}
				$this->ProductCategory->deleteAll(array('category_id' => $category['Category']['category_id']));
				$this->ProductCategory->saveAll($toSave);
			}
			$this->set('category', $category);
			$products = $this->ProductCategory->findAllByCategoryId($category['Category']['category_id']);
			$productsIds = array();
			foreach ($products as $product) {
				$productsIds[] = $product['ProductCategory']['product_id'];
			}
			$this->set('categoryProducts', $productsIds);
			$this->set('categories', Set::extract($this->Category->children(), '{n}.Category'));
			$this->Product->recursive = 1;
			$this->Product->unbindModel(array('hasMany' => array('ProductCategory', 'ProductAttribute'), 'hasAndBelongsToMany' => array('Category', 'Attribute')));
			$this->set('products', $this->Product->findAll());
		}
		
		public function add($alias = '') {
			$this->pageTitle = __('add category', true);
			if (!empty($this->data)) {
				$categories = array('Category' => array());
				foreach ($this->data['Category']['name'] as $key => $category) {
					$categories['Category'][] = array(
						'name' => trim($this->data['Category']['name'][$key]), 
						'url' => $this->General->niceUrl($this->data['Category']['name'][$key]),
						'parent_id' => $this->General->niceUrl($this->data['Category']['parent_id'][$key]),
					);
				}
				$success = true;
				$notSaved = array('Category' => array());
				foreach ($categories['Category'] as $category) {
					$this->Category->create();
					if (!$this->Category->save($category)) {
						$success = false;
						$notSaved['Category'][] = $category;
					}
				}
				if ($success) {
					$this->Session->setFlash(__('category saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->set('categories', $notSaved);
					$this->Session->setFlash(__('category not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			$this->set('category', $this->Category->findByUrl($alias));
			$this->set('categoriesList', $this->Category->find('list'));
			$this->set('alias', $alias);
//			$this->set('buttons', $this->toolbarButtons);
		}
		
		public function edit($alias = 0) {
			$this->pageTitle = __('edit category', true);
			if (!empty($this->data)) {
				$category = $this->Category->findByUrl($this->data['Category']['url']);
				$this->data['Category']['category_id'] = $category['Category']['category_id'];
				$this->data['Category']['name'] = trim($this->data['Category']['name']);
				$this->data['Category']['url'] = $this->General->niceUrl($this->data['Category']['name']);
				if ($this->Category->save($this->data)) {
					$this->Session->setFlash(__('category saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('category not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			$category = $this->Category->findByUrl($alias);
			$this->set('category', $category);
			$blacklist = Set::extract($this->Category->children($category['Category']['category_id']), '{n}.Category.category_id');
			$blacklist[] = $category['Category']['category_id'];
			$this->set('categoriesList', $this->Category->find('list', array(
				'conditions' => array(
					'NOT' => array('category_id' => $blacklist)
				)
			)));
		}
		
		public function delete($alias = '') {
			if (empty($alias)) {
				$this->Session->setFlash(__('no category seleted', true), 'default', array('class' => 'alert error'));
				$this->redirect($this->referer());
			}
			else {
				$category = $this->Category->findByUrl($alias);
				if ($this->Category->delete($category['Category']['category_id'])) {
					$this->Session->setFlash(__('category deleted', true), 'default', array('class' => 'alert ok'));
				}
				else {
					$this->Session->setFlash(__('category not deleted', true), 'default', array('class' => 'alert error'));
				}
				$this->redirect(array('action' => 'index'));
			}
		}
		
		public function up($url) {
			$category = $this->Category->findByUrl($url);
			if (!empty($category)) {
				$this->Category->moveUp($category['Category']['category_id']);
			}
			$this->redirect($this->referer());
		}
		
		public function down($url) {
			$category = $this->Category->findByUrl($url);
			if (!empty($category)) {
				$this->Category->moveDown($category['Category']['category_id']);
			}
			$this->redirect($this->referer());
		}
		
	}
?>