<?php
	class PhotosController extends EshopAppController {
		var $helpers = array('Core.Tree', 'Core.Toolbar', 'Javascript');
		var $components = array('Auth', 'ImageVersion.ImageVersion');
		var $uses = array('ImageVersion.Photo', 'Eshop.Product', 'Eshop.Attribute', 'Eshop.ProductAttribute');

		public function beforeFilter() {
			parent::beforeFilter();
		}
		
		public function index() {
			$this->Photo->recursive = 1;
			$photos = $this->Photo->findAll();
			$this->Attribute->recursive = 0;
			$this->Attribute->unbindModel(array('belongsTo' => array('AttributesSet')));
			$attributes = Set::classicExtract($this->Attribute->findAll(array('AttributeType.name' => 'image')), '{n}.Attribute.attribute_id');

			$linked = Set::classicExtract($this->ProductAttribute->findAll(array('attribute_id' => $attributes, 'value' => Set::classicExtract($photos, '{n}.Photo.photo_id'))), '{n}.ProductAttribute.value');

			$this->set('linked', $linked);
			$this->set('photos', $photos);
		}
		
		public function add() {
			$this->Session->delete('Message.badFile');
			if (!empty($this->data)) {
				$photoId = $this->ImageVersion->save($this->data['Photo']['file'], $this->data['Photo']['name'], $this->data['Photo']['name'], $this->data['Photo']['crop']);
				if (!empty($photoId)) {
					$this->redirect(array('action' => 'index'));
				}
			}
		}
		
		public function edit($photoId) {
			if (!empty($this->data)) {
				$this->data['Photo']['photo_id'] = $photoId;
				$this->data['Photo']['description'] = $this->data['Photo']['name'];
				if ($this->Photo->save($this->data)) {
					$this->Session->setFlash(__('photo saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('photo not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			$this->set('photo', $this->Photo->findByPhotoId($photoId));
			$this->set('productsList', $this->Product->find('list'));
		}
		
		public function delete($photoId) {
			$this->Photo->remove($photoId);
			$this->unlink($photoId);
//			$this->redirect($this->referer());
		}
		
		public function unlink($photoId) {
			$this->Attribute->recursive = 0;
			$this->Attribute->unbindModel(array('belongsTo' => array('AttributesSet')));
			$attributes = Set::classicExtract($this->Attribute->findAll(array('AttributeType.name' => 'image')), '{n}.Attribute.attribute_id');
			$this->ProductAttribute->deleteAll(array('ProductAttribute.value' => $photoId, 'ProductAttribute.attribute_id' => $attributes));
			$this->redirect($this->referer());
		}
	}
?>