<?php
	class ProductsController extends EshopAppController {
		var $helpers = array('Javascript', 'Core.Toolbar', 'Core.Tree');
		var $components = array('Auth', 'Core.General', 'ImageVersion.ImageVersion');
		var $uses = array('Eshop.Category', 'Eshop.Product', 'Eshop.AttributesSet', 'Eshop.Attribute', 'Eshop.ProductAttribute', 'ImageVersion.Photo', 'Eshop.ProductType', 'Eshop.AttributeType', 'Eshop.ProductCategory', 'Eshop.ConfigAttribute');
		
		public function beforeFilter() {
			parent::beforeFilter();
			$this->Auth->loginAction = array('plugin' => 'auth', 'controller' => 'users', 'action' => 'login');
		}
		
		public function index() {
			$this->pageTitle = __('products', true);
			$this->Product->recursive = 1;
			$this->Product->unbindModel(array('hasMany' => array('ProductCategory', 'ProductAttribute'), 'hasAndBelongsToMany' => array('Category', 'Attribute')));
			$this->set('products', $this->Product->find('all', array(
				'fields' => array('Product.name', 'Product.url', 'AttributesSet.name', 'ProductType.name'),
			)));
			$this->set('attributesSets', $this->AttributesSet->find('list'));
		}

		public function checkUrl($name) {
			$this->layout = 'xml/default';
			$result = $this->Product->findByUrl($this->General->niceUrl($name));
			if (!empty($result)) {
				$this->set('status', 'error');
				$this->set('text', __('already exists', true));
				return false;
			}
			else {
				$this->set('status', 'accept');
				$this->set('text', __('not exists yet', true));
				return true;
			}
		}
		
		public function add($step = 'step1') {
			$this->pageTitle = __('add product', true);
			switch ($step) {
				case 'step1':
					if (!empty($this->data)) {
						$this->data['Product']['name'] = trim($this->data['Product']['name']);
						$this->data['Product']['url'] = $this->General->niceUrl($this->data['Product']['name']);
						$this->Product->set($this->data);
						$errors = $this->Product->invalidFields();
						if (empty($errors)) {
							$this->Session->write('NewProduct.Product', $this->data['Product']);
							/**
							 * @note remove empty categories and write to session
							 */
							$categories = array();
							foreach ($this->data['ProductCategory'] as $category) {
								if (!empty($category['category_id'])) {
									$categories[] = array('category_id' => $category['category_id']); 
								}
							}
							$this->Session->write('NewProduct.ProductCategory', $categories);
							$productType = $this->ProductType->find('first', array('conditions' => array('product_type_id' => $this->Session->read('NewProduct.Product.product_type_id'))));
							if ($productType['ProductType']['name'] == 'configurable product') {
								$this->redirect(array('step2'));
							}
							else {
								$this->redirect(array('step3'));
							}
						}
						else {
							$this->Product->set(array('Product' => $this->data['Product']));
							$this->set('errors', array('Product' => $errors));
							$this->set('product', $this->data);
						}
					}
					$this->Session->delete('NewProduct');
					$this->set('attributesSets', $this->AttributesSet->find('list'));
					$this->set('productTypes', $this->ProductType->find('list'));
					$this->set('categories', $this->Category->generatetreelist());
					$this->render('add_step1');
					break;
				case 'step2':
					if (!empty($this->data)) {
						if (isset($this->data['ConfigAttribute'])) {
							foreach ($this->data['ConfigAttribute'] as $key => $attribute) {
								if (empty($attribute['attribute_id'])) {
									unset($this->data['ConfigAttribute'][$key]);
								}
							}
							$this->Session->write('NewProduct.ConfigAttribute', $this->data['ConfigAttribute']);
						}
						if (empty($this->data['ConfigAttribute'])) {
							$this->Session->setFlash(__('choose at least one option', true), 'default', array('class' => 'alert error'));
						}
						else {
							$this->redirect(array('step3'));
						}
					}
					$productType = $this->ProductType->find('first', array('conditions' => array('product_type_id' => $this->Session->read('NewProduct.Product.product_type_id'))));
					if ($productType['ProductType']['name'] == 'configurable product') {
						$this->Attribute->recursive = 2;
						$whitelist = Set::classicExtract($this->AttributeType->find('all', array(
							'conditions' => array(
								'NOT' => array('type' => array('checkbox', 'date', 'file', 'textarea'))
							)
						)), '{n}.AttributeType.attribute_type_id');
						$attributes = $this->Attribute->find('list', array('conditions' => array('attributes_set_id' => $this->Session->read('NewProduct.Product.attributes_set_id'), 'url <>' => 'price', 'attribute_type_id' => $whitelist)));
						$this->set('attributes', $attributes);
						if (empty($attributes)) {
							$this->Session->setFlash(__('no configurable attibute', true), 'default', array('class' => 'alert error'));
						}
					}
					$this->render('add_step2');
					break;
				case 'step3':
					if (!empty($this->data)) {
						$selectAttributes = $this->Attribute->find('all', array(
							'fields' => array('Attribute.attribute_id'),
							'conditions' => array(
								'Attribute.attributes_set_id' => $this->Session->read('NewProduct.Product.attributes_set_id'),
								'AttributeType.type' => 'select'
							),
							'recursive' => 0
						));
						$selectAttributes = Set::classicExtract($selectAttributes, '{n}.Attribute.attribute_id');
						foreach ($this->data['ProductAttribute'] as $key => $attribute) {
							if (!is_array($this->data['ProductAttribute'][$key]['value'])) {
								$this->data['ProductAttribute'][$key]['value'] = trim($this->data['ProductAttribute'][$key]['value']);
							}
							if (in_array($attribute['attribute_id'], $selectAttributes) && empty($attribute['value'])) {
								unset($this->data['ProductAttribute'][$key]);
							}
						}
						
						$this->Session->write('NewProduct.ProductAttribute', $this->data['ProductAttribute']);
						$productType = $this->ProductType->find('first', array('conditions' => array('product_type_id' => $this->Session->read('NewProduct.Product.product_type_id'))));
						if ($productType['ProductType']['name'] == 'configurable product') {
							$this->redirect(array('step4'));
						}
						else {
							$this->redirect(array('step5'));
						}
					}
					$this->set('configAttribute', Set::extract($this->Session->read('NewProduct.ConfigAttribute'), '{n}.attribute_id'));
					$this->Attribute->recursive = 1;
					$this->set('attributes', $this->Attribute->findAll(array('Attribute.attributes_set_id' => $this->Session->read('NewProduct.Product.attributes_set_id'))));
					$this->render('add_step3');
					break;
				case 'step4':
					if (!empty($this->data)) {
						$notSaved = array();
						foreach ($this->data['ProductAttribute'] as $key => $attributesGroup) {
							$all = true;
							$one = false;
							foreach ($attributesGroup as $attribute) {
								if (empty($attribute)) {
									$one = true;
								}
								else {
									$all = false;
								}
							}
							if ($all) {
								unset($this->data['ProductAttribute'][$key]);
							}
							if ($one) {
								$notSaved[] = $this->data['ProductAttribute'][$key];
							}
						}
						if ($this->Session->check('NewProduct.Configurable') && is_array($this->Session->read('NewProduct.Configurable'))) {
							$this->data['ProductAttribute'] = array_merge($this->Session->read('NewProduct.Configurable'), $this->data['ProductAttribute']);
						}
						$this->Session->write('NewProduct.Configurable', $this->data['ProductAttribute']);
						if (count($notSaved) > 0) {
							$this->set('notSaved', $notSaved);
							$this->Session->setFlash(__('attributes below not saved', true), 'default', array('class' => 'alert error'));
						}
						else {
							$this->redirect(array('step5'));
						}
					}
					$this->Attribute->unbindModel(array('hasMany' => array('ProductAttribute'), 'belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Product')));
					$configAttribute = $this->Attribute->find('all', array(
						'conditions' => array(
							'Attribute.attributes_set_id' => $this->Session->read('NewProduct.Product.attributes_set_id'),
							'attribute_id' => Set::extract($this->Session->read('NewProduct.ConfigAttribute'), '{n}.attribute_id'),
						),
						'recursive' => 1
					));
					$this->set('attributes', Set::combine($configAttribute, '{n}.Attribute.attribute_id', '{n}'));
					$priceAttribute = $this->Attribute->find('first', array(
						'conditions' => array(
							'attributes_set_id' => $this->Session->read('NewProduct.Product.attributes_set_id'),
							'url' => 'price'
						),
					));
					$this->set('priceAttribute', $priceAttribute);
					$this->render('add_step4');
					break;
				case 'step5':
					if (!empty($this->data)) {
						if (isset($this->data['Photo'])) { 
							$this->Session->write('NewProduct.Photo', $this->data['Photo']);
						}
						$product = $this->Session->read('NewProduct');
						
						$priceAttributeId = $this->Attribute->find(array('attributes_set_id' => $product['Product']['attributes_set_id'], 'Attribute.url' => 'price'));
						$currencyFields = $this->Attribute->find('all', array(
							'fields' => 'Attribute.attribute_id',
							'conditions' => array(
								'Attribute.attributes_set_id' => $product['Product']['attributes_set_id'],
								'AttributeType.name' => 'currency'
							),
							'recursive' => 0
						));
						$currencyFields = Set::extract($currencyFields, '{n}.Attribute.attribute_id');
												
						$productType = $this->ProductType->find('first', array('conditions' => array('product_type_id' => $product['Product']['product_type_id'])));
						// photos
						if (!empty($product['Photo'])) {
							foreach ($product['Photo'] as $photoAttributeId => $photoAttribute) {
								if ($photoAttributeId !== 'crop') {
									foreach ($photoAttribute as $photoKey => $photo) {
										if (is_uploaded_file($photo['tmp_name'])) {
											$productPhoto = array('attribute_id' => $photoAttributeId, 'value' => $this->ImageVersion->save($photo, $product['Product']['name'], null, $product['Photo']['crop'][$photoAttributeId][$photoKey]));
											$product['ProductAttribute'][] = $productPhoto;
										}
									}
								}
							}
						}
						unset($product['Photo']);
						foreach ($product['ProductAttribute'] as $key => $attribute) {
							if (is_array($attribute['value'])) {
								$product['ProductAttribute'][$key]['value'] = implode('-', array_reverse($attribute['value']));
							}
							if (in_array($attribute['attribute_id'], $currencyFields)) {
								$product['ProductAttribute'][$key]['value'] = abs(floatval(strtr(trim($product['ProductAttribute'][$key]['value']), array(' '=>'', ','=>'.'))));
							}
						}
						if (isset($product['Configurable'])) {
							$i = 1;
							foreach ($product['Configurable'] as $group => $configurable) {
								foreach ($configurable as $attributeId => $value) {
									if (is_array($value)) {
										foreach ($value as $checkboxValue) {
											$product['ProductAttribute'][] = array(
												'attribute_id' => $attributeId,
												'attribute_group_id' => $i, 
												'value' => $checkboxValue
											);
										}
									}
									else {
										if ($attributeId == $priceAttributeId['Attribute']['attribute_id']) {
											$value = abs(floatval(strtr(trim($value), array(' '=>'', ','=>'.'))));
										}
										$product['ProductAttribute'][] = array(
											'attribute_id' => $attributeId, 
											'attribute_group_id' => $i, 
											'value' => $value
										);
									}
								}
								$i++;
							}
						}
						unset($product['Configurable']);
						if (empty($product['ProductCategory'])) {
							unset($product['ProductCategory']);
						}
						if ($this->Product->saveAll($product)) {
							$this->Session->setFlash(__('product saved', true), 'default', array('class' => 'alert ok'));
						}
						else {
							$this->Session->setFlash(__('product not saved', true), 'default', array('class' => 'alert error'));
						}
						$this->Session->delete('NewProduct');
						$this->redirect(array('action' => 'index'));
						
					}
					$imageAttributes = $this->AttributeType->findByName('image');
					$imageAttributes = $this->Attribute->find('all', array(
						'conditions' => array(
							'Attribute.attributes_set_id' => $this->Session->read('NewProduct.Product.attributes_set_id'),
							'Attribute.attribute_type_id' => $imageAttributes['AttributeType']['attribute_type_id']
						)
					));
					$this->set('imageAttributes', $imageAttributes);
					
					$this->render('add_step5');
					break;
			}
		}
		
		public function save($url) {
			if (!empty($this->data)) {
				$product = $this->Product->findByUrl($url);
				$this->data['Product']['product_id'] = $product['Product']['product_id'];
				$this->data['Product']['url'] = $this->General->niceUrl($this->data['Product']['name']);
				$categories = array();
				foreach ($this->data['ProductCategory'] as $category) {
					if (!empty($category['category_id'])) {
						$categories[] = array('category_id' => $category['category_id']); 
					}
				}
				$this->data['ProductCategory'] = $categories;
				if (!isset($this->data['ProductAttribute'])) {
					$this->data['ProductAttribute'] = array();
				}
				foreach ($this->data['Photo'] as $photoAttributeId => $photoAttribute) {
					foreach ($photoAttribute as $photo) {
						if (is_uploaded_file($photo['tmp_name'])) {
							$this->data['ProductAttribute'][] = array('attribute_id' => $photoAttributeId, 'value' => $this->ImageVersion->save($photo, $product['Product']['name']));
						}
					}
				}
				foreach ($this->data['ProductAttribute'] as &$attribute) {
					if (isset($attribute['value']['tmp_name']) && is_uploaded_file($attribute['value']['tmp_name'])) {
						$attribute['value'] = $this->ImageVersion->save($attribute['value'], $this->data['Product']['name']);
					}
					else if (is_array($attribute['value'])) {
						$attribute['value'] = implode('-', $attribute['value']);
					}
				}
				if ($this->Product->saveAll($this->data)) {
					$this->Session->setFlash(__('product saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('product not saved', true), 'default', array('class' => 'alert error'));
				}
			}
		}
		
		public function editCategories($url) {
			// product to edit
			$this->Product->recursive = 1;
			$this->Product->unbindModel(array('hasMany' => array('ProductAttribute'), 'belongsTo' => array('AttributesSet', 'ProductType'), 'hasAndBelongsToMany' => array('Category', 'Attribute')));
			$product = $this->Product->findByUrl($url);
			$product['ProductCategory'] = Set::combine($product['ProductCategory'], '{n}.category_id', '{n}');
			
			if (!empty($this->data)) {
				$categories = array();
				$this->data['Product']['product_id'] = $product['Product']['product_id'];
				$this->data['Product']['name'] = trim($this->data['Product']['name']);
				$this->data['Product']['url'] = $this->General->niceUrl($this->data['Product']['name']);
				foreach ($this->data['ProductCategory'] as $category) {
					if (!empty($category['category_id'])) {
						$categories[] = array('category_id' => $category['category_id'], 'product_id' => $product['Product']['product_id']); 
					}
				}
				$this->data['ProductCategory'] = $categories;
				$this->ProductCategory->deleteAll(array('ProductCategory.product_id' => $product['Product']['product_id']));
				/**
				 * @todo overit ci existuje kategorie
				 */
				if (empty($this->data['ProductCategory'])) {
					unset($this->data['ProductCategory']);
				}
				if ($this->Product->saveAll($this->data)) {
					$this->Session->setFlash(__('product saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('product not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			// categories
			$this->set('categories', $this->Category->find('list'));			
			$this->set('product', $product);
		}
		
		public function editAttributes($url) {
			// product to edit
			$this->Product->recursive = 1;
			$this->Product->unbindModel(array('belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Category', 'Attribute')));
			$product = $this->Product->findByUrl($url);
//			$productAttributes = Set::combine($product['ProductAttribute'], '{n}.attribute_id', '{n}');
			
			$selectAttributes = $this->Attribute->find('all', array(
				'fields' => array('Attribute.attribute_id'),
				'conditions' => array(
					'Attribute.attributes_set_id' => $product['Product']['attributes_set_id'],
					'AttributeType.type' => 'select'
				),
				'recursive' => 0
			));
			$selectAttributes = Set::classicExtract($selectAttributes, '{n}.Attribute.attribute_id');
			
			if (!empty($this->data)) {
				$this->ProductAttribute->deleteAll(array('ProductAttribute.product_id' => $product['Product']['product_id'], 'ProductAttribute.attribute_id' => $selectAttributes));
				$currencyFields = $this->Attribute->find('all', array(
					'fields' => 'Attribute.attribute_id',
					'conditions' => array(
						'Attribute.attributes_set_id' => $product['Product']['attributes_set_id'],
						'AttributeType.name' => 'currency'
					),
					'recursive' => 0
				));
				$currencyFields = Set::extract($currencyFields, '{n}.Attribute.attribute_id');
						
				foreach ($this->data['ProductAttribute'] as $key => $attribute) {
					$this->data['ProductAttribute'][$key]['product_id'] = $product['Product']['product_id'];
					if (in_array($attribute['attribute_id'], $selectAttributes) && empty($attribute['value'])) {
						unset($this->data['ProductAttribute'][$key]);
					}
					if (is_array($attribute['value'])) {
						$this->data['ProductAttribute'][$key]['value'] = implode('-', array_reverse($attribute['value']));
					}
					if (in_array($attribute['attribute_id'], $currencyFields)) {
						$this->data['ProductAttribute'][$key]['value'] = abs(floatval(strtr(trim($this->data['ProductAttribute'][$key]['value']), array(' '=>'', ','=>'.'))));
					}
				}
				if ($this->ProductAttribute->saveAll($this->data['ProductAttribute'])) {
					$this->Session->setFlash(__('product saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('product not saved', true), 'default', array('class' => 'alert error'));
				}
			}

			$productAttributes = array();
			foreach ($product['ProductAttribute'] as $attribute) {
				if (in_array($attribute['attribute_id'], $selectAttributes)) {
					if (!isset($productAttributes[$attribute['attribute_id']]) || !is_array($productAttributes[$attribute['attribute_id']])) {
						$productAttributes[$attribute['attribute_id']] = array();
					}
					$productAttributes[$attribute['attribute_id']][$attribute['value']] = $attribute;
				}
				else {
					$productAttributes[$attribute['attribute_id']] = $attribute;
				}
			}
			$product['ProductAttribute'] = $productAttributes;
			
			// product's attributes
			$this->Attribute->recursive = 1;
			$this->Attribute->unbindModel(array('hasMany' => array('ProductAttribute'), 'belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Product')));
			$this->set('attributes', $this->Attribute->findAllByAttributesSetId($product['Product']['attributes_set_id']));
			$product['ConfigAttribute'] = Set::extract($product['ConfigAttribute'], '{n}.attribute_id');
			$this->set('product', $product);
		}
		
		public function editPrices($url) {
			// product to edit
			$this->Product->recursive = 1;
			$this->Product->unbindModel(array('belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Category', 'Attribute')));
			$product = $this->Product->findByUrl($url);
			
			$configAttributes = Set::extract($this->ConfigAttribute->findAllByProductId($product['Product']['product_id']), '{n}.ConfigAttribute.attribute_id');
			
			$this->Attribute->recursive = 1;
			$this->Attribute->unbindModel(array('hasMany' => array('ProductAttribute'), 'belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Product')));
			$attributes = $this->Attribute->find('all', array(
				'conditions' => array(
					'attributes_set_id' => $product['Product']['attributes_set_id'],
					'OR' => array(
						'attribute_id' => $configAttributes,
						'url' => 'price'
					)
				),
			));
			$attributes = Set::combine($attributes, '{n}.Attribute.attribute_id', '{n}');
			$priceAttribute = reset(array_diff(array_keys($attributes), $configAttributes));
			$this->set('configAttributes', $configAttributes);
			$this->set('priceAttribute', $priceAttribute);
			if (!empty($this->data)) {
				$this->ProductAttribute->deleteAll(array('ProductAttribute.product_id' => $product['Product']['product_id'], 'ProductAttribute.attribute_id' => array_merge($configAttributes, array($priceAttribute))));
				
				if ($this->Session->check('EditProduct.Configurable') && is_array($this->Session->read('EditProduct.Configurable'))) {
					$productAttributes = $this->Session->read('EditProduct.Configurable');
					$last = end($productAttributes);
					$i = $last['attribute_group_id'];
				}
				else {
					$productAttributes = array();
					$i = 0;
				}
				$notSaved = array();
				foreach ($this->data['ProductAttribute'] as $key => $attributesGroup) {
					$all = true;
					$one = false;
					foreach ($attributesGroup as $attribute) {
						if (empty($attribute)) {
							$one = true;
						}
						else {
							$all = false;
						}
					}
					if ($all) {
						unset($this->data['ProductAttribute'][$key]);
						continue;
					}
					if ($one) {
						$notSaved[] = $this->data['ProductAttribute'][$key];
						unset($this->data['ProductAttribute'][$key]);
						continue;
					}
					++$i;
					foreach ($attributesGroup as $attributeId => $value) {
						if (is_array($value)) {
							foreach ($value as $checkboxValue) {
								$productAttributes[] = array(
									'attribute_id' => $attributeId,
									'attribute_group_id' => $i, 
									'product_id' => $product['Product']['product_id'], 
									'value' => $checkboxValue
								);
							}
						}
						else {
							if ($attributeId == $priceAttribute) {
								$value = abs(floatval(strtr(trim($value), array(' '=>'', ','=>'.'))));
							}
							$productAttributes[] = array(
								'attribute_id' => $attributeId, 
								'attribute_group_id' => $i,
								'product_id' => $product['Product']['product_id'], 
								'value' => $value
							);
						}
					}
				}
				
				if (count($notSaved) > 0) {
					$this->Session->write('EditProduct.Configurable', $productAttributes);
//					$notSaved = Set::combine($notSaved, '{n}.ProductAttribute.attribute_id', '{n}', '{n}.ProductAttribute.attribute_group_id');
					$this->set('prices', $notSaved);
					$this->set('product', $product);
					$this->set('attributes', $attributes);
					$this->Session->setFlash(__('attributes below not saved', true), 'default', array('class' => 'alert error'));
					$this->render(); 
				}
				else {
					if ($this->ProductAttribute->saveAll($productAttributes)) {
						$this->Session->setFlash(__('product saved', true), 'default', array('class' => 'alert ok'));
						$this->Session->delete('EditProduct');
						$this->redirect(array('action' => 'index'));
					}
					else {
						$this->Session->setFlash(__('product not saved', true), 'default', array('class' => 'alert error'));
					}
				}
			}
			$this->ProductAttribute->recursive = 2;
			$this->ProductAttribute->unbindModel(array('belongsTo' => array('Product')));
			$this->ProductAttribute->Attribute->unbindModel(array('hasMany' => array('ProductAttribute'), 'belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Product')));
			$prices = $this->ProductAttribute->find('all', array(
				'conditions' => array(
					'ProductAttribute.product_id' => $product['Product']['product_id'],
					'ProductAttribute.attribute_id' => array_keys($attributes)
				),
			));
			$this->set('product', $product);
			$this->set('attributes', $attributes);
			$prices = Set::combine($prices, '{n}.ProductAttribute.product_attribute_id', '{n}.ProductAttribute', '{n}.ProductAttribute.attribute_group_id');
			foreach ($prices as $key => $price) {
				$prices[$key] = Set::combine($prices[$key], '{n}.product_attribute_id', '{n}.value', '{n}.attribute_id');
				foreach ($prices[$key] as $attributeId => $value) {
					if (count($value) == 1) {
						$prices[$key][$attributeId] = reset($value);
					}
				}
			}
			$this->set('prices', $prices);
		}
		
		public function editPhotos($url) {
			// product to edit
			$this->Product->recursive = 1;
			$this->Product->unbindModel(array('belongsTo' => array('AttributesSet'), 'hasAndBelongsToMany' => array('Category', 'Attribute')));
			$product = $this->Product->findByUrl($url);
			
			if (!empty($this->data)) {
				foreach ($this->data['Photo'] as $photoAttributeId => $photoAttribute) {
					if ($photoAttributeId !== 'crop') {
						foreach ($photoAttribute as $photoKey => $photo) {
							if (is_uploaded_file($photo['tmp_name'])) {
								$this->data['ProductAttribute'][] = array('attribute_id' => $photoAttributeId, 'value' => $this->ImageVersion->save($photo, $product['Product']['name'], null, $this->data['Photo']['crop'][$photoAttributeId][$photoKey]), 'product_id' => $product['Product']['product_id']);
							}
						}
					}
				}
				
				if ($this->ProductAttribute->saveAll($this->data['ProductAttribute'])) {
					$this->Session->setFlash(__('product saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('product not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			
			$imageAttributes = $this->AttributeType->findByName('image');
			
			$this->ProductAttribute->recursive = 2;
			$this->ProductAttribute->unbindModel(array('belongsTo' => array('Product')));
			$this->ProductAttribute->Attribute->unbindModel(array('hasMany' => array('ProductAttribute', 'AttributeValue'), 'belongsTo' => array('AttributesSet', 'AttributeType'), 'hasAndBelongsToMany' => array('Product')));
			$this->ProductAttribute->bindModel(array(
				'belongsTo' => array(
					'Photo' => array(
						'className' => 'ImageVersion.Photo',
						'foreignKey' => 'value'
					)
				)
			));
			$images = $this->ProductAttribute->find('all', array(
				'fields' => array('ProductAttribute.*', 'Photo.*'),
				'conditions' => array(
					'Attribute.attribute_type_id' => $imageAttributes['AttributeType']['attribute_type_id'],
					'ProductAttribute.product_id' => $product['Product']['product_id']
				)
			));
			$images = Set::combine($images, '{n}.ProductAttribute.product_attribute_id', '{n}', '{n}.ProductAttribute.attribute_id');
			$this->set('images', $images);

			$imageAttributes = $this->Attribute->find('all', array(
				'conditions' => array(
					'Attribute.attributes_set_id' => $product['Product']['attributes_set_id'],
					'Attribute.attribute_type_id' => $imageAttributes['AttributeType']['attribute_type_id']
				)
			));
			$this->set('imageAttributes', $imageAttributes);
			
			$this->set('product', $product);
		}
		
		public function delete($url) {
			if ($this->Product->deleteAll(array('url' => $url))) {
				$this->Session->setFlash(__('product deleted', true), 'default', array('class' => 'alert ok'));
			}
			else {
				$this->Session->setFlash(__('product not deleted', true), 'default', array('class' => 'alert error'));
			}
			$this->redirect(array('action' => 'index'));
		}
	}
?>