<?php
	class Attribute extends EshopAppModel {
		var $primaryKey = 'attribute_id';
		var $displayField = 'name';
		var $recursive = -1;
		var $validate = array(
			'name' => array(
				'rule' => array('minLengthUrlTrim', 2),
				'message' => 'min length 2'
			),
			'url' => array(
				'rule' => array('minLength', 2),
				'message' => 'min length 2'
			),
			'attributes_set_id' => array(
				'rule' => 'numeric',
				'required' => true,
			),
			'attribute_type_id' => array(
				'rule' => 'numeric',
				'required' => true,
			),
		);
		
		var $hasMany = array(
			'ProductAttribute' => array(
				'className' => 'Eshop.ProductAttribute',
				'foreignKey' => 'attribute_id',
				'dependent' => true
			),
			'AttributeValue' => array(
				'className' => 'Eshop.AttributeValue',
				'foreignKey' => 'attribute_id'
			)
		);
		var $belongsTo = array(
			'AttributesSet' => array(
				'className' => 'Eshop.AttributesSet',
				'foreignKey' => 'attributes_set_id',
			),
			'AttributeType' => array(
				'className' => 'Eshop.AttributeType',
				'foreignKey' => 'attribute_type_id'
			)
		);
		var $hasAndBelongsToMany = array(
			'Product' => array(
				'className' => 'Eshop.Product',
				'joinTable' => 'products_attributes',
				'with' => 'Admin.ProductAttribute',
				'foreignKey' => 'attribute_id',
				'associationForeignKey' => 'product_id'
			)
		);
	}
?>