<?php
	class Category extends EshopAppModel {
		var $primaryKey = 'category_id';
		var $displayField = 'name';
		var $recursive = -1;
		var $actsAs = array(
			'Tree'
		);
		var $validate = array(
			'name' => array(
				'rule' => array('minLengthUrlTrim', '2'),
				'message' => 'min length 2'
			),
			'url' => array(
				'lenght' => array(
					'rule' => array('minLength', '2'),
					'message' => 'min length 2'
				),
				'unique' => array(
					'rule' => 'isUnique',
					'message' => 'is not unique'
				)
			)
		);
		var $hasMany = array(
			'ProductCategory' => array(
				'className' => 'Eshop.ProductCategory',
				'foreignKey' => 'category_id',
				'dependent' => true
			),
		);
		var $hasAndBelongsToMany = array(
			'Product' => array(
				'className' => 'Eshop.Product',
				'joinTable' => 'products_categories',
				'with' => 'ProductCategory',
				'foreignKey' => 'category_id',
				'associationForeignKey' => 'product_id',
			)
		);
		
		function beforeSave() {
			$this->data['Category']['name'] = trim($this->data['Category']['name']);
			return true;
		}
	}
?>