<?php
	$javascript->link(array('/scriptaculous/js/scriptaculous.js?load=builder', '/core/js/sort'), false);

	if ($session->check('Message.flash')) {
		$session->flash();
	}
?>

<table id="products" summary="products" class="sortable-table">
	<tr>
		<th><?php __('name'); ?></th>
		<th><?php __('attributes set'); ?></th>
		<th><?php __('attributes type'); ?></th>
		<th><?php __('edit'); ?></th>
		<th><?php __('delete'); ?></th>
		<th><?php __('edit values'); ?></th>
	</tr>
<?php
	$table = '';
	foreach ($attributes as $attribute) {
		$table .= '<tr>';
		$table .= '<td>'.Sanitize::html(__($attribute['Attribute']['name'], true)).'</td>';
		$table .= '<td>'.Sanitize::html($attribute['AttributesSet']['name']).'</td>';
		$table .= '<td>'.Sanitize::html($attribute['AttributeType']['name']).'</td>';
		if (empty($attribute['Attribute']['delete_perm'])) {
			$table .= '<td></td>';
			$table .= '<td></td>';
		}
		else {
			$table .= '<td>'.$html->link(' ', array('action' => 'edit', $attribute['Attribute']['attribute_id']), array('class' => 'edit')).'</td>';
			$table .= '<td>'.$html->link(' ', array('action' => 'delete', $attribute['Attribute']['attribute_id']), array('class' => 'delete')).'</td>';
		}
		if ($attribute['AttributeType']['name'] == 'select') {
			$table .= '<td>'.$html->link(' ', array('controller' => 'attribute_values', 'action' => 'index', $attribute['Attribute']['attribute_id']), array('class' => 'edit')).'</td>';
		}
		else {
			$table .= '<td></td>';
		}
		$table .= '</tr>';
	}
	echo $table;
?>
</table>
