<?php
	$script = 'Event.observe(window, \'load\', function () {
		$$(\'#ProductAddForm .add-photo-button\').each(function(element) {
			element.observe(\'click\', function(event) {
				element = event.findElement();
				fieldset = element.previousSiblings().first();
				count = element.up().getElementsByTagName(\'fieldset\').length;
				name = fieldset.getElementsByTagName(\'input\')[0].getAttribute(\'name\');
				attributeId = /data\[Photo\]\[(\d+)\]/.exec(name)[1];
				newFile = Builder.node(\'fieldset\', {className: \'photo\'}, [
					Builder.node(\'legend\', fieldset.getElementsByTagName(\'legend\')[0].innerHTML),
					Builder.node(\'input\', {id: \'Photo\' + attributeId + count, type: \'file\', name: \'data[Photo][\' + attributeId + \'][\' + count + \']\'}),
					Builder.node(\'div\', {className: \'input checkbox\'}, [
						Builder.node(\'input\', {id: \'PhotoCrop\' + attributeId + count + \'_\', type: \'hidden\', value: 0, name: \'data[Photo][crop][\' + attributeId + \'][\' + count + \']\'}),
						Builder.node(\'input\', {id: \'PhotoCrop\' + attributeId + count, type: \'checkbox\', value: 1, name: \'data[Photo][crop][\' + attributeId + \'][\' + count + \']\'}),
						Builder.node(\'label\', {htmlFor: \'PhotoCrop\' + attributeId + count}, fieldset.getElementsByTagName(\'label\')[0].innerHTML)
					])
				]);
				element.insert({\'before\': newFile});
			});
		});
	});';
	$javascript->link('/scriptaculous/js/scriptaculous.js?load=builder', false);
	$javascript->codeBlock($script, array('inline' => false));
	
	$editForm = $form->create('Product', array(
		'action' => $this->params['action'], 
		'url' => array('action' => $this->params['action'], 'step5'),
		'type' => 'file'
	));

	if (!empty($imageAttributes)) {
		foreach ($imageAttributes as $imageAttribute) {
			
			$editForm .= '<fieldset class="attribute"><legend>'.__('images for attribute', true).' '.__($imageAttribute['Attribute']['name'], true).'</legend>';
			$editForm .= '<fieldset class="photo"><legend>'.__('photo', true).'</legend>';
			
			$editForm .= $form->file('Photo.'.$imageAttribute['Attribute']['attribute_id'].'.0');
			$editForm .= $form->input('Photo.crop.'.$imageAttribute['Attribute']['attribute_id'].'.0', array(
				'label' => __('crop', true), 
				'type' => 'checkbox', 
			));
			
			$editForm .= '</fieldset>';
			$editForm .= '<button class="add-photo-button" type="button">'.__('add next', true).'</button>';
			$editForm .= '</fieldset>';
		}
	}
	else {
		$editForm .= $form->hidden('photo', array('value' => 'no-photos'));
		$editForm .= $html->tag('h2', __('no photo attributes', true));
	}
	
	echo $editForm .= $form->end(__('save', true)); 
?>