<?php
	$editForm = $form->create('Product', array('url' => array('action' => $this->params['action'], $product['Product']['url'])));
//	$editForm .= $form->input('Product.name', array('label' => __('name', true), 'value' => isset($product['Product']['name']) ? $product['Product']['name'] : ''));

	// attributes
	$attributesHtml = '';
	$i = 0;
	foreach ($attributes as $attribute) {
		if ((!empty($product['ConfigAttribute'])) && ((in_array($attribute['Attribute']['attribute_id'], $product['ConfigAttribute'])) || ($attribute['Attribute']['url'] == 'price'))) {
			continue;
		}
		if (!in_array($attribute['AttributeType']['name'], array('image', 'select'))) {
			$attributesHtml .= $form->hidden('ProductAttribute.'.++$i.'.attribute_id', array('value' => $attribute['Attribute']['attribute_id']));
			if ($attribute['AttributeType']['name'] != 'image') {
				$attributesHtml .= $form->hidden('ProductAttribute.'.$i.'.product_attribute_id', array('value' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) ? $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['product_attribute_id'] : ''));
			}
		}
		switch ($attribute['AttributeType']['name']) {
			case 'boolean':
				$attributesHtml .= $form->input('ProductAttribute.'.$i.'.value', array(
					'label' => __($attribute['Attribute']['name'], true), 
					'type' => $attribute['AttributeType']['type'], 
					'checked' => (isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) && $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['value']) ? 'checked' : ''
				));
				break;
			case 'string':
			case 'currency':
			case 'int':
			case 'text':
			case 'float':
				$attributesHtml .= $form->input('ProductAttribute.'.$i.'.value', array(
					'label' => __($attribute['Attribute']['name'], true), 
					'type' => $attribute['AttributeType']['type'], 
					'value' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) ? $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['value'] : ''
				));
				break;
			case 'date':
				$attributesHtml .= $form->input('ProductAttribute.'.$i.'.value', array(
					'label' => __($attribute['Attribute']['name'], true), 
					'type' => $attribute['AttributeType']['type'], 
					'dateFormat' => 'DMY',
					'minYear' => date('Y'),
					'maxYear' => date('Y') + 5,
					'selected' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) ? $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['value'] : ''
				));
				break;
			case 'select':
				$attributeValues = Set::combine($attribute['AttributeValue'], '{n}.attribute_value_id', '{n}.value');
				$checkboxes = '';
				foreach ($attributeValues as $key => $attributeValue) {
					$checkboxes .= $form->hidden('ProductAttribute.'.++$i.'.attribute_id', array('value' => $attribute['Attribute']['attribute_id']));
					$checkboxes .= $form->input('ProductAttribute.'.$i.'.value', array(
						'type' => 'checkbox', 
						'value' => $key, 
						'label' => __($attributeValue, true),
						'checked' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']][$key]) ? 'checked' : ''
					));
				}
				$editForm .= $html->tag('fieldset', $html->tag('legend', __($attribute['Attribute']['name'], true)).$checkboxes);
				break;
			default:
		}
	}
	$attributesHtml .= '</fieldset>';
	$editForm .= $html->tag('div', $attributesHtml, array('class' => 'tab'));
		
	echo $editForm .= $form->end(__('save', true));
?>