<?php
	class ImageVersionComponent extends Object {
		var $components = array('Session');
		var $controller;
		
		var $savePath = 'files/images';
		public $model = 'Photo';
		
		var $thumbQuality = 85;
		
		var $allowedMimeTypes = array('image/jpeg', 'image/gif', 'image/png');
		
    	var $imageDimensions = array(
			array('width' => 0, 'height' => 0),
    		array('width' => 40, 'height' => 40),
			array('width' => 100, 'height' => 100)
		);
		
	    public function startup(&$controller) {
	        $this->Photo = ClassRegistry::init($this->model);
	    }
	    
	    public function validateSource($source) {
	        if(empty($source)) { 
	        	return false;
	        }
	        if(!file_exists($source['tmp_name']) || !is_uploaded_file($source['tmp_name'])) { 
	        	return false; 
	        }
            if (!in_array($source['type'], $this->allowedMimeTypes)) {
            	return false;
            }
            return true;	            
        }
	    
	    public function version($source, $thumbSize = array(75, 75), $crop = false) {
	    	if (!$this->validateSource($source)) {
	    		return false;
	    	}
	    	
	        $webroot = new Folder(WWW_ROOT);
	        $tmpFile = new File($source['tmp_name']);

	        $thumbX = $thumbSize[0];
	        $thumbY = $thumbSize[1];
	    
	        $pathToSave = $this->createPath($webroot->path.$this->savePath.'_'.$thumbX.'x'.$thumbY);                    
	        $newFile = new File($webroot->path.$this->savePath.'_'.$thumbX.'x'.$thumbY.DS.$source['name']);                                        
	        
	        $size = getimagesize($tmpFile->path);
	        $sourceWidth = $size[0];
	        $sourceHeight = $size[1];

	        $offsetX = 0;
	        $offsetY = 0;
	        
	        if (($thumbX !== 0) && ($thumbY !== 0)) {
		        $aspectRatioX = $sourceWidth / $thumbX;
		        $aspectRatioY = $sourceHeight / $thumbY;
		        if (($aspectRatioX < 1) && ($aspectRatioY < 1)) {
		        	$aspectRatioX = 1;
		        	$aspectRatioY = 1;
					$offsetX = (int)(($thumbX - $sourceWidth) / 2);
					$offsetY = (int)(($thumbY - $sourceHeight) / 2);
		        }
		        else {
					if (!empty($crop)) {
						if ($aspectRatioX < $aspectRatioY) {
							$aspectRatio = $aspectRatioX;
							$offsetY = (int)(($thumbY - ($sourceHeight / $aspectRatio)) / 2);
						}
						else {
							$aspectRatio = $aspectRatioY;
							$offsetX = (int)(($thumbX - ($sourceWidth / $aspectRatio)) / 2);
						}
					}
					else {
						if ($aspectRatioX > $aspectRatioY) {
							$aspectRatio = $aspectRatioX;
							$offsetY = (int)(($thumbY - ($sourceHeight / $aspectRatio)) / 2);
						}
						else {
							$aspectRatio = $aspectRatioY;
							$offsetX = (int)(($thumbX - ($sourceWidth / $aspectRatio)) / 2);
						}
					}
		        }
	        }
	        else {
	        	$thumbX = $sourceWidth;
	        	$thumbY = $sourceHeight;
	        }

			$newImage = imagecreatetruecolor($thumbX, $thumbY);
			$color = imagecolorallocate($newImage, 255, 255, 255);
			imagefill($newImage, 0, 0, $color);
	        
	        switch($source['type']) {
		        case 'image/png':
		            if($this->thumbQuality != 0):
		                $this->thumbQuality = ceil($this->thumbQuality / 10); // 0-9 is the range for png    
		            endif;                
		            $sourceImage = imagecreatefrompng($tmpFile->path);
		            imagecopyresampled($newImage, $sourceImage, $offsetX, $offsetY, 0, 0, $thumbX - $offsetX, $thumbY - $offsetY, $sourceWidth, $sourceHeight);    
					imagepng($newImage,$newFile->path,$this->thumbQuality);
		        break;
		        
		        case 'image/gif':
		            $sourceImage = imagecreatefromgif($tmpFile->path);
		            imagecopyresampled($newImage, $sourceImage, $offsetX, $offsetY, 0, 0, $thumbX - $offsetX, $thumbY - $offsetY, $sourceWidth, $sourceHeight);    
					imagegif($newImage, $newFile->path); // no quality setting
		        break;
		        
		        case 'image/jpeg':
		        default:
		            $sourceImage = imagecreatefromjpeg($tmpFile->path);
		            imagecopyresampled($newImage, $sourceImage, $offsetX, $offsetY, 0, 0, $thumbX - (2 * $offsetX), $thumbY - (2 * $offsetY), $sourceWidth, $sourceHeight);    
		            imagejpeg($newImage, $newFile->path, $this->thumbQuality);
		        break;        
	        }
            $finalPath = substr(strstr($newFile->path, 'webroot'), 7);
	        
	        return str_replace('\\', '/', $finalPath);        
	    }
	
	    function createPath($path = null) {
			if(!file_exists($path)) { 
	    		mkdir($path, 0775, true);
			}
			if (substr($path, -1) != '/') {
				$path .= DS;
			}
	        return $path;
	    }

	    public function save($source, $name = '', $description = null, $crop = false) {
			if (!$this->validateSource($source)) {
				return false;
			}
			if ($description == null) {
				$description = $name;
			}
	        $newFile = new File($source['name']);
			$source['name'] = String::uuid().'.'.$newFile->ext();
			$data = array();
			$data['file'] = $source['name'];
			$data['description'] = $description; 
			$data['name'] = $name;
			foreach ($this->imageDimensions as $dimension) {
				$this->version($source, array($dimension['width'], $dimension['height']), $crop);
			}
			if ($this->Photo->save($data)) {
				$this->Session->setFlash(__('photo saved', true), 'default', array('class' => 'alert ok'));
				return $this->Photo->id;
			}
			else {
				$this->Session->setFlash(__('photo not saved', true), 'default', array('class' => 'alert error'));
				return false;
			}
	    }
	}
?>