<?php
	$javascript->link(array('/scriptaculous/js/builder', '/core/js/sort'), false);

	$options = Set::combine($orderStates, '{n}.OrderState.order_state_id', '{n}.OrderState.name');
	foreach ($options as &$option) {
		$option = __($option, true);
	}
	$ordersTable = $html->tableHeaders(array(
		__('order id', true),
		__('bill name', true),
		__('ship name', true),
		__('price', true),
		__('date', true),
		__('status', true),
	));
	foreach ($orders as $order) {
		$tr = '<tr>';
		$tr .= '<td>'.$order['Order']['order_id'].'</td>';
		$tr .= '<td>'.$order['Order']['bill_name'].'</td>';
		$tr .= '<td>'.$order['Order']['ship_name'].'</td>';
		$tr .= '<td>'.number_format($order['Order']['price'], 2, ',', ' ').'</td>';
		$tr .= '<td>'.date('d.m.Y', strtotime($order['Order']['date'])).'</td>';
		$tr .= '<td>'.$form->select('', $options, $order['Order']['status'], null, false).'</td>';
		$tr .= '</tr>';
		$ordersTable .= $tr;
	}
	echo $html->tag('table', $ordersTable, array('summary' => 'orders', 'class' => 'sortable-table'));
?>