<?php
	App::import('Sanitize');
	
	class TreeHelper extends AppHelper {
		var $helpers = array('Html');
		
		private $active = '';
		
		private function renderItem($node, $additions, $urlPath) {
			if (!empty($urlPath)) {
				if (isset($urlPath['plugin'])) { 
					if (strpos($urlPath['plugin'], '{n}.') !== false) {
						$plugin = $node[substr($urlPath['plugin'], strpos($urlPath['plugin'], '{n}.') + 4)];
					}
					else {
						$plugin = $urlPath['plugin'];
					}
				}
				if (strpos($urlPath['controller'], '{n}.') !== false) {
					$controller = $node[substr($urlPath['controller'], strpos($urlPath['controller'], '{n}.') + 4)];
				}
				else {
					$controller = $urlPath['controller'];
				}
				if (empty($controller)) {
					$item = '<h4>'.__(Sanitize::html($node['name']), true).'</h4>';
				}
				else {
					if (strpos($urlPath['action'], '{n}.') !== false) {
						$action = $node[substr($urlPath['action'], strpos($urlPath['action'], '{n}.') + 4)];
					}
					else {
						$action = $urlPath['action'];
					}
					$link = array('controller' => $controller);
					if (!empty($plugin)) {
						$link['plugin'] = $plugin;
					}
					if (!empty($action)) {
						$link['action'] = $action;
					}
					if (isset($urlPath['params'])) {
						$link[] = reset(Set::extract($node, $urlPath['params']));
					}
					$item = $this->Html->link(
						'<strong>'.__(Sanitize::html($node['name']), true).'</strong>', 
						Sanitize::html($link), 
						array(), null, false
					);
				}
			}
			else {
				$item = $this->Html->link('<strong>'.__(Sanitize::html($node['name']), true).'</strong>', '#', array(), null, false);
			}
			return $item .= String::insert($additions, array('url' => $node['url']));
		}
		
		/**
		 * 
		 * @param $nodes array list of all nodes
		 * @param $active active tree item 
		 * @param $additions string string suffix, which will be added to each generated element with :url replacement
		 * @return unknown_type
		 */
		public function render($nodes, $active = '', $additions = null, $urlPath = array()) {
			if (!is_array($active)) {
				$active = array('name' => $active);
			}
			$this->active = $active;
			
			$stack = array();
			$menu = '<ul>';
			foreach ($nodes as $nodeKey => $node) {
				while ($stack && ($stack[count($stack) - 1] < $node['rght'])) {
					$menu .= '</ul>';
					array_pop($stack);
				}
				reset($active);
				list($itemKey, $val) = each($active);
				$options = array();
				if (is_array($active) && !empty($active) && ($node[$itemKey] == $val)) {
					$options['class'] = 'active';
				}
				$menu .= $this->Html->tag('li', $this->renderItem($node, $additions, $urlPath), $options);
				if (isset($nodes[$nodeKey + 1]) && $nodes[$nodeKey + 1]['lft'] > $node['lft'] && $nodes[$nodeKey + 1]['rght'] < $node['rght']) {
					$menu .= '<ul>';
					$stack[] = $node['rght'];
				}
			}
			return $menu .= str_repeat('</ul></li>', count($stack) + 1).'</ul>';
		}
	}
?>