<?php
	class AttributeValuesController extends EshopAppController {
		var $helpers = array('Javascript', 'Core.Tree', 'Core.Toolbar');
		var $components = array('Auth', 'Core.General');
		var $uses = array('Eshop.Attribute', 'Eshop.AttributeValue');
		
		public function index($attributeUrl) {
			$this->Attribute->recursive = 1;
			$attribute = $this->Attribute->findByAttributeId($attributeUrl);
			if ($this->Session->check('notSaved')) {
				$this->set('notSaved', $this->Session->read('notSaved'));
				$this->Session->delete('notSaved');
				$this->set('errorMessage', $this->AttributeValue->validate['value']['message']);
			}
			$this->set('attribute', $attribute);
		}
				
		public function add($url) {
			if (!empty($this->data)) {
				$attribute = $this->Attribute->findByAttributeId($url);
				$notSaved = array();
				foreach ($this->data['AttributeValue'] as $value) {
					$this->AttributeValue->create();
					$toSave = array('AttributeValue' => array('attribute_id' => $attribute['Attribute']['attribute_id'], 'value' => trim($value)));
					if (!$this->AttributeValue->save($toSave)) {
						$notSaved[] = $toSave;
					}
				}
			}
			if (count($notSaved) > 0) {
				$this->Session->setFlash(__('attribute values not saved', true), 'default', array('class' => 'alert error'));
				$this->Session->write('notSaved', $notSaved);
			}
			else {
				$this->Session->setFlash(__('attribute values saved', true), 'default', array('class' => 'alert ok'));
				$this->Session->delete('notSaved');
			}
			$this->redirect($this->referer());
		}
		
		public function edit($attributeValueId) {
			if (!empty($this->data)) {
				$this->data['AttributeValue']['value'] = trim($this->data['AttributeValue']['value']);
				if ($this->AttributeValue->save($this->data)) {
					$this->Session->setFlash(__('attribute value saved', true), 'default', array('class' => 'alert ok'));
					$this->AttributeValue->recursive = 1;
					$attributeValue = $this->AttributeValue->find('first', array('conditions' => array('AttributeValue.attribute_value_id' => $attributeValueId)));
					$this->redirect(array('action' => 'index', $attributeValue['Attribute']['attribute_id']));
				}
				else {
					$this->Session->setFlash(__('attribute value not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			$this->set('attributeValue', $this->AttributeValue->findByAttributeValueId($attributeValueId));
		}
		
		public function delete($attributeValueId) {
			if ($this->AttributeValue->remove($attributeValueId)) {
				$this->Session->setFlash(__('attribute value deleted', true), 'default', array('class' => 'alert ok'));
			}
			else {
				$this->Session->setFlash(__('attribute value not deleted', true), 'default', array('class' => 'alert error'));
			}
			$this->redirect($this->referer());
		}		
	}
?>