<?php
	class AttributesController extends EshopAppController {
		var $helpers = array('Javascript', 'Core.Tree', 'Core.Toolbar');
		var $components = array('Auth', 'Core.General');
		var $uses = array('Eshop.Attribute', 'Eshop.AttributesSet', 'Eshop.AttributeType');
		
		public function index() {
			$this->Attribute->recursive = 1;
			$this->set('attributes', $this->Attribute->find('all', array(
				'order' => array('Attribute.attributes_set_id', 'attribute_id')
			)));
		}
				
		public function add() {
			if (!empty($this->data)) {
				$this->data['Attribute']['url'] = $this->General->niceUrl($this->data['Attribute']['name'], true);
				if ($this->Attribute->save($this->data)) {
					$this->Session->setFlash(__('attribute saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('attribute not saved', true), 'default', array('class' => 'alert error'));
					$this->set('attribute', $this->data);
				}
			}
			$this->set('attributes', $this->Attribute->find('all'));
			$this->set('attributesSets', $this->AttributesSet->find('list'));
			$this->set('attributesTypes', $this->AttributeType->find('list'));
			$this->render('edit');
		}
		
		public function edit($attributeId) {
			if (!empty($this->data)) {
				$this->data['Attribute']['attribute_id'] = $attributeId;
				$this->data['Attribute']['url'] = $this->General->niceUrl($this->data['Attribute']['name'], true);
				if ($this->Attribute->save($this->data)) {
					$this->Session->setFlash(__('attribute saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('attribute not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			$this->set('attribute', $this->Attribute->findByAttributeId($attributeId));
			$this->set('attributes', $this->Attribute->findAll());
			$this->set('attributesSets', $this->AttributesSet->find('list'));
			$this->set('attributesTypes', $this->AttributeType->find('list'));
		}
		
		public function delete($attributeId) {
			if ($this->Attribute->remove($attributeId)) {
				$this->Session->setFlash(__('attribute deleted', true), 'default', array('class' => 'alert ok'));
			}
			else {
				$this->Session->setFlash(__('attribute not deleted', true), 'default', array('class' => 'alert error'));
			}
			$this->redirect($this->referer());
		}
		
	}
?>