<?php
	class AttributesSetsController extends EshopAppController {
		var $helpers = array('Javascript', 'Core.Tree', 'Core.Toolbar');
		var $components = array('Auth', 'Core.General');
		var $uses = array('Eshop.AttributesSet', 'Eshop.AttributeType');
		
		public function index() {
			$this->set('attributesSet', $this->AttributesSet->findAll());
		}
		
		public function add() {
			if (!empty($this->data)) {
				$this->data['AttributesSet']['name'] = trim($this->data['AttributesSet']['name']);
				$priceType = $this->AttributeType->findByName('currency');
				$this->data['Attribute'][] = array(
					'attribute_type_id' => $priceType['AttributeType']['attribute_type_id'], 
					'name' => 'price', 
					'url' => 'price', 
					'delete_perm' => 0
				);
				$imageType = $this->AttributeType->findByName('image');
				$this->data['Attribute'][] = array(
					'attribute_type_id' => $imageType['AttributeType']['attribute_type_id'], 
					'name' => 'photo', 
					'url' => 'photo', 
					'delete_perm' => 0
				);
				if ($this->AttributesSet->saveAll($this->data)) {
					$this->Session->setFlash(__('attributes set saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('attributes set not saved', true), 'default', array('class' => 'alert error'));
					$this->set('attributesSet', $this->data);
				}
			}
			$this->render('edit');
		}
		
		public function edit($attributesSetId) {
			if (!empty($this->data)) {
				$this->data['AttributesSet']['attributes_set_id'] = $attributesSetId;
				if ($this->AttributesSet->save($this->data)) {
					$this->Session->setFlash(__('attributes set saved', true), 'default', array('class' => 'alert ok'));
					$this->redirect(array('action' => 'index'));
				}
				else {
					$this->Session->setFlash(__('attributes set not saved', true), 'default', array('class' => 'alert error'));
				}
			}
			$this->set('attributesSet', $this->AttributesSet->findByAttributesSetId($attributesSetId));
		}
		
		public function delete($attributesSetId) {
			if ($this->AttributesSet->remove($attributesSetId)) {
				$this->Session->setFlash(__('attributes set deleted', true), 'default', array('class' => 'alert ok'));
			}
			else {
				$this->Session->setFlash(__('attributes set not deleted', true), 'default', array('class' => 'alert error'));
			}
			$this->redirect($this->referer());
		}
	}
?>