<?php
	class BackendMenuController extends EshopAppController {
		var $uses = array('Eshop.BackendMenu');
		var $components = array('Core.General');
		var $helpers = array('Javascript', 'Core.Tree');

		public function index() {
			$this->set('menu', Set::extract($this->BackendMenu->children(), '{n}.BackendMenu'));			
		}
		
		public function add() {
			if (!empty($this->data)) {
				$this->data['BackendMenu']['url'] = $this->General->niceUrl($this->data['BackendMenu']['name']);
				$this->BackendMenu->save($this->data);
				$this->redirect(array('controller' => 'backend_menu', 'action' => 'index'));
			}
			$this->set('menuList', $this->BackendMenu->find('list'));
		}
		
		public function edit($url) {
			if (!empty($this->data)) {
				$menu = $this->BackendMenu->findByUrl($url);
				$this->data['BackendMenu']['menu_id'] = $menu['BackendMenu']['menu_id'];
				$this->data['BackendMenu']['url'] = $this->General->niceUrl($this->data['BackendMenu']['name']);
				$this->BackendMenu->save($this->data);
				$this->redirect(array('action' => 'index'));
			}
			$this->set('menu', $this->BackendMenu->findByUrl($url));
			$this->set('menuList', $this->BackendMenu->find('list'));
		}
		
		public function delete($url) {
			$menu = $this->BackendMenu->findByUrl($url);
			$this->BackendMenu->delete($menu['BackendMenu']['menu_id']);
			$this->redirect($this->referer());
		}
		
		public function up($url) {
			$menu = $this->BackendMenu->findByUrl($url);
			if (!empty($menu)) {
				$this->BackendMenu->moveUp($menu['BackendMenu']['menu_id']);
			}
			$this->redirect($this->referer());
		}
		
		public function down($url) {
			$menu = $this->BackendMenu->findByUrl($url);
			if (!empty($menu)) {
				$this->BackendMenu->moveDown($menu['BackendMenu']['menu_id']);
			}
			$this->redirect($this->referer());
		}
	}
?>