<?php
	class AttributeValue extends EshopAppModel {
		var $primaryKey = 'attribute_value_id';
		var $recursive = -1;
		var $validate = array(
			'value' => array(
				'rule' => array('minLength', 2),
				'message' => 'min length 2'
			)
		);
		
		var $belongsTo = array(
			'Attribute' => array(
				'className' => 'Eshop.Attribute',
				'foreignKey' => 'attribute_id'
			)
		);
		
		function beforeSave() {
			$this->data['AttributeValue']['value'] = trim($this->data['AttributeValue']['value']);
			return true;
		}
	}
?>