<?php
	class AttributesSet extends EshopAppModel {
		var $primaryKey = 'attributes_set_id';
		var $displayField = 'name';
		var $recursive = -1;
		var $validate = array(
			'name' => array(
				'rule' => array('minLengthUrlTrim', 4),
				'message' => 'min length 4'
			)
		);
		
		var $hasMany = array(
			'Product' => array(
				'className' => 'Eshop.Product',
				'foreignKey' => 'attributes_set_id',
			),
			'Attribute' => array(
				'className' => 'Eshop.Attribute',
				'foreignKey' => 'attributes_set_id',
				'dependent' => true
			)
		);
		
		public function beforeSave() {
			$this->data['AttributesSet']['name'] = trim($this->data['AttributesSet']['name']);
			return true;
		}
	}
?>