<?php
	class Product extends EshopAppModel {
		var $primaryKey = 'product_id';
		var $displayField = 'name';
		var $recursive = -1;
		var $validate = array(
			'name' => array(
				array(
					'rule' => array('minLengthUrlTrim', '2'),
					'message' => 'min length 2'
				),
				array(
					'rule' => 'isUnique',
					'message' => 'is not unique'
				),
			),
			'url' => array(
				'length' => array(
					'rule' => array('minLength', '2'),
					'message' => 'min length 2'
				),
				'unique' => array(
					'rule' => 'isUnique',
					'message' => 'is not unique'
				)
			),
			'attributes_set_id' => array(
				'rule' => 'numeric',
				'message' => 'is not number'
			),
			'attribute_type_id' => array(
				'rule' => 'numeric',
				'message' => 'is not number'
			)
			
		);
		
		var $hasMany = array(
			'ProductCategory' => array(
				'className' => 'Eshop.ProductCategory',
				'foreignKey' => 'product_id',
				'dependent' => true
			),
			'ProductAttribute' => array(
				'className' => 'Eshop.ProductAttribute',
				'foreignKey' => 'product_id',
				'dependent' => true
			),
			'ConfigAttribute' => array(
				'className' => 'Eshop.ConfigAttribute',
				'foreignKey' => 'product_id',
				'dependent' => true
			),
		);
		var $belongsTo = array(
			'AttributesSet' => array(
				'className' => 'Eshop.AttributesSet',
				'foreignKey' => 'attributes_set_id',
			),
			'ProductType' => array(
				'className' => 'Eshop.ProductType',
				'foreignKey' => 'product_type_id'
			),
		);
		var $hasAndBelongsToMany = array(
			'Category' => array(
				'className' => 'Eshop.Category',
				'joinTable' => 'products_categories',
				'with' => 'ProductCategory',
				'foreignKey' => 'product_id',
				'associationForeignKey' => 'category_id'
			),
			'Attribute' => array(
				'className' => 'Eshop.Attribute',
				'joinTable' => 'products_attributes',
				'with' => 'ProductAttribute',
				'foreignKey' => 'product_id',
				'associationForeignKey' => 'attribute_id'
			)
		);
	}
?>
