<?php
//	$product['ProductAttribute'] = Set::combine($product['ProductAttribute'], '{n}.attribute_id', '{n}');
	$javascript->link(array('prototype', 'scriptaculous.js?load=effects,builder'), false);
	$javascript->codeBlock($this->element('javascript'), array('inline' => false));
	$javascript->link(array('lightbox'), false);

	$editForm = $form->create('Product', array(
		'action' => $this->params['action'], 
		'url' => array('action' => $this->params['action'], isset($product) ? $product['Product']['url'] : ''),
		'type' => 'file'
	));
	$editForm .= $form->hidden('product_id', array('value' => isset($product) ? $product['Product']['product_id'] : ''));
	$editForm .= $form->input('name', array('label' => __('name', true), 'value' => isset($product) ? $product['Product']['name'] : ''));
	$select = $form->label('attribute_set_id', __('attributes set', true));
	$select .= $form->select('attributes_set_id', $attributesSets, isset($product) ? $product['Product']['attributes_set_id'] : '');
	$editForm .= $html->div('input select', $select);
	
	$i = 0;
	if (!empty($product['Product']['attributes_set_id'])) {
		$attributes = $product['AttributesSet']['Attribute'];
		foreach ($attributes as $attribute) {
			$editForm .= $form->hidden('ProductAttribute.'.++$i.'.attribute_id', array('value' => $attribute['attribute_id']));
			if ($attribute['AttributesType']['name'] != 'image') {
				$editForm .= $form->hidden('ProductAttribute.'.$i.'.product_attribute_id', array('value' => isset($product['ProductAttribute'][$attribute['attribute_id']]) ? $product['ProductAttribute'][$attribute['attribute_id']]['product_attribute_id'] : ''));
			}
			switch ($attribute['AttributesType']['name']) {
				case 'boolean':
					$editForm .= $form->input('ProductAttribute.'.$i.'.value', array(
						'label' => __($attribute['url'], true), 
						'type' => $attribute['AttributesType']['type'], 
						'checked' => (isset($product['ProductAttribute'][$attribute['attribute_id']]) && $product['ProductAttribute'][$attribute['attribute_id']]['value']) ? 'checked' : ''
					));
					break;
				case 'string':
				case 'currency':
				case 'int':
				case 'text':
					$editForm .= $form->input('ProductAttribute.'.$i.'.value', array(
						'label' => __($attribute['url'], true), 
						'type' => $attribute['AttributesType']['type'], 
						'value' => isset($product['ProductAttribute'][$attribute['attribute_id']]) ? $product['ProductAttribute'][$attribute['attribute_id']]['value'] : ''
					));
					break;
				case 'date':
					$editForm .= $form->input('ProductAttribute.'.$i.'.value', array(
						'label' => __($attribute['url'], true), 
						'type' => $attribute['AttributesType']['type'], 
						'dateFormat' => 'DMY',
						'minYear' => date('Y'),
						'maxYear' => date('Y') + 5,
						'selected' => isset($product['ProductAttribute'][$attribute['attribute_id']]) ? $product['ProductAttribute'][$attribute['attribute_id']]['value'] : ''
					));
					break;
				case 'image':
					$file = $form->label('ProductAttribute.'.$i.'.value', __($attribute['url'], true));
					$file .= $form->file('ProductAttribute.'.$i.'.value');
					$editForm .= $html->div('input file', $file);
					break;
				case 'select':
					$attributeValues = Set::combine($attribute['AttributesValue'], '{n}.attributes_value_id', '{n}.value');
					$select = $form->label('ProductAttribute.'.$i.'.value', __($attribute['url'], true));
					$select .= $form->select('ProductAttribute.'.$i.'.value', $attributeValues,
						isset($product['ProductAttribute'][$attribute['attribute_id']]) ? $product['ProductAttribute'][$attribute['attribute_id']]['value'] : ''
					);
					$editForm .= $html->div('input select', $select);
					break;
				default:
			}
		}
	}
	echo $editForm .= $form->end(__('save', true));
	
	if (isset($photos)) {
		$galery = '';
		foreach ($photos as $photo) {
			$galery .= '<div class="photo">';
			foreach ($photo['Image'] as $key => $image) {
				if ($image['width'] == 100) {
					$image100 = $image;
				}
				if ($image['width'] == 1024) {
					$image1024 = $image;
				}
			}
			
			$galery .= $html->link(
				$html->image($image100['file'], array('alt' => $photo['Photo']['name'])), 
				$image1024['file'], 
				array(
					'rel' => 'lightbox[galery]',
					'title' => $photo['Photo']['description'],
				), 
				null, 
				false
			);
			$galery .= $html->link(' ', array('controller' => 'photos', 'action' => 'edit', $photo['Photo']['photo_id']), array('class' => 'edit', 'title' => __('edit photo', true)));
			$galery .= $html->link(' ', array('controller' => 'photos', 'action' => 'unlink', $photo['Photo']['photo_id']), array('class' => 'unlink', 'title' => __('unlink photo', true)));
			$galery .= $html->link(' ', array('controller' => 'photos', 'action' => 'delete', $photo['Photo']['photo_id']), array('class' => 'delete', 'title' => __('delete photo', true)));
			$galery .= '</div>';
		}
		echo '<div id="photogalery">'.$galery.'</div>';
	}
?>