<?php
	if (isset($errors)) {
		$form->validationErrors = $errors;
	}
	$javascript->link(array('/scriptaculous/js/scriptaculous.js?load=builder'), false);
	$script = 'Event.observe(window, \'load\', function() {
		$(\'ProductName\').observe(\'blur\', function(event) {
			name = Event.findElement(event).value;
			url = app.baseUrl + \'/eshop/products/checkUrl/\' + name;
			new Ajax.Request(url, {
				method: \'post\',
				onComplete: function(xmlHttp) {
					message = xmlHttp.responseXML.getElementsByTagName(\'message\')[0];
					status = Builder.node(\'div\', {\'class\': message.getAttribute(\'status\')}, [
							Builder.node(\'strong\', message.getAttribute(\'text\'))
					]);
					$(\'ProductName\').nextSiblings().each(function(element) {
						element.remove();
					});
					$(\'ProductName\').insert({\'after\': status});
				}
			});
		});
	});';
	
	$javascript->codeBlock($script, array('inline' => false));
	
	$editForm = $form->create('Product', array(
		'action' => $this->params['action'], 
		'url' => array('action' => $this->params['action'], 'step1'),
		'legend' => 'product type'
	));
	$editForm .= '<fieldset><legend>'.__('product type', true).'</legend>';
	$editForm .= $form->hidden('product_id', array('value' => isset($product) ? $product['Product']['product_id'] : ''));
	$editForm .= $form->input('name', array('label' => __('name', true), 'value' => isset($product) ? $product['Product']['name'] : ''));
	
	$select = $form->label('attribute_set_id', __('attributes set', true));
	$select .= $form->select('attributes_set_id', $attributesSets, isset($product) ? $product['Product']['attributes_set_id'] : '', array(), false);
	$editForm .= $html->div('input select', $select);
	
	$select = $form->label('product_type_id', __('product type', true));
	$select .= $form->select('product_type_id', $productTypes, isset($product) ? $product['Product']['product_type_id'] : '', array(), false);
	$editForm .= $html->div('input select', $select);
	$editForm .= '</fieldset>';
	$editForm .= '<fieldset><legend>'.__('categories', true).'</legend>';
	
	$i = 0;
	foreach ($categories as $key => $category) {
		$category = str_replace('_', '', $category, $count);
		$label = $form->checkbox('ProductCategory.'.$i.'.category_id', array('label' => __($category, true), 'value' => $key));
		$label .= $form->label('ProductCategory.'.$i++.'.category_id', $category);
		$editForm .= $html->div('input checkbox', $label);
	}
	$editForm .= '</fieldset>';

	echo $editForm .= $form->end(__('save', true));
?>