<?php
	$editForm = $form->create('Product', array(
		'action' => $this->params['action'], 
		'url' => array('action' => $this->params['action'], 'step3'),
	));
	
	$editForm .= '<fieldset><legend>'.__('attributes', true).'</legend>';
	
	$i = 0;
	foreach ($attributes as $attribute) {
		/**
		 * @todo decide which attributes will be rendered, how many image-fields can exists
		 * @todo select attribute type
		 */
		if ((isset($configAttribute)) && (in_array($attribute['Attribute']['attribute_id'], $configAttribute) || ($attribute['Attribute']['url'] == 'price'))) {
			continue;
		}
		if (!in_array($attribute['AttributeType']['name'], array('image', 'select'))) {
			$editForm .= $form->hidden('ProductAttribute.'.++$i.'.attribute_id', array('value' => $attribute['Attribute']['attribute_id']));
			if ($attribute['AttributeType']['name'] != 'image') {
				$editForm .= $form->hidden('ProductAttribute.'.$i.'.product_attribute_id', array('value' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) ? $product['ProductAttribute'][$attribute['attribute_id']]['product_attribute_id'] : ''));
			}
		}
		switch ($attribute['AttributeType']['name']) {
			case 'boolean':
				$editForm .= $form->input('ProductAttribute.'.$i.'.value', array(
					'label' => __($attribute['Attribute']['name'], true), 
					'type' => $attribute['AttributeType']['type'], 
//					'checked' => (!isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) && $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['value']) ? 'checked' : ''
					'checked' => true
				));
				break;
			case 'string':
			case 'currency':
			case 'int':
			case 'text':
			case 'float':
				$editForm .= $form->input('ProductAttribute.'.$i.'.value', array(
					'label' => __($attribute['Attribute']['name'], true), 
					'type' => $attribute['AttributeType']['type'], 
					'value' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) ? $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['value'] : ''
				));
				break;
			case 'date':
				$editForm .= $form->input('ProductAttribute.'.$i.'.value', array(
					'label' => __($attribute['Attribute']['name'], true), 
					'type' => $attribute['AttributeType']['type'], 
					'dateFormat' => 'DMY',
					'minYear' => date('Y'),
					'maxYear' => date('Y') + 5,
					'selected' => isset($product['ProductAttribute'][$attribute['Attribute']['attribute_id']]) ? $product['ProductAttribute'][$attribute['Attribute']['attribute_id']]['value'] : ''
				));
				break;
/*			case 'image':
				$file = $form->label('ProductAttribute.'.$i.'.value', __($attribute['Attribute']['url'], true));
				$file .= $form->file('ProductAttribute.'.$i.'.value');
				$editForm .= $html->div('input file', $file);
				break;*/
			case 'select':
				$attributeValues = Set::combine($attribute['AttributeValue'], '{n}.attribute_value_id', '{n}.value');
				$checkboxes = '';
				foreach ($attributeValues as $key => $attributeValue) { 
					$checkboxes .= $form->hidden('ProductAttribute.'.++$i.'.attribute_id', array('value' => $attribute['Attribute']['attribute_id']));
					$checkboxes .= $form->input('ProductAttribute.'.$i.'.value', array('type' => 'checkbox', 'value' => $key, 'label' => __($attributeValue, true)));
				}
				$editForm .= $html->tag('fieldset', $html->tag('legend', __($attribute['Attribute']['name'], true)).$checkboxes);
				break;
			default:
		}
	}
	$editForm .= '</fieldset>';
	echo $editForm .= $form->end(__('save', true));
?>