<?php
	$javascript->link(array('/scriptaculous/js/scriptaculous.js?load=builder', '/core/js/sort'), false);

	if ($session->check('Message.flash')) {
		$session->flash();
	}
?>
<table id="products" summary="products" class="sortable-table">
	<thead>
		<tr>
			<th><?php __('name'); ?></th>
			<th><?php __('attributes set'); ?></th>
			<th><?php __('product type'); ?></th>
			<th><?php __('edit categories'); ?></th>
			<th><?php __('edit attributes'); ?></th>
			<th><?php __('edit prices'); ?></th>
			<th><?php __('edit photos'); ?></th>
			<th><?php __('delete'); ?></th>
		</tr>
	</thead>	
<?php
	$table = '';
	foreach ($products as $product) {
		$table .= '<tr>';
		$table .= '<td>'.Sanitize::html($product['Product']['name']).'</td>';
		$table .= '<td>'.Sanitize::html($product['AttributesSet']['name']).'</td>';
		$table .= '<td>'.Sanitize::html($product['ProductType']['name']).'</td>';
		$table .= '<td>'.$html->link(' ', array('action' => 'editCategories', $product['Product']['url']), array('class' => 'edit')).'</td>';
		$table .= '<td>'.$html->link(' ', array('action' => 'editAttributes', $product['Product']['url']), array('class' => 'edit')).'</td>';
		if ($product['ProductType']['name'] == 'configurable product') {
			$table .= '<td>'.$html->link(' ', array('action' => 'editPrices', $product['Product']['url']), array('class' => 'edit')).'</td>';
		}
		else {
			$table .= '<td></td>';
		}
		$table .= '<td>'.$html->link(' ', array('action' => 'editPhotos', $product['Product']['url']), array('class' => 'edit')).'</td>';
		$table .= '<td>'.$html->link(' ', array('action' => 'delete', $product['Product']['url']), array('class' => 'delete')).'</td>';
		$table .= '</tr>';
	}
	echo $table;
?>
</table>