<?php
	class OrderProduct extends SalesAppModel {
		var $primaryKey = 'order_product_id';
		var $displayField = 'name';
		var $recursive = -1;
		var $validate = array(
			'name' => array(
				'rule' => array('minLengthUrlTrim', '2'),
				'message' => 'min length 2'
			),
		);
		
		var $belongsTo = array(
			'Order' => array(
				'className' => 'Orders.Order',
				'foreignKey' => 'order_product_id',
			),
		);
	}
?>
