-- MySQL dump 10.11
--
-- Host: localhost    Database: eshop
-- ------------------------------------------------------
-- Server version	5.0.70-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `attribute_types`
--

DROP TABLE IF EXISTS `attribute_types`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `attribute_types` (
  `attribute_type_id` int(11) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  `type` varchar(15) default NULL,
  PRIMARY KEY  (`attribute_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `attribute_types`
--

LOCK TABLES `attribute_types` WRITE;
/*!40000 ALTER TABLE `attribute_types` DISABLE KEYS */;
INSERT INTO `attribute_types` VALUES (1,'string','text'),(2,'int','text'),(3,'boolean','checkbox'),(4,'date','date'),(5,'image','file'),(6,'currency','text'),(7,'select','select'),(8,'text','textarea'),(9,'float','text');
/*!40000 ALTER TABLE `attribute_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attribute_values`
--

DROP TABLE IF EXISTS `attribute_values`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `attribute_values` (
  `attribute_value_id` int(11) NOT NULL auto_increment,
  `attribute_id` int(11) default NULL,
  `value` varchar(50) default NULL,
  PRIMARY KEY  (`attribute_value_id`)
) ENGINE=MyISAM AUTO_INCREMENT=96 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `attribute_values`
--

LOCK TABLES `attribute_values` WRITE;
/*!40000 ALTER TABLE `attribute_values` DISABLE KEYS */;
INSERT INTO `attribute_values` VALUES (8,89,'červený'),(9,89,'čierny'),(10,89,''),(11,89,'červený'),(12,89,'čierny'),(13,89,''),(14,89,'0'),(15,NULL,'kam sa prida toto?'),(16,89,''),(17,89,'asdf'),(18,89,'ružovuČká:'),(19,89,'    -             -       .'),(20,89,'ružovuČká:'),(21,89,'    -             -       .'),(22,89,'asdf'),(23,89,'ružovuČká:'),(24,89,'    -             -       .'),(25,89,'asdf'),(26,89,'ružovuČká:'),(27,89,'    -             -       .'),(28,92,'červený'),(29,92,'čierny'),(30,98,'select 1'),(63,98,'option 2'),(90,102,'7.5\"'),(91,102,'8\"'),(92,102,'9\"'),(38,106,'1234'),(64,98,'casca'),(65,98,'ascasca'),(66,98,'Komédia plná nečakaných slovných a situačných zvra'),(45,98,'option 3'),(46,86,'1,7'),(47,86,'1,8'),(48,86,'1,9'),(49,86,'2,0'),(50,86,'2,1'),(51,86,'max'),(52,100,'14\"'),(53,100,'16\"'),(54,100,'17\"'),(55,100,'18\"'),(56,100,'19\"'),(57,100,'20\"'),(88,103,'5x112'),(87,103,'5x110'),(86,103,'5x100'),(67,NULL,'200'),(89,103,'5x120'),(69,110,'1'),(70,110,'2'),(71,110,'3'),(75,110,''),(74,110,''),(76,110,'                     '),(77,110,'asdf'),(78,110,'a'),(79,110,'1'),(93,125,'qwer'),(95,125,'qwerqwet');
/*!40000 ALTER TABLE `attribute_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attributes`
--

DROP TABLE IF EXISTS `attributes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `attributes` (
  `attribute_id` int(11) NOT NULL auto_increment,
  `attributes_set_id` int(11) default NULL,
  `attribute_type_id` int(11) default NULL,
  `name` varchar(50) default NULL,
  `url` varchar(50) default NULL,
  `delete_perm` tinyint(1) default '1',
  `multi` tinyint(1) default '0',
  PRIMARY KEY  (`attribute_id`)
) ENGINE=MyISAM AUTO_INCREMENT=128 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `attributes`
--

LOCK TABLES `attributes` WRITE;
/*!40000 ALTER TABLE `attributes` DISABLE KEYS */;
INSERT INTO `attributes` VALUES (127,30,5,'photo','photo',0,0),(83,21,5,'photo','photo',1,0),(84,21,5,'photo2','photo2',1,0),(81,21,6,'price','price',0,0),(126,30,6,'price','price',0,0),(125,21,7,'qwerty','qwerty',1,1),(94,21,4,'date','date',1,0),(123,29,5,'photo','photo',0,0),(95,21,1,'string','string',1,0),(96,21,1,'intint','intint',1,0),(97,21,3,'boolean','boolean',1,0),(98,21,7,'select','select',1,0),(99,23,6,'price','price',0,0),(100,23,7,'Priemer','priemer',1,0),(102,23,7,'Šírka','sirka',1,0),(103,23,7,'Rozteč','roztec',1,1),(104,23,1,'Prevedenie','prevedenie',1,0),(122,29,6,'price','price',0,0),(107,23,5,'Obrázok','obrazok',1,0),(111,23,8,'Základný popis','zakladnypopis',1,0);
/*!40000 ALTER TABLE `attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attributes_sets`
--

DROP TABLE IF EXISTS `attributes_sets`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `attributes_sets` (
  `attributes_set_id` int(11) NOT NULL auto_increment,
  `name` varchar(50) default NULL,
  PRIMARY KEY  (`attributes_set_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `attributes_sets`
--

LOCK TABLES `attributes_sets` WRITE;
/*!40000 ALTER TABLE `attributes_sets` DISABLE KEYS */;
INSERT INTO `attributes_sets` VALUES (21,'základný set'),(23,'Disky'),(29,'qwerqwe'),(30,'test');
/*!40000 ALTER TABLE `attributes_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_menu`
--

DROP TABLE IF EXISTS `backend_menu`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `backend_menu` (
  `menu_id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) default NULL,
  `lft` int(11) default NULL,
  `rght` int(11) default NULL,
  `url` varchar(100) default NULL,
  `name` varchar(100) default NULL,
  `plugin` varchar(30) default NULL,
  `controller` varchar(30) default NULL,
  `action` varchar(30) default NULL,
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `backend_menu`
--

LOCK TABLES `backend_menu` WRITE;
/*!40000 ALTER TABLE `backend_menu` DISABLE KEYS */;
INSERT INTO `backend_menu` VALUES (10,NULL,1,32,'catalogue','catalogue','eshop','products',''),(11,NULL,33,40,'sales','sales','sales','orders',''),(12,NULL,41,42,'customers','customers','eshop','customers',''),(13,NULL,43,44,'newsletters','newsletters','eshop','newsletters',''),(14,NULL,45,46,'cms','cms','eshop','cms',''),(15,NULL,47,48,'reports','reports','eshop','reports',''),(16,NULL,49,54,'system','system','eshop','system',''),(18,10,2,7,'products','products','eshop','',''),(19,18,3,4,'manage-products','manage products','eshop','products','index'),(20,18,5,6,'add-product','add product','eshop','products','add'),(21,10,8,13,'categories','categories','eshop','',''),(22,21,11,12,'add-category','add category','eshop','categories','add'),(23,21,9,10,'manage-categories','manage categories','eshop','categories','index'),(24,10,14,19,'photos','photos','eshop','',''),(25,24,15,16,'manage-photos','manage photos','eshop','photos','index'),(26,24,17,18,'add-photo','add photo','eshop','photos','add'),(27,10,20,25,'attributes','attributes','eshop','',''),(28,27,21,22,'manage-attributes','manage attributes','eshop','attributes','index'),(29,27,23,24,'add-attribute','add attribute','eshop','attributes','add'),(30,10,26,31,'attributes-sets','attributes sets','eshop','',''),(31,30,27,28,'manage attributes sets','manage attributes sets','eshop','attributes_sets','index'),(32,30,29,30,'add-attributes-set','add attributes set','eshop','attributes_sets','add'),(33,16,50,53,'system','system','eshop','',''),(34,33,51,52,'restore-defaults','restore defaults','eshop','backup','restore_defaults'),(37,38,37,38,'manage-invoices','manage invoices','sales','invoices',''),(36,38,35,36,'manage-orders','manage orders','sales','orders',''),(38,11,34,39,'orders','orders','','','');
/*!40000 ALTER TABLE `backend_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `categories` (
  `category_id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) default NULL,
  `lft` int(11) default NULL,
  `rght` int(11) default NULL,
  `url` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY  (`category_id`),
  UNIQUE KEY `url` (`url`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (41,NULL,7,18,'potahy','Poťahy'),(42,NULL,1,6,'disky','Disky'),(43,42,2,3,'klasicke','Klasické'),(44,42,4,5,'luxusne','Luxusné'),(45,NULL,19,28,'dreva','Drevá'),(46,41,12,13,'softy','Softy'),(47,41,14,15,'travy','Trávy'),(48,41,10,11,'sendvice','Sendviče'),(49,41,8,9,'anti','Anti'),(50,45,20,21,'utocne-off','Útočné (OFF)'),(51,45,22,23,'univerzalne-all','Univerzálne (ALL)'),(52,45,24,25,'obranne-def','Obranné (DEF)'),(53,45,26,27,'penholder','Penholder');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_attributes`
--

DROP TABLE IF EXISTS `config_attributes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `config_attributes` (
  `config_attribute_id` int(11) NOT NULL auto_increment,
  `attribute_id` int(11) default NULL,
  `product_id` int(11) default NULL,
  PRIMARY KEY  (`config_attribute_id`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `config_attributes`
--

LOCK TABLES `config_attributes` WRITE;
/*!40000 ALTER TABLE `config_attributes` DISABLE KEYS */;
INSERT INTO `config_attributes` VALUES (8,122,2),(7,123,2),(63,103,2),(62,102,2),(61,100,2);
/*!40000 ALTER TABLE `config_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `i18n`
--

DROP TABLE IF EXISTS `i18n`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `i18n` (
  `id` int(10) NOT NULL auto_increment,
  `locale` varchar(6) NOT NULL,
  `model` varchar(255) NOT NULL,
  `foreign_key` int(10) NOT NULL,
  `field` varchar(255) NOT NULL,
  `content` text,
  PRIMARY KEY  (`id`),
  KEY `locale` (`locale`),
  KEY `model` (`model`),
  KEY `row_id` (`foreign_key`),
  KEY `field` (`field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `i18n`
--

LOCK TABLES `i18n` WRITE;
/*!40000 ALTER TABLE `i18n` DISABLE KEYS */;
/*!40000 ALTER TABLE `i18n` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `images` (
  `image_id` int(11) NOT NULL auto_increment,
  `photo_id` int(11) NOT NULL,
  `file` varchar(100) NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  PRIMARY KEY  (`image_id`),
  KEY `photo_id` (`photo_id`)
) ENGINE=MyISAM AUTO_INCREMENT=445 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` VALUES (433,147,'/files/images_40x40/49de7b74-8b50-4cbd-8898-05d5c0a80002.jpg',40,40),(434,147,'/files/images_100x100/49de7b74-fd0c-4f44-9a5d-05d5c0a80002.jpg',100,100),(435,147,'/files/images_0x0/49de7b74-c20c-44a7-ad77-05d5c0a80002.jpg',0,0),(436,148,'/files/images_40x40/49de7b74-bd50-47e2-b255-05d5c0a80002.jpg',40,40),(437,148,'/files/images_100x100/49de7b74-b60c-4e89-aeae-05d5c0a80002.jpg',100,100),(438,148,'/files/images_0x0/49de7b75-f434-457c-b713-05d5c0a80002.jpg',0,0),(439,149,'/files/images_40x40/49df17fb-51a0-42e5-b422-7ea4c0a80002.jpg',40,40),(440,149,'/files/images_100x100/49df17fb-8320-4bd3-99c8-7ea4c0a80002.jpg',100,100),(441,149,'/files/images_0x0/49df17fb-da74-4128-bdfd-7ea4c0a80002.jpg',0,0),(442,150,'/files/images_40x40/49df17fb-7c78-4743-9553-7ea4c0a80002.jpg',40,40),(443,150,'/files/images_100x100/49df17fb-5148-45ab-bc64-7ea4c0a80002.jpg',100,100),(444,150,'/files/images_0x0/49df17fb-db00-4285-a08f-7ea4c0a80002.jpg',0,0);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_attributes`
--

DROP TABLE IF EXISTS `order_attributes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `order_attributes` (
  `order_attribute_id` int(11) NOT NULL auto_increment,
  `attribute_type_id` int(11) NOT NULL,
  `name` varchar(50) default NULL,
  PRIMARY KEY  (`order_attribute_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `order_attributes`
--

LOCK TABLES `order_attributes` WRITE;
/*!40000 ALTER TABLE `order_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_products`
--

DROP TABLE IF EXISTS `order_products`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `order_products` (
  `order_product_id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY  (`order_product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `order_products`
--

LOCK TABLES `order_products` WRITE;
/*!40000 ALTER TABLE `order_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_products_attributes`
--

DROP TABLE IF EXISTS `order_products_attributes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `order_products_attributes` (
  `order_product_attribute_id` int(11) NOT NULL auto_increment,
  `order_product_id` int(11) NOT NULL,
  `order_attribute_id` int(11) NOT NULL,
  `value` varchar(255) default NULL,
  PRIMARY KEY  (`order_product_attribute_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `order_products_attributes`
--

LOCK TABLES `order_products_attributes` WRITE;
/*!40000 ALTER TABLE `order_products_attributes` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_products_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_states`
--

DROP TABLE IF EXISTS `order_states`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `order_states` (
  `order_state_id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`order_state_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `order_states`
--

LOCK TABLES `order_states` WRITE;
/*!40000 ALTER TABLE `order_states` DISABLE KEYS */;
INSERT INTO `order_states` VALUES (1,'ordred'),(2,'confirmed'),(3,'denied'),(4,'suspended'),(5,'shipped');
/*!40000 ALTER TABLE `order_states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `orders` (
  `order_id` int(11) NOT NULL auto_increment,
  `bill_name` varchar(100) default NULL,
  `ship_name` varchar(100) default NULL,
  `price` float NOT NULL default '0',
  `date` date default NULL,
  `status` int(11) default NULL,
  PRIMARY KEY  (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` VALUES (1,'','',100.2,'2009-04-18',1);
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `photos`
--

DROP TABLE IF EXISTS `photos`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `photos` (
  `photo_id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `file` varchar(50) default NULL,
  PRIMARY KEY  (`photo_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `photos`
--

LOCK TABLES `photos` WRITE;
/*!40000 ALTER TABLE `photos` DISABLE KEYS */;
INSERT INTO `photos` VALUES (1,'configurable product 1','configurable product 1','49e759ba-778c-46d1-b401-47272760a68b.jpg'),(2,'simple product 1','simple product 1','49e75a2d-881c-4b74-a76b-478b2760a68b.jpg'),(3,'simple product 1','simple product 1','49e76037-61d0-4fa1-8584-4bd72760a68b.jpg');
/*!40000 ALTER TABLE `photos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `product_prices`
--

DROP TABLE IF EXISTS `product_prices`;
/*!50001 DROP VIEW IF EXISTS `product_prices`*/;
/*!50001 CREATE TABLE `product_prices` (
  `attribute_group_id` int(11),
  `url` varchar(50),
  `config_value` longtext
) ENGINE=MyISAM */;

--
-- Table structure for table `product_types`
--

DROP TABLE IF EXISTS `product_types`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `product_types` (
  `product_type_id` int(11) NOT NULL auto_increment,
  `name` varchar(30) default NULL,
  PRIMARY KEY  (`product_type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `product_types`
--

LOCK TABLES `product_types` WRITE;
/*!40000 ALTER TABLE `product_types` DISABLE KEYS */;
INSERT INTO `product_types` VALUES (1,'simple product'),(2,'configurable product');
/*!40000 ALTER TABLE `product_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `products` (
  `product_id` int(11) NOT NULL auto_increment,
  `url` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `attributes_set_id` int(11) default NULL,
  `product_type_id` int(11) default NULL,
  `sorting` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`product_id`),
  UNIQUE KEY `url` (`url`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (2,'configurable-product-1','configurable product 1',23,2,0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_attributes`
--

DROP TABLE IF EXISTS `products_attributes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `products_attributes` (
  `product_attribute_id` int(11) NOT NULL auto_increment,
  `product_id` int(11) NOT NULL,
  `attribute_id` int(11) NOT NULL,
  `value` text,
  `attribute_group_id` int(11) default NULL,
  PRIMARY KEY  (`product_attribute_id`),
  KEY `product_id` (`product_id`),
  KEY `attribute_id` (`attribute_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1220 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `products_attributes`
--

LOCK TABLES `products_attributes` WRITE;
/*!40000 ALTER TABLE `products_attributes` DISABLE KEYS */;
INSERT INTO `products_attributes` VALUES (1207,2,107,'1',NULL),(1205,2,99,'14',2),(1192,0,107,'',NULL),(1204,2,103,'89',2),(1203,2,103,'86',2),(1202,2,102,'91',2),(1201,2,100,'56',2),(1200,2,99,'12',1),(1199,2,103,'87',1),(1198,2,103,'88',1),(1197,2,102,'90',1),(1196,2,100,'52',1),(1206,2,107,'1',NULL),(1194,2,111,'123',NULL),(1193,2,104,'125123',NULL),(1137,73,99,'12',2),(1136,73,100,'52',2),(1129,73,103,'87',1),(1130,73,103,'89',1),(1131,73,102,'90',1),(1132,73,100,'52',1),(1133,73,99,'15',1),(1134,73,103,'88',2),(1135,73,102,'90',2);
/*!40000 ALTER TABLE `products_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_categories`
--

DROP TABLE IF EXISTS `products_categories`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `products_categories` (
  `product_category_id` int(11) NOT NULL auto_increment,
  `product_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`product_category_id`),
  UNIQUE KEY `products_categories` (`category_id`,`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=150 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `products_categories`
--

LOCK TABLES `products_categories` WRITE;
/*!40000 ALTER TABLE `products_categories` DISABLE KEYS */;
INSERT INTO `products_categories` VALUES (148,2,42);
/*!40000 ALTER TABLE `products_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `users` (
  `user_id` int(11) NOT NULL auto_increment,
  `username` varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL,
  `email` varchar(50) NOT NULL,
  PRIMARY KEY  (`user_id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'marwin','37995237da6c50d38a7f1c5b06cbf1e9','marwin22@gmail.com'),(2,'pixo','a61db3bab0882220c7fb2ea6ab20eb1d','pixo@pixo.sk');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Final view structure for view `product_prices`
--

/*!50001 DROP TABLE `product_prices`*/;
/*!50001 DROP VIEW IF EXISTS `product_prices`*/;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`pixo`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `product_prices` AS (select sql_cache `eshop`.`products_attributes`.`attribute_group_id` AS `attribute_group_id`,`eshop`.`attributes`.`url` AS `url`,if((`eshop`.`attribute_types`.`type` = _utf8'select'),(select `eshop`.`attribute_values`.`value` AS `value` from `attribute_values` where (`eshop`.`attribute_values`.`attribute_value_id` = `eshop`.`products_attributes`.`value`)),`eshop`.`products_attributes`.`value`) AS `config_value` from ((`products_attributes` join `attributes` on((`eshop`.`products_attributes`.`attribute_id` = `eshop`.`attributes`.`attribute_id`))) join `attribute_types` on((`eshop`.`attribute_types`.`attribute_type_id` = `eshop`.`attributes`.`attribute_type_id`))) where ((`eshop`.`products_attributes`.`product_id` = 47) and (`eshop`.`products_attributes`.`attribute_group_id` is not null)) order by `eshop`.`products_attributes`.`attribute_group_id`,`eshop`.`attributes`.`url`) */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2009-04-23 12:40:28
