﻿using System;
using System.Data.SqlClient;

/// <summary>
/// Trieda zaobalujuca hru
/// </summary>
public class Game
{

    public String[][] state;
    public int Tid,Gid, TurnamentID, WhiteID, BlackID, Result, TurnsWODeath, WhiteKingMoved, BlackKingMoved, StateFlag;

	public Game(int WID, int BID, int TID)
	{
        // konsturktor nahodnej hry

        state = new String[8][];
        for (int i = 0; i < 8; i++) state[i] = new String[8];

        state[7][0] = "WR";
        state[7][1] = "WK";
        state[7][2] = "WB";
        state[7][3] = "WQ";
        state[7][4] = "WG";
        state[7][7] = "WR";
        state[7][5] = "WB";
        state[7][6] = "WK";
        state[0][0] = "BR";
        state[0][1] = "BK";
        state[0][2] = "BB";
        state[0][3] = "BQ";
        state[0][4] = "BG";
        state[0][7] = "BR";
        state[0][5] = "BB";
        state[0][6] = "BK";
        for (int i = 0; i < 8; i++) { state[1][i] = "BP"; state[6][i] = "WP"; }
        for (int i = 2; i < 6; i++) for (int j = 0; j < 8; j++) { state[i][j] = "  "; }

        WhiteID = WID;
        BlackID = BID;
        Result = 0;
        TurnsWODeath = 0;
        WhiteKingMoved = 0;
        BlackKingMoved = 0;
        TurnamentID = TID;
        StateFlag = 0;
        Tid = -1;
	}

    // parser z databazy
    public void fillFromDatabase(int Gid, SqlConnection connection)
    {
        connection.Open();
        string SQLStatement = "select * from Games where (Gid = '" + Gid + "')";
        SqlCommand SQLCommand = new SqlCommand(SQLStatement, connection);

        SqlDataReader dtResult = null;
        
        dtResult = SQLCommand.ExecuteReader();

        if (dtResult.Read())
        {
            WhiteID = Int32.Parse(dtResult["WhiteID"].ToString());
            BlackID = Int32.Parse(dtResult["BlackID"].ToString());
            Result = Int32.Parse(dtResult["Result"].ToString()); ;
            TurnsWODeath = Int32.Parse(dtResult["TurnsWODeath"].ToString());
            String wkm = dtResult["WhiteKingMoved"].ToString();
            WhiteKingMoved = 0;
            if (wkm.Equals("True")) WhiteKingMoved = 1;
            String bkm = dtResult["BlackKingMoved"].ToString();
            BlackKingMoved = 0;
            if (bkm.Equals("True")) BlackKingMoved = 1;
            TurnamentID = Int32.Parse(dtResult["Tid"].ToString());
            StateFlag = Int32.Parse(dtResult["StateFlag"].ToString());

            string dbState = dtResult["State"].ToString();

            for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) {
                state[i][j] = "";
                state[i][j] += dbState[i * 16 + 2 * j];
                state[i][j] += dbState[i * 16 + 2 * j + 1];
            }

        }

        connection.Close();

    }

    // ukladac do databazy
    public void insertToDatabase(SqlConnection connection) {

        connection.Open();

        String dbState = "";
        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) { dbState += state[i][j]; }

        String values = "('"+Result+"','"+WhiteID+"','"+BlackID+"','"+dbState+"','"+TurnsWODeath+"','"+WhiteKingMoved+"','"+BlackKingMoved+"','"+Tid+"','"+StateFlag+"')";

        String SQLStatement2 = "insert into Games (Result, WhiteID, BlackID, State, TurnsWODeath, WhiteKingMoved, BlackKingMoved, Tid, StateFlag) values "+values;
        SqlCommand SQLCommand2 = new SqlCommand(SQLStatement2, connection);
        SQLCommand2.ExecuteNonQuery();
        connection.Close();

    }

    private bool isAttacked(int x, int y, char attackingSide){
        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) if (state[i][j][0] == attackingSide)
        {
           String[,] s = getRange(attackingSide, state[i][j][1], i,j);
           if (s[x, y].Equals("1"))
           {
               return true;
           }
        }
        return false;
    }

    public bool checkCheck(char defendingSide) {
        char attackingSide = 'W';
        if (defendingSide == 'W') attackingSide = 'B';
        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) if (state[i][j][0]==defendingSide && state[i][j][1]=='G') {
            if (isAttacked(i, j, attackingSide)) return true;
            return false;
        }
        return false;
    }

    public bool checkPat(char defendingSide) {
        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) if (state[i][j][0] == defendingSide) {
            String[,] s = getRange(defendingSide, state[i][j][1], i, j);
            for (int k = 0; k < 8; k++) for (int l = 0; l < 8; l++) {
                if (s[k, l].Equals("1")) return false;
            }
        }
        return true;
    }

    public bool checkCheckMate(char defendingSide)
    { 
        //zistit, ci existuje tah braniaceho hraca, po ktorom nebude v sachu
        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++)if (state[i][j][0]==defendingSide) {
            //zistime range danej figurky
            String[,] s = getRange(state[i][j][0],state[i][j][1],i,j);
            for (int k = 0; k < 8; k++) for (int l = 0; l < 8; l++) if (s[k,l].Equals("1")) {
                //mame kam potiahnut
                String[][] newState = new String[8][];
                for (int m = 0; m < 8; m++) newState[m] = new String[8];
                for (int m = 0; m < 8; m++) for (int n = 0; n < 8; n++) { newState[m][n] = state[m][n]; }
                Game _g = new Game(this.WhiteID, this.BlackID, this.Tid );
                newState[k][l] = newState[i][j];
                newState[i][j] = "  ";
                _g.state = newState;
                if (!_g.checkCheck(defendingSide)) return false;
            }

        }
        return true;
    }


    public void updateToDatabase(int gidPar, SqlConnection connection) {

        connection.Open();

        String dbState = "";
        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) { dbState += state[i][j]; }

        String values = "set Result = '" + Result + "',";
        values += "State = '" + dbState + "',";
        values += "TurnsWODeath = '" + TurnsWODeath + "',";
        values += "WhiteKingMoved = '" + WhiteKingMoved + "',";
        values += "BlackKingMoved = '" + BlackKingMoved + "',";
        values += "StateFlag = '" + StateFlag + "'";
        String SQLStatement2 = "update Games "+values+" where Gid = '"+gidPar+"'";
        SqlCommand SQLCommand2 = new SqlCommand(SQLStatement2, connection);
        SQLCommand2.ExecuteNonQuery();
        connection.Close();

    }

    public String[,] vratim;
    int mySide = 'W';

    void set(int x, int y)
    {
        if (x < 0 || x > 7) return;
        if (y < 0 || y > 7) return;
        vratim[x,y] = "1";
        return;
    }

    int jeFigurka(int x, int y) {
        if (x < 0 || x > 7) return 0;
        if (y < 0 || y > 7) return 0;
        if (state[x][y].Equals("  ")) return 0;
        if (state[x][y][0] == mySide) return 1;
        return 2;
    }

    public String[,] getRange(char color, char chessman, int px, int py){


        mySide = color;
        vratim = new String[8,8];

        for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) { vratim[i,j] = "0"; }

        if (chessman == 'R'){
            //rook
            int[] dx = new int[4]{-1,0,1,0};
            int[] dy = new int[4]{0,-1,0,1};
            for (int i = 0; i < 4; i++) {
                for (int j = 1; j < 8; j++) {
                    int cx = px + dx[i]*j;
                    int cy = py + dy[i]*j;
                    if (jeFigurka(cx, cy) != 1) set(cx, cy);
                    if (jeFigurka(cx, cy)!=0) break;
                }
            }
        }

        //TODO - branie mimochodom? :)
        if (chessman == 'P'){
            //peasant
            if (color == 'W') { 
                //x sa znizi
                if (jeFigurka(px - 1, py) == 0)
                {
                    set(px - 1, py);
                    if (px == 6) if (jeFigurka(px - 2, py) == 0) { set(px - 2, py); }
                }
                

                if (jeFigurka(px - 1, py - 1) == 2) set(px - 1, py - 1);
                if (jeFigurka(px - 1, py + 1) == 2) set(px - 1, py + 1);
            }
            if (color == 'B') { 
                //x sa zvysi
                if (jeFigurka(px + 1, py) == 0)
                {
                    set(px + 1, py);
                    if (px == 1) if (jeFigurka(px + 2, py) == 0) { set(px + 2, py); }
                }

                if (jeFigurka(px + 1, py - 1) == 2) set(px + 1, py - 1);
                if (jeFigurka(px + 1, py + 1) == 2) set(px + 1, py + 1);

            }
        }

        if (chessman == 'K'){
            //knight
            if (jeFigurka(px+1,py+2)!=1) set(px + 1, py + 2);
            if (jeFigurka(px + 1, py - 2) != 1) set(px + 1, py - 2);
            if (jeFigurka(px + 2, py - 1) != 1) set(px + 2, py - 1);
            if (jeFigurka(px + 2, py + 1) != 1) set(px + 2, py + 1);
            if (jeFigurka(px - 1, py + 2) != 1) set(px - 1, py + 2);
            if (jeFigurka(px - 1, py - 2) != 1) set(px - 1, py - 2);
            if (jeFigurka(px - 2, py + 1) != 1) set(px - 2, py + 1);
            if (jeFigurka(px - 2, py - 1) != 1) set(px - 2, py - 1);
        }

        if (chessman == 'B'){
            //bishop
            int[] dx = new int[4] { -1, -1, 1, 1 };
            int[] dy = new int[4] { 1, -1, 1, -1 };
            for (int i = 0; i < 4; i++)
            {
                for (int j = 1; j < 8; j++)
                {
                    int cx = px + dx[i] * j;
                    int cy = py + dy[i] * j;
                    if (jeFigurka(cx, cy) != 1) set(cx, cy);
                    if (jeFigurka(cx, cy) != 0) break;
                }
            }

        }   

        if (chessman == 'Q'){
            //queen
            int[] dx = new int[4] { -1, -1, 1, 1 };
            int[] dy = new int[4] { 1, -1, 1, -1 };
            for (int i = 0; i < 4; i++)
            {
                for (int j = 1; j < 8; j++)
                {
                    int cx = px + dx[i] * j;
                    int cy = py + dy[i] * j;
                    if (jeFigurka(cx, cy) != 1) set(cx, cy);
                    if (jeFigurka(cx, cy) != 0) break;
                }
            }
            dx = new int[4] { -1, 0, 1, 0 };
            dy = new int[4] { 0, -1, 0, 1 };
            for (int i = 0; i < 4; i++)
            {
                for (int j = 1; j < 8; j++)
                {
                    int cx = px + dx[i] * j;
                    int cy = py + dy[i] * j;
                    if (jeFigurka(cx, cy) != 1) set(cx, cy);
                    if (jeFigurka(cx, cy) != 0) break;
                }
            }
        }

        if (chessman == 'G'){
            //kong
            for (int i = -1; i <= 1; i++) for (int j = -1; j <= 1; j++)if (i!=0 || j!=0) {
                if ( jeFigurka(px+i,py+j) != 1 ) set(px + i, py + j);
            }

            String[,] vratimbk = vratim;
            int p72 = 0; int p76 = 0; int p02 = 0; int p06 = 0;

            if (color == 'W' && WhiteKingMoved == 0) {
                if (state[7][0].Equals("WR") && state[7][1].Equals("  ") && state[7][2].Equals("  ") && state[7][3].Equals("  "))
                {
                    //vsetky policka musia byt mimo range
                    int ok=1;
                    for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++)if (state[i][j][0] == 'B') {
                        String[,] s = getRange('B', state[i][j][1], i, j);
                        if (s[7, 0].Equals("1")) ok = 0;
                        if (s[7, 1].Equals("1")) ok = 0;
                        if (s[7, 2].Equals("1")) ok = 0;
                        if (s[7, 3].Equals("1")) ok = 0;
                        if (s[7, 4].Equals("1")) ok = 0;
                    }
                    if (ok==1){
                        //set(7,3);
                        p72 = 1;
                    }
                }
                //dolava
                if (state[7][7].Equals("WR") && state[7][6].Equals("  ") && state[7][5].Equals("  "))
                {
                    //vsetky policka musia byt mimo range
                    int ok=1;
                    for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++)if (state[i][j][0] == 'B') {
                        String[,] s = getRange('B', state[i][j][1], i, j);
                        if (s[7, 7].Equals("1")) ok = 0;
                        if (s[7, 6].Equals("1")) ok = 0;
                        if (s[7, 5].Equals("1")) ok = 0;
                        if (s[7, 4].Equals("1")) ok = 0;
                    }
                    if (ok==1){
                        //set(7,6);
                        p76 = 1;
                    }
                }

            }

            if (color == 'B' && BlackKingMoved == 0) {
                if (state[0][0].Equals("BR") && state[0][1].Equals("  ") && state[0][2].Equals("  ") && state[0][3].Equals("  "))
                {
                    //vsetky policka musia byt mimo range
                    int ok = 1;
                    for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) if (state[i][j][0] == 'W')
                            {
                                String[,] s = getRange('W', state[i][j][1], i, j);
                                if (s[0, 0].Equals("1")) ok = 0;
                                if (s[0, 1].Equals("1")) ok = 0;
                                if (s[0, 2].Equals("1")) ok = 0;
                                if (s[0, 3].Equals("1")) ok = 0;
                                if (s[0, 4].Equals("1")) ok = 0;
                            }
                    if (ok == 1)
                    {
                       // set(0, 3);
                        p02 = 1;
                    }
                }
                //dolava
                if (state[0][7].Equals("BR") && state[0][6].Equals("  ") && state[0][5].Equals("  "))
                {
                    //vsetky policka musia byt mimo range
                    int ok = 1;
                    for (int i = 0; i < 8; i++) for (int j = 0; j < 8; j++) if (state[i][j][0] == 'B')
                            {
                                String[,] s = getRange('W', state[i][j][1], i, j);
                                if (s[0, 7].Equals("1")) ok = 0;
                                if (s[0, 6].Equals("1")) ok = 0;
                                if (s[0, 5].Equals("1")) ok = 0;
                                if (s[0, 4].Equals("1")) ok = 0;
                            }
                    if (ok == 1)
                    {
                        //set(0, 6);
                        p06 = 1;
                    }
                }
            
            }

            vratim = vratimbk;
            if (p06==1) vratim[0, 6] = "1";
            if (p76==1) vratim[7, 6] = "1";
            if (p02==1) vratim[0, 2] = "1";
            if (p72==1) vratim[7, 2] = "1";
        }

        return vratim;    
    }

}
