//pri odosielani formularu potrebujeme odstranit defaultne hodnoty
function clearDefaultValues(form){
	if(form.name.value == 'meno')
		form.name.value = ''; 
	if(form.surname.value == 'priezvisko')
		form.surname.value = ''
	if(form.email.value == 'e-mail')
		form.email.value = '' 	
}

function clearDefaultValuesGroups(form){
	if(form.weekday.value == ''){
		alert("Musíte vybrať deň cvičení");
		return false; 
	}
	if(form.time.value == 'čas'){
		alert("Musíte zadať čas cvičení");
		return false;
	}
	if(form.capacity.value == 'kapacita'){
		alert("Musíte zadať kapacitu cvičení");
		return false;
	} 
	if(!isInteger(form.capacity.value)){
		alert("Kapacita musí byť číslo typu integer");
		return false;
	}
	if(form.capacity.value == 'kapacita')
		form.capacity.value = '';
	if(form.time.value == 'čas')		
		form.time.value = '';
	if(form.place.value == 'miesto')
		form.place.value = ''
	if(form.teacher.value == 'cvičiaci')
		form.teacher.value = '' 
	return true;	
}

function makeExcerciseGroupEditable(id){
	makeRowEditable(id,new Array("day","time","place","capacity","teacher","action"),new Array("function","text","text","text","text","button"),"saveExcerciseGroup");
}

function makeStudentEditable(id){
	makeRowEditable(id,new Array("name","surname","email","eg","action"),new Array("text","text","text","function","button"),"saveGroupThenStudent");
}

function saveExcerciseGroup(id){
	saveRowData(id,new Array("day","time","place","teacher","capacity","action"),new Array("select","text","text","text","text","button"),"excerciseGroupsTable");
}

//funkcia na ukladanie studenta a priradenie do skupiny
function saveGroupThenStudent(id){
	var egCombo = byId("selectEGCombo"+id);
	var eg = byId("eg_box_"+id);
	var where = "";
	if(egCombo.className == 'save')
		where = "&where=id="+eg.nextSibling.value;
	if(egCombo.value)	
		databaseRequest("studentsInGroupsTable",
					egCombo.className,
					"student_id="+id+"&group_id="+egCombo.value+"&confirmed="+eg.parentNode.childNodes[2].value+where,
					function(){},
					function(){
						if(xmlHttp.readyState==4){
							if((egCombo.className == 'save' && xmlHttp.responseText=='OK') || (egCombo.className == 'add' && isInteger(xmlHttp.responseText))){
								eg.innerHTML = egCombo.options[egCombo.selectedIndex].text;
								if(egCombo.className == 'add'){ //ak priradime studenta k skupine a predtym nebol, tak ho musime vyhodit z tabulky unassigned_student
									var usid = eg.nextSibling.value;
									eg.nextSibling.value = xmlHttp.responseText;
									databaseRequest("unassignedStudentsTable",
													"delete",
													"where=id="+usid,
													function(){},
													function(){
														if(xmlHttp.readyState==4){
															if(xmlHttp.responseText=='OK'){
																saveRowData(id,new Array("name","surname","email","action"),new Array("text","text","text","button"),"studentsTable");
															}
															else{
																alert("CHYBA: študent bol priradený ku skupine, ale nebol vymazaný z tabuľky nepriradených študentov. Preto sa v zozname môže vyskytnúť viackrát. Túto chybu odstránite vymazaním riadku z tabuľky unassigned_students s id "+usid);
															}
														}
													});
								}
								else{
									//ak sa ulozila skupina, tak ulozime aj dalsie udaje
									saveRowData(id,new Array("name","surname","email","action"),new Array("text","text","text","button"),"studentsTable");
								}
							}
							else{
								alert("chyba pri priradeni do skupiny: "+xmlHttp.responseText);
							}
						}
					});
	else{ //ak sme nevybrali ziadnu skupinu 
		if(egCombo.className == 'save'){ //ale predtym bola vybrata, tak ju musime deletnut a pridat studenta do unassigned_students
			databaseRequest("unassignedStudentsTable",
							"add",
							"student_id="+id+"&course_term_id="+byId("course_term_id").value+"&confirmed="+eg.parentNode.childNodes[2].value,
							function(){},
							function(){
								if(xmlHttp.readyState==4){
									if(isInteger(xmlHttp.responseText)){
										var usid = eg.nextSibling.value;
										eg.nextSibling.value = xmlHttp.responseText;
										databaseRequest("studentsInGroupsTable",
														"delete",
														"where=id="+usid,
														function(){},
														function(){
															if(xmlHttp.readyState==4){
																if(xmlHttp.responseText=="OK"){
																	eg.innerHTML = "";
																	saveRowData(id,new Array("name","surname","email","action"),new Array("text","text","text","button"),"studentsTable");
																}
																else
																	alert("CHYBA: študent bol priradený do tabuľky nepriradených študentov, ale nepodarilo zmazať jeho priradenie ku skupine. Preto sa v zozname môže vyskytnúť viackrát. Túto chybu odstránite vymazaním riadku z tabuľky students_in_groups s id "+usid);
															}
														});										
									}
									else
										alert("chyba pri vyradeni do skupiny: "+xmlHttp.responseText);
								}
							});
			
		}
		else{
			//ulozime udaje o studentovi
			saveRowData(id,new Array("name","surname","email","action"),new Array("text","text","text","button"),"studentsTable");
			eg.innerHTML = "";
		}
	}				
}

function egReplace(id,inner){
	var eg = byId("eg_box_"+id);
	var combo = byId("groupCombo").innerHTML;
	combo = combo.replace(">"+inner+"<"," selected='selected'>"+inner+"<");
	if(eg.innerHTML == "")
		combo = combo.replace("<select","<select id='selectEGCombo"+id+"' class='add'");
	else	
		combo = combo.replace("<select","<select id='selectEGCombo"+id+"' class='save'");
	return combo;
}

function dayReplace(id,inner){
	var out = "<select id='edit_day"+id+"'><option></option>";
	var days = new Array("Pon","Uto","Str","Štv","Pia","Sob","Ned");
	for(var i=0;i<5;i++)
		if(inner==days[i])
			out += "<option value='"+(i+1)+"' selected='selected'>"+days[i]+"</option>";
		else	
			out += "<option value='"+(i+1)+"'>"+days[i]+"</option>";
	out += "</select>";
	return out;	
}

//funkcia odstrani studenta z predmetu
function removeStudent(id){
	var eg = byId("eg_box_"+id);
	var usid = eg.nextSibling.value;
	if(eg.innerHTML == ""){ //ak nema priradenu ziadnu skupinu
		table = "unassignedStudentsTable";
	}
	else
		table = "studentsInGroupsTable";
	databaseRequest(table,
					"delete",
					"where=id="+usid,
					function(){},
					function(){
						if(xmlHttp.readyState==4){
							if(xmlHttp.responseText=="OK"){
								while(eg.tagName != "TR")
									eg = eg.parentNode;
								var removedStudent = document.createElement("option");
								removedStudent.innerHTML = byId("surname_box_"+id).innerHTML+" "+byId("name_box_"+id).innerHTML;
								removedStudent.value = id;
								try{byId("selectOtherStudents").add(removedStudent,null)}
								catch(ex){byId("selectOtherStudents").add(removedStudent)} // IE only
								databaseRequest(table, //ak ho zmazeme, pozreme sa ci je este v nejakej skupine. Ak nie, tak ponukneme moznost vymazat ho uplne
												"onefieldresult",
												"query=SELECT COUNT(*) FROM (SELECT id FROM unassigned_students WHERE student_id="+id+" UNION SELECT id FROM students_in_groups WHERE student_id="+id+")a",
												function(){},
												function(){
													if(xmlHttp.readyState==4){
														if(isInteger(xmlHttp.responseText)){
															if(xmlHttp.responseText == 0 && confirm("Tento študent nie je prihlásený na žiadny iný predmet. Chcete ho zmazať zo systému úplne?")){
																databaseRequest("studentsTable",
																			"delete",
																			"where=id="+id,
																			function(){},
																			function(){
																				if(xmlHttp.readyState==4){
																					if(xmlHttp.responseText=="OK")
																						eg.parentNode.removeChild(eg);
																					else
																						alert("CHYBA: Študent bol odstránený z tohto predmetu, ale nie z celého systému\n"+xmlHttp.responseText);
																				}
																			});
															}
															else
																eg.parentNode.removeChild(eg);
														}
														else
															eg.parentNode.removeChild(eg);	
													}
												});	
							}
							else
								alert("CHYBA: študent nebol z predmetu odstránený.\n"+xmlHttp.responseText);
						}
					});			
}

//na zmenu predmetu
function makeCourseEditable(){
	var box = byId("selectedCourseBox").parentNode;
	box.innerHTML = box.firstChild.nodeValue+" <form action='"+location.href+"' method='post' style='display:inline'>"+byId("coursesCombo").innerHTML+"<input type='submit' name='submit_course' value='zmeň' /></form>";
	box.className = "";
}

function confirmStudent(id){
	var eg = byId("eg_box_"+id);
	var usid = eg.nextSibling.value;
	if(eg.innerHTML == "") //ak nema priradenu ziadnu skupinu
		table = "unassignedStudentsTable";
	else
		table = "studentsInGroupsTable";
	var actionBox = byId("action_box_"+id);
	links = actionBox.getElementsByTagName("a");
	for(var i=0;i<links.length;i++)
		if(links[i].innerHTML == "potvrď")
			var confirmButton = links[i];
	databaseRequest(table,
				"save",
				"confirmed=1&where=id="+usid,
				function(){confirmButton.innerHTML = "potvrdzujem"},
				function(){
					if(xmlHttp.readyState==4){
						if(xmlHttp.responseText=="OK"){
							while(eg.tagName != "TR")
								eg = eg.parentNode;
							for(var i=1;i<eg.cells.length;i++)	
								eg.cells[i].style.backgroundColor = "#ffd498";
							eg.parentNode.childNodes[2].value = 't';
							actionBox.removeChild(confirmButton);	
						}
						else
							alert("CHYBA: Nepodarilo sa potvrdiť. \n"+xmlHttp.responseText);
					}
				});
}