<?php

/**
 * @author peter jurco aka [oumaXm1
 * @version 0.2 postgres alpha
 * 
 * Class to lists data from database.
 * Features (that are done or will be):
 * 	>> any select query
 *  >> easy formatting (table or pure)
 * 	>> user-controled output - column-patterning [done 29.1.2008]
 *  >> AJAX paging [done 23.4.2009]
 *  >> categorizing and tabing (e.g. A-K,L-Z)
 *  >> easy query filtering [done 29.1.2008]
 *  >> AJAX filtering without refreshing page 
 *  >> data depending formatting (e.g. in column temperature higher temperature will have more red background...)
 *  >> aggregating
 *  >> sorting [done 8.5.2008]
 *  >> unioning queries
 *  >> stylizing numbering [alpha done 19.2.2008]
 *  >> subquering [done 23.2.2008]
 *  >> and more...
 *  TODO: special css file containing all classes from listing.
 *  TODO: overovacia metoda na to, ze ak pouzivame dynamicke triedenie alebo strankovanie, tak ci su attachnute JS subory. Ak nie, vlozit ich do tabulky pages_attached_files a refreshnut stranku
 * 
 * CHANGES: 
 *  >> constructor has now name as a required parameter
 *  >> We can use a javascript file (for sublisting and AJAX paging) and CSS file for formatting
 *     These files are: INCLUDE_PATH/js/listing.js and STYLES_PATH/listing.css where INCLUDE_PATH and STYLES_PATH are in config file.
 *  >> TODO : pripojit tie subory nejako automaticky... zatial sa to da iba riadkom v DB
 */
class listing{
	public $name;
	public $rows = array();
	public $cols = array();
	private $query;
	
	public $sublisting;
	public $subquery = array('connectTO'=>NULL,
							 'connectWidth'=>NULL,
							 'display'=>false, //if display set to NULL or false there will be a JS function on onclick action which will display subquery listing
							 );
	/**
	 * when we want to limit a result from bottom
	 * When is setted, must be setted also $this->limit, otherwise, there isn't any influence of this var to result
	 * @var integer bottom limit in query
	 */ 
	private $limit_from;
	
	/**
	 * when we want to limit count of result rows.
	 * @var integer count of result rows
	 */
	private $limit;
	private $filters = array();
	public $error = array();
	public $htmlFormat = 'table'; //yet, only allowed value :)
	public $renderer; //object, which render listing to HTML
	public $htmlAfter = ""; //html code added after listing
	
	//numbering rows control variables
	public $displayNumbering = true;
	public $numberingStyle = 'arabian'; //allowed values: 'arabian','alphabet' TODO:'roman','binary'...;
	public $numberingCharacter = ''; //all string values allowed (e.g. '#','no.','c.') 

	//ci zobrazit hlavicku listingu
	public $displayHeader = true;
	
	public $stylizers = array();
	
	//order by
	private $ordered;
	private $order_dir = 'asc';
	private $no_result_message = 'Nenajdeny ziaden zaznam.';
	
	//sorting
	public $sortEnabled = true;  //if set to true headers will automatically convert to a link
	public $sortMode = 'dynamic'; //can be 'normal' (with page refresh) or 'dynamic' (javascript-based)
	
	//paging
	public $pagingEnabled = true; //if set to true, there will be page-navigation if count of rows is greater than $per_page variable 
	public $pagingMode = 'dynamic'; //can be 'normal' (with page refresh) or 'dynamic' (ajax-based)
	public $perPage = 20; //rows in one page
	public $pagingPosition = 'both'; //where display paging navigation. can be 'top','bottom' or 'both'
	public $page = 1; //which page has to be shown (this variable is changing as we browse through the pages)
	public $call_from = "page"; //if we call listing from page or from ajax request
	public $boxPosition = "main"; //in which position is box in which is listing.
	
	//count of total rows (without limit setting by paging)
	public $totalCount = 0;
	public $showCount = true; //if show count of rows of listing
	
	public function __construct($sql,$name,$format='table'){
		$this->query = $sql;
		$this->name = $name;
		$this->htmlFormat = $format; //selekcia renderera by mohla byt az po vykonani query
		$this->call_from = isset($_GET['ajax'])?"ajax":"page";
		switch($this->htmlFormat){
			case 'table':
				$this->renderer = new listingTableRenderer($this);
			break;
		}
		if(isset($_GET['listing']) && $_GET['listing']==$name){
			if(isset($_GET['orderby']))
				$this->setOrderBy(pg_escape_string($_GET['orderby']." ".$_GET['dir']));
			if(isset($_GET['listing_page'])){
				$this->page = pg_escape_string($_GET['listing_page']);
			}
		}
		
		//checking if css and js files are attached. If not, attach it.
		if(PAGE_ID){ //constant defined in index.php
			$attachedFiles = new pagesAttachedFilesTable;
			$change = false;
			if(!$attachedFiles->loadWhere("page_id=".PAGE_ID." AND file_name='include/js/listing.js'")){
				$attachedFiles->set("page_id",PAGE_ID);
				$attachedFiles->set("file_name","include/js/listing.js");
				$attachedFiles->set("file_type","javascript");
				$attachedFiles->add();
				$change = true;
			}
			if(!$attachedFiles->loadWhere("page_id=".PAGE_ID." AND file_name='css/listing.css'")){
				$attachedFiles->set("page_id",PAGE_ID);
				$attachedFiles->set("file_name","css/listing.css");
				$attachedFiles->set("file_type","stylesheet");
				$attachedFiles->add();
				$change = true;
			}
			if($change)
				JSrefresh();
		}	
	}
	
	/**
	 * function validate SQL
	 * >> we are interisting only about SELECT queries
	 */
	public function validate(){
		return preg_match("/^SELECT/i",$this->query);
	}
	
	/**
	 * Add filter - 
	 */
	public function addFilter($condition){
		if(is_string($condition))
			$this->filters[] = $condition;
	}
	
	/**
	 * pop a last added filter 
	 */
	public function popFilter(){
		return array_pop($this->filters);
	}		
	
	/**
	 * Delete all Filters 
	 */
	public function deleteFilters(){
		$this->filters = array();
	}	

	/**
	 * Delete all Rows 
	 */
	public function deleteRows(){
		$this->rows = array();
	}		
	
	/**
	 * @return string - all filters as one SQL condition, implode with operator AND
	 */
	public function getConditions(){
		if(count($this->filters))
			return '('.implode(') AND (',$this->filters).')';
		else
			return '1=1';	
	}
	
	/**
	 * Inverse function to getConditions(). From SQL conditions string return array of filters
	 */
	public function splitFilters($condition){
		if($condition!="1=1")
			return explode(') AND (',substr(substr($condition,1),0,-1));
		else
			return array();	 
	}
	
	public function execute(){
		if(!$this->validate()){
			$this->error("Unvalid SQL query. SQL query must begin with 'SELECT' phrase.",__FUNCTION__);
			exit;
		}

		//if we use ajax filtering we use filters from GET params
		if(isset($_GET['listing']) && $_GET['listing']==$this->name && isset($_GET['filter'])){
			$this->deleteFilters();
			$filter =  stripslashes($_GET['filter']); //neviem preco, ale netreba tu robir urldecode aj ked v JS spravim urlencode
			//echo substr($_GET['filter'],1);
			if($filter){
				$new_filters = $this->splitFilters($filter);
				foreach($new_filters as $flt)
					$this->addFilter($flt);
			}
		}
					
		//set limit if paging
		if($this->pagingEnabled){
			//get total count of select without limit
			$sql = "SELECT COUNT(*)AS allrows FROM (".$this->getQuery().")AS counting";
			if(!$result = pg_query(DB_CONN,$sql)){
				$this->error("Error in SQL query: ".pg_last_error(DB_CONN)."<br/>Query: $sql",__FUNCTION__);
				exit;	
			}
			$row = pg_fetch_assoc($result);
			$this->totalCount = $row['allrows'];
			//set limit
			$this->nthXrows($this->page,$this->perPage);
		}
		//executing query in mySQL db, const DB_CONN is initialize in beginnig of the page
		$sql = $this->getQuery();
		if(!$result = pg_query(DB_CONN,$sql)){
			$this->error("Error in SQL query: ".pg_last_error(DB_CONN)."<br/>Query: $sql",__FUNCTION__);
			exit;	
		}
		
		//fill rows of object listing with result rows
		while($row = pg_fetch_assoc($result)){
			$this->rows[] = $row;
		}	
	}
	
	/**
	 * Function puts together all parts of SQL query
	 */
	private function getQuery(){
		$sql = $this->query.' WHERE '.$this->getConditions();
		if(isset($this->ordered))
			$sql .= ' ORDER BY '.$this->ordered.' '.$this->order_dir;
		if(isset($this->limit)){
			$sql .= ' LIMIT '.$this->limit;
			if(isset($this->limit_from))
				$sql .=  ' OFFSET '.$this->limit_from;
		}
		return $sql;
	}
	
	/**
	 * Sets a column to show and its parameters
	 * @param string colName name of column of sql-query-result
	 * @param string colHeader displayed name of column
	 * @param string sort set orderby parameter, which will be used in sorting. When is set to empty string, will use a $colName, when is set to 'unsortable' there will be not sorting available
	 * @param string pattern pattern of displayed data. Use {columnName} to display value of columnName. 
	 */
	public function displayColumn($colName,$colHeader,$sort='',$pattern=''){
		if($pattern=='')
			$pattern="{".$colName."}";
		$this->cols[] = array('name'=>$colName,
							  'header'=>$colHeader,
							  'sort'=>$sort===''?$colName:$sort, //special value is 'unsortable' - see listingRenderer
							  'display'=>$pattern);
	}
	
	public function toHtml(){
		return $this->renderer->parseListing().$this->htmlAfter;
	}
	
	public function firstXrows($x){
		$this->nthXrows(1,$x);
	}
	/**
	 * set limits to get first, second, ... nth X rows 
	 */
	public function nthXrows($n,$x){
		$this->limit = $x;
		$this->limit_from = ($n-1)*$x;
	}
	
	//We can add subquery, which will assigned to each row of main query
	public function setSubquery($connectTo,$connectWidth,$display=false){
		$this->subquery['connectTo']=$connectTo;
		$this->subquery['connectWidth']=$connectWidth;
		$this->subquery['display']= $display;
	}
	
	public function addStylizer($stylizer){
		$this->stylizers[] = $stylizer;
	}
	
	public function getCount(){
		return count($this->rows);
	}
	
	public function setOrderBy($item,$dir='asc'){
		$this->ordered = $item;
		$this->order_dir = $dir;
	}
	
	public function setNoResultMessage($message){
		$this->no_result_message = $message;
	}

	public function getNoResultMessage(){
		return $this->no_result_message;
	}


    /**
     * Funkcia, ktora zaznamena chybu
   	*/
	private function error($text,$function_name="none"){
		$this->error[__CLASS__][$function_name][] = $text;
	}
	
	/**
	 * Function add some HTML code after listing. It's useful for sublistings
	 */
	public function addHTML($html){
		$this->htmlAfter = $html;
	}
	
}

?>