<?php
class listingTableRenderer extends listingRenderer{
	private $listing;
	private $LDF;
	private $classes = array('table'=>array(),
							 'row'=>array(),
							 'cell'=>array());
	private $params = array('table'=>'',
							 'tr'=>'',
							 'th'=>'',
							 'td'=>'');


	public function __construct($listing){
		$this->listing = $listing;
	}
	
	public function parseListing(){
		$html = "";
		if($this->listing->pagingEnabled && $this->listing->pagingMode == 'dynamic' && $this->listing->call_from != "ajax")
			$html .= "<div id='listingWrapper_".$this->listing->name."'>"; 
		if($this->listing->sortEnabled && $this->listing->sortMode == 'dynamic')
			$this->addClass('table','sortable');
		if($this->listing->showCount)
			$html .= "\n<div class='listingCountRows'>Záznamov: ".$this->listing->totalCount."</div>";
		if($this->listing->pagingEnabled && $this->listing->totalCount>$this->listing->perPage){
			$pagesHtml .= "<div class='pagesNavigation'>";
			$pageCount = ceil($this->listing->totalCount/$this->listing->perPage);
			for($i=1;$i<=$pageCount;$i++){
				if($this->listing->page != $i){
					if($this->listing->pagingMode == 'dynamic')
						$link = "javascript:displayListingPage(\"".$this->listing->name."\",$i,\"".$this->listing->getConditions()."\",\"".$this->listing->boxPosition."\")";
					else{ //ak je mod pre strankovanie normal
						$page_url = new url(array('action'=>array('add'=>array( 'listing'=>$this->listing->name,
							 													'listing_page'=>$i))));
						$link = $page_url->makeUrl();
					}
					$pagesHtml .= "<span class='pageNumber'><a href='$link' title='choď na stranu $i'>$i</a></span>";
				}
				else
					$pagesHtml .= "<span class='pageNumber'>$i</span>";
			}		
			$pagesHtml .= "</div>";
		}
		if($this->listing->pagingPosition == 'top' || $this->listing->pagingPosition == 'both')
			$html .= $pagesHtml; 
		if($this->listing->totalCount > 0){	
			$html .= "\n<table id='".$this->listing->name."' class='listingTable ".implode(' ',$this->classes['table'])."' ".$this->params["table"].">";
			if($this->listing->displayHeader)
				$html .= $this->parseHeader();
			switch($this->listing->numberingStyle){
				case 'arabian':
					$number = (($this->listing->page-1)*$this->listing->perPage)+1;
				break;
				case 'alphabet':
					$number = chr(ord('a')+(($this->listing->page-1)*$this->listing->perPage));
				break;	
			}
			$html .= "<tfoot></tfoot><tbody>";
			foreach($this->listing->rows as $row){ 
				$html .= $this->parseRow($row,$number);
				$number++;
			}
			$html .= "\n</tbody></table>";
		}
		else
			$html .= "<div class='noResultMessage'>".$this->listing->getNoResultMessage()."</div>";
		if($this->listing->pagingPosition == 'bottom' || $this->listing->pagingPosition == 'both')
			$html .= $pagesHtml; 
		if($this->listing->pagingEnabled && $this->listing->pagingMode == 'dynamic' && $this->listing->call_from != "ajax")
			$html .= "</div>"; 
		return $html;			
	}

	public function parseHeader(){
		$col = 0;
		$html .= "\n\t<thead><tr class='listingHeader'>";
		if($this->listing->displayNumbering){
			$col++;
			$html .= "\n\t\t<th class='unsortable numberColumn' ".$this->params["th"].">".$this->listing->numberingCharacter."</th>";
		}
		foreach($this->listing->cols as $column){
			if($this->listing->sortEnabled && $column['sort']!='unsortable' &&$this->listing->sortMode == 'normal'){
					$dir = (!isset($_GET['dir']) || ($_GET['dir']=='desc' && $_GET['orderby']==$column['sort']) || $_GET['orderby']!=$column['sort'])?'asc':'desc';
			  		$sort_url = new url(array('action'=>array('add'=>array( 'listing'=>$this->listing->name,
						 													'orderby'=>$column['sort'],
																		  	'dir'=>$dir))));
					$html .= "\n\t\t<th><a href='".$sort_url->makeUrl()."' title='zoradiť podľa: $column[header]' ".$this->params["th"].">$column[header]</a></th>";																		  	
			}
			else{
				if($column['sort']=='unsortable')
					$html .= "\n\t\t<th class='unsortable' ".$this->params["th"].">$column[header]</th>";
				else	
					$html .= "\n\t\t<th ".$this->params["th"].">$column[header]</th>";
			}
			$col++;	
		}
		$html .= "\n\t</tr></thead>";
		return $html;
	}
	
	public function parseRow($row,$number=0){
		$countCol = count($this->listing->cols);
		$htmlSubQuery = '';
		
		if(isset($this->listing->sublisting)){
			$class = '';
			$params = '';
			$connect_id = $row[$this->listing->subquery['connectTo']];
			if(!$this->listing->subquery['display']){
				$class = "hidden";
				$params = "onclick='displaySublisting(\"".$this->listing->name."\",$connect_id)' onmouseover='changeRowBGColor(this,\"#FFFFEE\")' onmouseout='changeRowBGColor(this,\"\")'";
			}

			$htmlSubQuery .= "\n\t<tr class='subqueryRow $class' id='".$this->listing->name."_subqueryRow$connect_id'>";
			if($this->listing->displayNumbering)
			  $htmlSubQuery .= "\n\t<th></th>";
			$htmlSubQuery .= "\n\t<td colspan='".$countCol."'>";
			$htmlSubQuery .= $this->addSubquery($row);
			$htmlSubQuery .= "\n\t</td>";
			$htmlSubQuery .= "\n\t</tr>";
		}
		$id_number = isset($row['id'])?$row['id']:$number;
		$html = "\n\t<tr class='listingRow ".implode(' ',$this->classes['row'])."' id='".$this->listing->name."_row_$id_number' $params ".$this->params["tr"].">";
		if($this->listing->displayNumbering)
			$html .= "\n\t\t<th class='numberColumn'>".$number."</th>";
		$colspan=0;	
		foreach($this->listing->cols as $column){
		    if(isset($this->LDF))
			   $formatters = $this->LDF->getFormatters($column['name'],$row);
			if($colspan==0 ){  
				$colspanstr = (isset($formatters['colspan']))?"colspan='".$formatters['colspan']."'":"";
				$colspan = (isset($formatters['colspan']))?$formatters['colspan']-1:0;
				if(count($this->classes['cell']))
					$html .= "\n\t\t<td $colspanstr class='".implode(' ',$this->classes['cell'])."' $formatters[css] ".$this->params["td"].">";
				else	
					$html .= "\n\t\t<td $colspanstr $formatters[css] ".$this->params["td"].">";
				$html .= isset($formatters['text'])?$formatters['text']:$this->parseContent($row,$column);
				$html .= "</td>";
			}
			else
				$colspan--;
		}
		$html .= "\n\t</tr>";

		return $html.$htmlSubQuery;
	}
	
	private function parseContent($row,$column){

		preg_match_all("/\{([^}^{]+)\}/",$column['display'],$matches);
		foreach($matches[1] as $key=>$columnName){
			$matches[0][$key] = '/'.$matches[0][$key].'/';  
		  	$matches[1][$key] = $row[$columnName];
		}
		return preg_replace($matches[0],$matches[1],$column['display']);	
	}
	
	public function setLDF($ldf){
		if ($ldf instanceof listingDataFormatting){
			$this->LDF = $ldf;
		}
	}
	
	public function addClass($level, $className){
		$this->classes[$level][] = $className;
	}

	public function setParam($element, $param){
		$this->params[$element] = $param;
	}
		
	private function addSubquery($rowToConnect){
		$sublisting = $this->listing->sublisting;
		$subquery = $this->listing->subquery;
		$sublisting->deleteRows();
		$sublisting->addFilter("$subquery[connectWidth]='".$rowToConnect[$subquery['connectTo']]."'");
		$sublisting->execute();
		$sublisting->popFilter();
		return $sublisting->toHtml();	
	}
	
}
?>
