<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty sort_objects modifier plugin
 *
 * Type:     modifier<br>
 * Name:     sort_objects<br>
 * Purpose:  Sort objects according to their values, getting from get method
 * @author   Peter Jurco <petrojurco at gmail dot com>
 * @param array
 * @param sorted by item
 * @return array
 */
$mySortObjectsSortedByItem = "name";
 
function smarty_modifier_sort_objects($array,$sortby)
{
    global $mySortObjectsSortedByItem;
    if (!is_array($array) || !$array)
        return $array;
    $mySortObjectsSortedByItem = $sortby;
    usort($array,"cmp_obj");
    return $array;
    
}

function cmp_obj($a, $b)
{
    global $mySortObjectsSortedByItem;
    $al = strtolower($a->get($mySortObjectsSortedByItem));
    $bl = strtolower($b->get($mySortObjectsSortedByItem));
    if ($al == $bl) {
        return 0;
    }
    return ($al > $bl) ? +1 : -1;
}

?>
