<?php
/**
 * @author peter jurco aka [oumaXm1
 * @version 0.1 alpha
 * 
 * Class for generate and manipulate URL with query string
 * There's a many ways how to generate URLs: 
 * Example. We are in script with url home/index.php?page=editme&x=3&y=4
 * $url = new url(23);  	//url=='home/index.php?id=23'
 * $url = new url('home');  //url=='home/index.php?page=home'
 * $url = new url(array('page'=>'home','xx'=>'yy'));  //url=='home/index.php?page=home&x=3&y=4&xx=yy'
 * $url = new url(array('page'=>'home','xx'=>'yy'),false);  //url=='home/index.php?page=home&xx=yy'
 * OR MORE SOFISTICATED:
 * $url = new url(array('action'=>array('add'=>array('q'=>13,'name'=>'ferdo'),
 * 										'delete'=>array('x','y'))));  
 * //url=='home/index.php?page=editme&q=13&name=ferdo'
 * 
 * 
 * TODO: changing directory.
 */

class url{
	private $script;
	private $args = array();
	public function __construct($params,$fromItself=true){
		$this->script = $_SERVER['PHP_SELF'];
		//robi URL adresu a vychadza z aktualnej
		if($fromItself){ //rozbije query string a ulozi ho ako asociativne pole
			$relations=explode("&",$_SERVER['QUERY_STRING']);
			foreach($relations as $rel){
				$atoms = explode("=",$rel);
				$this->addParam($atoms[0],$atoms[1]);
			}
		}
		if(is_array($params)){
			if(isset($params['action']) && is_array($params['action'])){
				foreach($params['action'] as $action=>$values){
					switch($action){
						case 'add':
							foreach($values as $var=>$val)
								$this->addParam($var,$val);
						break;
						case 'delete':
							foreach($values as $var)
								$this->deleteParam($var);
						break;						
					}
				}
			}
			else{
				foreach($params as $var=>$val)
					$this->addParam($var,$val);
			}
		}
		elseif(is_numeric($params))
			return $this->script."?id=".$params;
		elseif(is_string($params))
			return $this->script."?page=".$params;
			
		return $this->makeUrl();		
	}
	
	public function addParam($var,$val){
		$this->args[$var] = $val;
	}
	
	public function deleteParam($var){
		if(isset($this->args[$var]))
			unset($this->args[$var]);
	}

	public function clearParams(){
		$this->args = array();
	}

	public function makeUrl(){
		$url = $this->script;
		if(count($this->args)){
			$url .= '?';
			$params = array();
			foreach($this->args as $var=>$val)
				$params[] = $var.'='.$val;
			$url .= implode('&',$params);	 
		}
		return $url;
	}
}

?>