<?php
class setListBox extends box {
	
	public function display(){
		$coursesTermsTable = new coursesTermsTable;
		$course_name_mode = $this->page->user->getSetting('display_course_name_mode');
		$term_str = $this->page->user->getSetting('display_terms')?"|| ' ' || ct.term ":"";
		$default_course = $this->page->user->getSetting('default_course_term_id');
		$open_set = $this->page->user->getSetting('open_set_id');
		$list = new listing("SELECT sets.*,c.name AS course_full, c.short_name AS course_short, ct.year $term_str AS term, ct.id as term_id FROM sets " .
							"INNER JOIN courses_terms AS ct ON sets.course_term_id=ct.id " .
							"INNER JOIN courses AS c ON c.id=ct.course_id ","set_basic_listing");
		if($default_course)
			$list->addFilter("ct.id = ".$default_course);
		$list->setOrderBy("date_from","desc");
		$list->perPage = 15;
		$list->sortEnabled = false;
		$list->setNoResultMessage("Žiadna zostava úloh sa nenašla.");
		$list->execute();
		$list->displayColumn('name','názov');
		$list->displayColumn('course','predmet','',"{course_$course_name_mode}");
		$list->displayColumn('term','semester');
		$list->displayColumn('date_from','zverejnené&nbsp;od');
		$list->displayColumn('date_to','zverejnené&nbsp;do');
		$list->displayColumn('id','','unsortable');
		$list->numberingCharacter = "#";

		$stylizer1 = new listingStylizer; 
		$stylizer1->addFormatting(array("function",array("dateFormat","date_from","to_display_with_time"),"date_from"));
		$stylizer1->addFormatting(array("function",array("dateFormat","date_to","to_display_with_time"),"date_to"));
		$stylizer1->addFormatting(array("function",array("setListBox::listingActions","id","name","date_from","date_to"),"id"));
		$stylizer1->addCondition(array("1","==","1"));

		$stylizer2 = new listingStylizer; 
		$stylizer2->addFormatting(array("css","background-color: #dfa699","all"));
		$stylizer2->addCondition(array("id","==",$open_set));

		$stylizer3 = new listingStylizer; 
		$stylizer3->addFormatting(array("colspan","2","date_from"));
		$stylizer3->addFormatting(array("text","v čase cvičení","date_from"));
		$stylizer3->addFormatting(array("css","text-align:center","date_from"));
		$stylizer3->addCondition(array("week","!=",""));

		
		$ldf = new listingDataFormatting;
		$ldf->addStylizer($stylizer1);
		$ldf->addStylizer($stylizer2);
		$ldf->addStylizer($stylizer3);
		$list->renderer->setLDF($ldf);

		if($_GET['ajax']){
			echo $list->toHtml();
			exit;
		}
		
		//hlasky systemu
		$labels = new labelsTable;
		$this->add("listing",$list);				
		$this->add("tagCombo",$labels->getCombo("name","id","1=1","name",true,"onchange='selectTag(this)'"));
		$this->add("termCombo",$coursesTermsTable->getCoursesCombo("course_term",null,$this->page->user,true,'onchange="if(this.value){this.form.termFilterInput.value = \'ct.id=\'+this.value;} else{this.form.termFilterInput.value = \'1=1\'} filterListing(\''.$list->name.'\',byId(\'filtersWrapper\'))"'));
		$this->add("message",$this->getMessage($_GET['message_id']));
		parent::display();
	}
	
	//funkcia pouzita v stylizeri pripojeneho k listingu. 
	//vracia akcie. nepouziva sa ako pattern, pretoze jeden button moze mat dva rozne tvary
	//ak je funkcia zverejnena, nahradi button zverejnit na prestat zverejnovat
	public function	listingActions($id,$name,$dateFrom,$dateTo){
		$actions = "<a href='index.php?page=set_edit&set_id=$id' class='button'>edituj</a>";
		$actions .= "<a href='index.php?page=set_edit&open_set_id=$id' class='button'>otvoriť</a>";
		$actions .= "<a href='javascript:if(confirm(\"Naozaj chcete zmazať $name?\")) location.href=\"index.php?page=set_edit&delete_set_id=$id\"' class='button'>vymaž</a>";
		//ak je uloha zverejnena tak dame tlacidlo prestat zverejnovat. Inak dame tlacidlo zverejnovat
		if(strtotime($dateFrom)<time() && (strtotime($dateTo)>time()|| $dateTo=='date_to' ))
			$actions .= "<a href='index.php?page=set_edit&unpublish_set_id=$id' class='button'>nezverejňovať</a>";
		else
			$actions .= "<a href='index.php?page=set_edit&publish_set_id=$id' class='button'>zverejniť</a>";	

		return $actions;
	}
	
	//vracia text spravy po vykonani danej akcie
	public function getMessage($message_id){
		switch($message_id){
			case '1':
				$message = array("text"=>"Zostava bola úspešne zmazaná.",'type'=>"success");
			break;	
			case '2':
				$message = array("text"=>"Zostavu sa nepodarilo zmazať.",'type'=>"error");
			break;	
			case '3':
				$message = array("text"=>"Zostava bola úspešne zverejnená.",'type'=>"success");
			break;	
			case '4':
				$message = array("text"=>"Zostavu sa nepodarilo zverejniť.",'type'=>"error");
			break;	
			case '5':
				$message = array("text"=>"Zostava už nie je zverejnená.",'type'=>"success");
			break;	
			case '6':
				$message = array("text"=>"Zostavu sa nepodarilo prestať zverejňovať.",'type'=>"error");
			break;
			case '7':
				$message = array("text"=>"Zostavu sa nepodarilo otvoriť.",'type'=>"error");
			break;					
		}
		return $message;		
	}
	
	public function setTitle(){
		return "Zoznam zostáv";
	}
}
?>